/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.BaseDelegatingExecutionFactory;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

@Translator(name="record-logging", description="A translator logging all results returned by translators.")
public class RecordLoggingExecutionFactory<F, C>
extends BaseDelegatingExecutionFactory<F, C> {
    @Override
    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        ProcedureExecution execution = this.getDelegate().createDirectExecution(arguments, command, executionContext, metadata, connection);
        return (ProcedureExecution)Proxy.newProxyInstance(RecordLoggingExecutionFactory.class.getClassLoader(), new Class[]{ProcedureExecution.class}, (InvocationHandler)new LoggingHandler(execution, executionContext));
    }

    @Override
    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        ProcedureExecution execution = this.getDelegate().createProcedureExecution(command, executionContext, metadata, connection);
        return (ProcedureExecution)Proxy.newProxyInstance(RecordLoggingExecutionFactory.class.getClassLoader(), new Class[]{ProcedureExecution.class}, (InvocationHandler)new LoggingHandler(execution, executionContext));
    }

    @Override
    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        ResultSetExecution execution = this.getDelegate().createResultSetExecution(command, executionContext, metadata, connection);
        return (ResultSetExecution)Proxy.newProxyInstance(RecordLoggingExecutionFactory.class.getClassLoader(), new Class[]{ResultSetExecution.class}, (InvocationHandler)new LoggingHandler(execution, executionContext));
    }

    @Override
    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, C connection) throws TranslatorException {
        UpdateExecution execution = this.getDelegate().createUpdateExecution(command, executionContext, metadata, connection);
        return (UpdateExecution)Proxy.newProxyInstance(RecordLoggingExecutionFactory.class.getClassLoader(), new Class[]{UpdateExecution.class}, (InvocationHandler)new LoggingHandler(execution, executionContext));
    }

    private static final class LoggingHandler
    implements InvocationHandler {
        private final Execution execution;
        private final ExecutionContext executionContext;

        private LoggingHandler(Execution execution, ExecutionContext executionContext) {
            this.execution = execution;
            this.executionContext = executionContext;
        }

        @Override
        public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
            try {
                Object result = arg1.invoke((Object)this.execution, arg2);
                if (arg1.getName().equals("next")) {
                    LogManager.log((int)6, (String)"org.teiid.COMMAND_LOG", (Object)(this.executionContext.getRequestId() + " " + result));
                } else if (arg1.getName().equals("getUpdateCounts")) {
                    LogManager.log((int)6, (String)"org.teiid.COMMAND_LOG", (Object)(this.executionContext.getRequestId() + " " + Arrays.toString((int[])result)));
                } else if (arg1.getName().equals("getOutputParameterValues")) {
                    LogManager.log((int)6, (String)"org.teiid.COMMAND_LOG", (Object)(this.executionContext.getRequestId() + " " + Arrays.toString((Object[])result)));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

