/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.yahoo;

import java.util.Arrays;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.yahoo.YahooExecution;

@Translator(name="yahoo", description="A translator for testing to obtain stock quotes from Yahoo web site")
public class YahooExecutionFactory
extends ExecutionFactory<Object, Object> {
    public static final int YAHOO_MAX_SET_SIZE = 100;

    public YahooExecutionFactory() {
        this.setMaxInCriteriaSize(100);
        this.setSourceRequiredForMetadata(false);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public void start() throws TranslatorException {
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connectionFactory) throws TranslatorException {
        return new YahooExecution((Select)command);
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean isSourceRequired() {
        return false;
    }

    public void getMetadata(MetadataFactory metadataFactory, Object connection) throws TranslatorException {
        Table t = metadataFactory.addTable("Stock");
        metadataFactory.addColumn("symbol", "string", (ColumnSet)t);
        Column c = metadataFactory.addColumn("last", "double", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("date", "date", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("time", "time", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("change", "double", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("open", "double", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("high", "double", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("low", "double", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        c = metadataFactory.addColumn("volume", "biginteger", (ColumnSet)t);
        c.setSearchType(Column.SearchType.Unsearchable);
        metadataFactory.addAccessPattern("needs_symbol", Arrays.asList("symbol"), t);
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }
}

