/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.yahoo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.Literal;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.yahoo.YahooPlugin;

public class TickerCollectorVisitor
extends HierarchyVisitor {
    private Set<String> tickers = new HashSet<String>();
    private TranslatorException exception;

    public Set<String> getTickers() {
        return this.tickers;
    }

    public TranslatorException getException() {
        return this.exception;
    }

    public void visit(Comparison obj) {
        Expression expr = obj.getRightExpression();
        this.addTickerFromExpression(expr);
    }

    public void visit(In obj) {
        List exprs = obj.getRightExpressions();
        for (Expression expr : exprs) {
            this.addTickerFromExpression(expr);
        }
    }

    private void addTickerFromExpression(Expression expr) {
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            if (literal.getType() == String.class) {
                String ticker = (String)literal.getValue();
                this.tickers.add(ticker.toUpperCase());
            } else {
                this.exception = new TranslatorException(YahooPlugin.Util.getString("TickerCollectorVisitor.Unexpected_type", new Object[]{literal.getType().getName()}));
            }
        } else {
            this.exception = new TranslatorException(YahooPlugin.Util.getString("TickerCollectorVisitor.Unexpected_expression", new Object[]{expr}));
        }
    }

    public static Set<String> getTickers(Condition crit) throws TranslatorException {
        TickerCollectorVisitor visitor = new TickerCollectorVisitor();
        crit.acceptVisitor((LanguageObjectVisitor)visitor);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
        return visitor.getTickers();
    }
}

