/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.yahoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.yahoo.TickerCollectorVisitor;
import org.teiid.translator.yahoo.YahooPlugin;

public class YahooExecution
implements ResultSetExecution {
    public static final String JAVA_PROP_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String JAVA_PROP_HTTP_PROXY_PORT = "http.proxyPort";
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private static SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mma");
    private Select command;
    Iterator<List<?>> results;
    int[] neededColumns;
    private Select query;

    public YahooExecution(Select query) {
        this.query = query;
    }

    public void execute() throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)("Yahoo executing command: " + this.command));
        String yahooUrl = YahooExecution.translateIntoUrl(this.query);
        this.results = this.executeUrl(yahooUrl).iterator();
        this.neededColumns = YahooExecution.getNeededColumns(this.query.getDerivedColumns());
    }

    static String translateIntoUrl(Select query) throws TranslatorException {
        StringBuffer url = new StringBuffer();
        url.append(YahooPlugin.Util.getString("YahooExecution.URL_BEGIN"));
        Set<String> tickers = YahooExecution.getTickers(query);
        if (tickers.size() == 0) {
            throw new TranslatorException(YahooPlugin.Util.getString("YahooExecution.No_tickers"));
        }
        String urlAppendChar = YahooPlugin.Util.getString("YahooExecution.URL_APPEND_CHAR");
        Iterator<String> tickerIter = tickers.iterator();
        url.append(tickerIter.next());
        while (tickerIter.hasNext()) {
            url.append(urlAppendChar);
            url.append(tickerIter.next());
        }
        url.append(YahooPlugin.Util.getString("YahooExecution.URL_END"));
        return url.toString();
    }

    static Set<String> getTickers(Select query) throws TranslatorException {
        Condition crit = query.getWhere();
        if (crit == null) {
            throw new TranslatorException(YahooPlugin.Util.getString("YahooExecution.Must_have_criteria"));
        }
        return TickerCollectorVisitor.getTickers(crit);
    }

    protected List<List<?>> executeUrl(String yahooUrl) throws TranslatorException {
        ArrayList rows = new ArrayList();
        InputStreamReader inSR = null;
        BufferedReader buffReader = null;
        try {
            URL url = new URL(yahooUrl);
            URLConnection conn = url.openConnection();
            conn.connect();
            inSR = new InputStreamReader(conn.getInputStream());
            buffReader = new BufferedReader(inSR);
            String line = null;
            while ((line = buffReader.readLine()) != null) {
                rows.add(YahooExecution.parseLine(line));
            }
            buffReader.close();
            inSR.close();
        }
        catch (MalformedURLException mue) {
            throw new TranslatorException((Throwable)mue, mue.getMessage());
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e, e.getMessage());
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Object> parseLine(String line) {
        ArrayList<Object> row = new ArrayList<Object>();
        StringTokenizer rowToken = new StringTokenizer(line, ",");
        int i = 0;
        while (rowToken.hasMoreTokens()) {
            Object[] params;
            String data = rowToken.nextToken();
            if (data.charAt(0) == '\"') {
                data = data.substring(1, data.length() - 1);
            }
            if (data.equals("N/A")) {
                row.add(null);
            } else if (i == 1 || i == 4 || i == 5 || i == 6 || i == 7) {
                row.add(Double.valueOf(data));
            } else if (i == 8) {
                row.add(new BigInteger(data));
            } else if (i == 2) {
                if (!data.equals("0")) {
                    try {
                        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
                        synchronized (simpleDateFormat) {
                            java.util.Date date = DATE_FORMAT.parse(data);
                            row.add(new Date(date.getTime()));
                        }
                    }
                    catch (ParseException e) {
                        params = new Object[]{data, e.getMessage()};
                        LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)YahooPlugin.Util.gs((BundleUtil.Event)YahooPlugin.Event.TEIID14001, params));
                        row.add(null);
                    }
                } else {
                    row.add(null);
                }
            } else if (i == 3) {
                if (!data.equals("0")) {
                    try {
                        SimpleDateFormat e = TIME_FORMAT;
                        synchronized (e) {
                            java.util.Date time = TIME_FORMAT.parse(data);
                            row.add(new Time(time.getTime()));
                        }
                    }
                    catch (ParseException e) {
                        params = new Object[]{data, e.getMessage()};
                        LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)YahooPlugin.Util.gs((BundleUtil.Event)YahooPlugin.Event.TEIID14002, params));
                        row.add(null);
                    }
                } else {
                    row.add(null);
                }
            } else {
                row.add(data);
            }
            ++i;
        }
        return row;
    }

    static int[] getNeededColumns(List<DerivedColumn> select) throws TranslatorException {
        int[] cols = new int[select.size()];
        Iterator<DerivedColumn> iter = select.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DerivedColumn symbol = iter.next();
            Expression expr = symbol.getExpression();
            if (!(expr instanceof ColumnReference)) {
                throw new TranslatorException(YahooPlugin.Util.getString("YahooExecution.Invalid_select_symbol", new Object[]{expr}));
            }
            Column element = ((ColumnReference)expr).getMetadataObject();
            cols[i] = element.getPosition();
            ++i;
        }
        return cols;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.results.hasNext()) {
            return YahooExecution.projectRow(this.results.next(), this.neededColumns);
        }
        return null;
    }

    static List<Object> projectRow(List<?> row, int[] neededColumns) {
        ArrayList<Object> output = new ArrayList<Object>(neededColumns.length);
        for (int i = 0; i < neededColumns.length; ++i) {
            output.add(row.get(neededColumns[i] - 1));
        }
        return output;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

