/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.yahoo;

import junit.framework.TestCase;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.language.Select;
import org.teiid.translator.yahoo.YahooExecution;

public class TestYahooTranslation
extends TestCase {
    public void helpTestTranslation(String sql, String expectedUrl) throws Exception {
        Command command = FakeTranslationFactory.getInstance().getYahooTranslationUtility().parseCommand(sql);
        String url = YahooExecution.translateIntoUrl((Select)((Select)command));
        TestYahooTranslation.assertEquals((String)"Did not get expected url", (String)expectedUrl, (String)url);
    }

    public void testURLTranslation1() throws Exception {
        this.helpTestTranslation("SELECT LastTrade FROM Yahoo.QuoteServer WHERE TickerSymbol = 'BA'", "http://finance.yahoo.com/d/quotes.csv?s=BA&f=sl1d1t1c1ohgv&e=.csv");
    }

    public void testURLTranslation2() throws Exception {
        this.helpTestTranslation("SELECT LastTrade FROM Yahoo.QuoteServer WHERE TickerSymbol IN ('BA', 'MON')", "http://finance.yahoo.com/d/quotes.csv?s=MON+BA&f=sl1d1t1c1ohgv&e=.csv");
    }

    public void testURLTranslation3() throws Exception {
        this.helpTestTranslation("SELECT LastTrade FROM Yahoo.QuoteServer WHERE TickerSymbol = 'BA' OR TickerSymbol = 'MON'", "http://finance.yahoo.com/d/quotes.csv?s=MON+BA&f=sl1d1t1c1ohgv&e=.csv");
    }
}

