/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.types.GeometryType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.accumulo.AccumuloConnection;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;
import org.teiid.translator.accumulo.AccumuloExecutionFactory;
import org.teiid.translator.accumulo.AccumuloQueryExecution;

public class TestAccumuloQueryExecution {
    private static AccumuloExecutionFactory translator;
    private static TranslationUtility utility;
    private static AccumuloConnection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        translator = new AccumuloExecutionFactory();
        translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"sampledb.ddl")), (String)"sakila", (String)"rental");
        utility = new TranslationUtility((QueryMetadataInterface)metadata);
        MockInstance instance = new MockInstance("teiid");
        connection = (AccumuloConnection)Mockito.mock(AccumuloConnection.class);
        Connector connector = instance.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        Mockito.stub((Object)connection.getInstance()).toReturn((Object)connector);
        Mockito.stub((Object)connection.getAuthorizations()).toReturn((Object)new Authorizations(new String[]{"public"}));
        connector.tableOperations().create("customer", true, TimeType.LOGICAL);
        connector.tableOperations().create("rental", true, TimeType.LOGICAL);
    }

    private Execution executeCmd(String sql) throws TranslatorException {
        Command cmd = utility.parseCommand(sql);
        Execution exec = translator.createExecution(cmd, (ExecutionContext)Mockito.mock(ExecutionContext.class), utility.createRuntimeMetadata(), (Object)connection);
        exec.execute();
        return exec;
    }

    @Test
    public void testExecution() throws Exception {
        this.executeCmd("delete from customer");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (2, 'Joe', 'A')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (1, 'John', 'B')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (3, 'Jack', 'C')");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select * from customer");
        Assert.assertEquals(Arrays.asList(1, "John", "B"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(2, "Joe", "A"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, "Jack", "C"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("Update Customer set firstname = 'Jill' where customer_id = 2");
        this.executeCmd("Update Customer set firstname = 'Jay' where customer_id = 2");
        exec = (AccumuloQueryExecution)this.executeCmd("select customer_id, firstname from customer");
        Assert.assertEquals(Arrays.asList(1, "John"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(2, "Jay"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, "Jack"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select customer_id, firstname from customer where customer_id = 2");
        Assert.assertEquals(Arrays.asList(2, "Jay"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("delete from Customer where customer_id = 2");
        exec = (AccumuloQueryExecution)this.executeCmd("select * from customer");
        Assert.assertEquals(Arrays.asList(1, "John", "B"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, "Jack", "C"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testValueInCQ() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select * from rental");
        Assert.assertEquals(Arrays.asList(1, new BigDecimal("3.99"), 5), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(2, new BigDecimal("5.99"), 2), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, new BigDecimal("11.99"), 1), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testCountStar() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select count(*) from rental");
        Assert.assertEquals(Arrays.asList(4), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testIsNULL() throws Exception {
        this.executeCmd("delete from customer");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (2, 'Joe', 'A')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (1, null, 'B')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (3, 'Jack', 'C')");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select * from customer where firstname IS NULL");
        Assert.assertEquals(Arrays.asList(1, null, "B"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select * from customer where firstname IS NOT NULL");
        Assert.assertNotNull((Object)exec.next());
        Assert.assertNotNull((Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testINOnNonPKColumn() throws Exception {
        this.executeCmd("delete from customer");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (2, 'Joe', 'A')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (1, 'John', 'B')");
        this.executeCmd("insert into customer (customer_id, firstname, lastname) values (3, 'Jack', 'C')");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select * from customer where firstname IN('Joe', 'Jack') order by lastname");
        Assert.assertEquals(Arrays.asList(2, "Joe", "A"), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, "Jack", "C"), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testComparisionOnNonPKColumn() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select rental_id, amount, customer_id from rental where amount > 6.01");
        Assert.assertEquals(Arrays.asList(3, new BigDecimal("11.99"), 1), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(4, new BigDecimal("12.99"), 1), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testANDOnNonPKColumn() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select rental_id, amount, customer_id from rental where amount > 5.99 and amount < 12.99");
        Assert.assertEquals(Arrays.asList(3, new BigDecimal("11.99"), 1), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testOROnNonPKColumn() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select amount from rental where amount > 5.99 or customer_id = 1");
        Assert.assertEquals(Arrays.asList(new BigDecimal("11.99")), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new BigDecimal("12.99")), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testPKColumn() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select amount from rental where rental_id = 3");
        Assert.assertEquals(Arrays.asList(new BigDecimal("11.99")), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testNonPKColumn() throws Exception {
        this.executeCmd("delete from rental");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (1, 3.99, 5)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (2, 5.99, 2)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (3, 11.99, 1)");
        this.executeCmd("insert into rental (rental_id, amount, customer_id) values (4, 12.99, 1)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select amount from rental where customer_id >= 1 and customer_id < 2");
        Assert.assertEquals(Arrays.asList(new BigDecimal("11.99")), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new BigDecimal("12.99")), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testNumericComparision() throws Exception {
        this.executeCmd("delete from smalla");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (1, 1,1.99, 1)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (2, 2, 2.99, 2)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (3, 3, 3.99, 3)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (4, 4, 4.99, 4)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select ROWID from smalla where LONGNUM > 2");
        Assert.assertEquals(Arrays.asList(new Integer(3)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID from smalla where DOUBLENUM > 3");
        Assert.assertEquals(Arrays.asList(new Integer(3)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testSelectRowID() throws Exception {
        this.executeCmd("delete from smalla");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (1, 1,1.99, 1)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (2, 2, 2.99, 2)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select ROWID from smalla");
        Assert.assertEquals(Arrays.asList(new Integer("1")), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer("2")), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testRowIDNumericComparision() throws Exception {
        this.executeCmd("delete from smalla");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (1, 1,1.99, 1)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (2, 2, 2.99, 2)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (3, 3, 3.99, 3)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (4, 4, 4.99, 4)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (15, 15, 15.99, 15)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, DOUBLENUM, BIGINTEGERVALUE) values (16, 16, 16.99, 16)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID > 2");
        Assert.assertEquals(Arrays.asList(new Integer(15), new Long(15L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(16), new Long(16L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(3), new Long(3L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4), new Long(4L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID >= 2");
        Assert.assertEquals(Arrays.asList(new Integer(15), new Long(15L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(16), new Long(16L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), new Long(2L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(3), new Long(3L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4), new Long(4L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID < 3");
        Assert.assertEquals(Arrays.asList(new Integer(1), new Long(1L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), new Long(2L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID <= 3");
        Assert.assertEquals(Arrays.asList(new Integer(1), new Long(1L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), new Long(2L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(3), new Long(3L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID != 3");
        Assert.assertEquals(Arrays.asList(new Integer(1), new Long(1L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(15), new Long(15L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(16), new Long(16L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), new Long(2L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4), new Long(4L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM from smalla where ROWID = 3");
        Assert.assertEquals(Arrays.asList(new Integer(3), new Long(3L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testNullRowSelection() throws Exception {
        this.executeCmd("delete from smalla");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, BIGINTEGERVALUE) values (1, null, 1)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, BIGINTEGERVALUE) values (2, null, null)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, BIGINTEGERVALUE) values (3, 3, null)");
        this.executeCmd("insert into smalla (ROWID, LONGNUM, BIGINTEGERVALUE) values (4, 4, 4)");
        AccumuloQueryExecution exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM, BIGINTEGERVALUE from smalla");
        Assert.assertEquals(Arrays.asList(new Integer(1), null, new BigInteger("1")), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), null, null), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(3), new Long(3L), null), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(4), new Long(4L), new BigInteger("4")), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select LONGNUM from smalla");
        ArrayList<Object> NULL_ARRAY = new ArrayList<Object>();
        NULL_ARRAY.add(null);
        Assert.assertEquals(NULL_ARRAY, (Object)exec.next());
        Assert.assertEquals(NULL_ARRAY, (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Long(3L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Long(4L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select LONGNUM as foo from smalla");
        Assert.assertEquals(NULL_ARRAY, (Object)exec.next());
        Assert.assertEquals(NULL_ARRAY, (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Long(3L)), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Long(4L)), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        exec = (AccumuloQueryExecution)this.executeCmd("select ROWID, LONGNUM as foo from smalla where LONGNUM is null");
        Assert.assertEquals(Arrays.asList(new Integer(1), null), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(new Integer(2), null), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testAccumuloDataTypeManager() throws SQLException {
        GeometryType gt = new GeometryType(new byte[10]);
        gt.setSrid(4000);
        byte[] bytes = AccumuloDataTypeManager.serialize((Object)gt);
        GeometryType gt1 = (GeometryType)AccumuloDataTypeManager.deserialize((byte[])bytes, GeometryType.class);
        Assert.assertEquals((long)4000L, (long)gt1.getSrid());
        Assert.assertEquals((long)10L, (long)gt1.length());
    }
}

