/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.accumulo.AccumuloConnection;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;

public class TestAccumuloMetadataProcessor {
    private static Connector connector;

    @Before
    public void setup() throws Exception {
        MockInstance instance = new MockInstance("teiid-test");
        connector = instance.getConnector("root", (AuthenticationToken)new PasswordToken((CharSequence)""));
        try {
            connector.tableOperations().create("Customer");
            connector.tableOperations().create("Category");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BatchWriter writer = connector.createBatchWriter("Customer", new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"1");
        m.put((CharSequence)"Customer", (CharSequence)"CompanyName", new Value("teiid.org".getBytes()));
        m.put((CharSequence)"Customer", (CharSequence)"ContactName", new Value("helpdesk".getBytes()));
        m.put((CharSequence)"Customer", (CharSequence)"ContactTitle", new Value("dude".getBytes()));
        writer.addMutation(m);
        writer.close();
        writer = connector.createBatchWriter("Category", new BatchWriterConfig());
        m = new Mutation((CharSequence)"1");
        m.put((CharSequence)"Category", (CharSequence)"CategoryName", new Value("software".getBytes()));
        m.put((CharSequence)"Category", (CharSequence)"CategoryDescription", new Value("Data Virtualization Software".getBytes()));
        writer.addMutation(m);
        writer.close();
    }

    @Test
    public void testDefaultImportPropertiesMetadata() throws Exception {
        AccumuloConnection conn = (AccumuloConnection)Mockito.mock(AccumuloConnection.class);
        Mockito.stub((Object)conn.getInstance()).toReturn((Object)connector);
        Mockito.stub((Object)conn.getAuthorizations()).toReturn((Object)new Authorizations(new String[]{"public"}));
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "accumulo", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        AccumuloMetadataProcessor processor = new AccumuloMetadataProcessor();
        processor.process(mf, conn);
        Schema schema = mf.getSchema();
        NavigableMap tables = schema.getTables();
        Assert.assertNotNull((Object)tables);
        Assert.assertEquals((String)("wrong table size=" + tables), (long)2L, (long)tables.size());
        Table customer = (Table)tables.get("Customer");
        Assert.assertNotNull((Object)customer);
        List columns = customer.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertNotNull((Object)customer.getColumnByName("rowid"));
        Assert.assertNotNull((Object)customer.getColumnByName("Customer_CompanyName"));
        Assert.assertEquals((Object)"string", (Object)customer.getColumnByName("Customer_CompanyName").getDatatype().getName());
        Column column = customer.getColumnByName("Customer_CompanyName");
        Assert.assertEquals((Object)"Customer", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CF", false));
        Assert.assertEquals((Object)"CompanyName", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CQ", false));
        Assert.assertEquals((Object)"{VALUE}", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN", false));
    }

    @Test
    public void testImportPropertiesMetadata() throws Exception {
        Properties props = new Properties();
        props.put("importer.ColumnNamePattern", "{CQ}");
        props.put("importer.ValueIn", "{ROWID}");
        AccumuloConnection conn = (AccumuloConnection)Mockito.mock(AccumuloConnection.class);
        Mockito.stub((Object)conn.getInstance()).toReturn((Object)connector);
        Mockito.stub((Object)conn.getAuthorizations()).toReturn((Object)new Authorizations(new String[]{"public"}));
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "accumulo", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        AccumuloMetadataProcessor processor = new AccumuloMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)processor, (Properties)mf.getModelProperties(), (String)"importer");
        processor.process(mf, conn);
        Schema schema = mf.getSchema();
        NavigableMap tables = schema.getTables();
        Assert.assertNotNull((Object)tables);
        Assert.assertEquals((long)2L, (long)tables.size());
        Table customer = (Table)tables.get("Customer");
        Assert.assertNotNull((Object)customer);
        List columns = customer.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertNotNull((Object)customer.getColumnByName("rowid"));
        Assert.assertNotNull((Object)customer.getColumnByName("CompanyName"));
        Assert.assertEquals((Object)"string", (Object)customer.getColumnByName("CompanyName").getDatatype().getName());
        Column column = customer.getColumnByName("CompanyName");
        Assert.assertEquals((Object)"Customer", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CF", false));
        Assert.assertEquals((Object)"CompanyName", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CQ", false));
        Assert.assertEquals((Object)"{ROWID}", (Object)column.getProperty("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN", false));
        Assert.assertEquals((Object)Column.SearchType.All_Except_Like, (Object)column.getSearchType());
        column = customer.getColumnByName("rowid");
        Assert.assertEquals((Object)Column.SearchType.All_Except_Like, (Object)column.getSearchType());
        Assert.assertNotNull((Object)customer.getPrimaryKey());
    }
}

