/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.accumulo.core.client.lexicoder.BigIntegerLexicoder;
import org.apache.accumulo.core.client.lexicoder.BytesLexicoder;
import org.apache.accumulo.core.client.lexicoder.DateLexicoder;
import org.apache.accumulo.core.client.lexicoder.DoubleLexicoder;
import org.apache.accumulo.core.client.lexicoder.IntegerLexicoder;
import org.apache.accumulo.core.client.lexicoder.LongLexicoder;
import org.apache.accumulo.core.client.lexicoder.StringLexicoder;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.translator.accumulo.AccumuloPlugin;

public class AccumuloDataTypeManager {
    public static byte[] EMPTY_BYTES = new byte[0];
    private static BytesLexicoder bytesLexicoder = new BytesLexicoder();
    private static BigIntegerLexicoder bigIntegerLexicoder = new BigIntegerLexicoder();
    private static DateLexicoder dateLexicoder = new DateLexicoder();
    private static DoubleLexicoder doubleLexicoder = new DoubleLexicoder();
    private static IntegerLexicoder integerLexicoder = new IntegerLexicoder();
    private static LongLexicoder longLexicoder = new LongLexicoder();
    private static StringLexicoder stringLexicoder = new StringLexicoder();
    private static Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] serialize(Object value) {
        if (value == null) {
            return EMPTY_BYTES;
        }
        try {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                return ObjectConverterUtil.convertToByteArray((InputStream)clob.getAsciiStream());
            }
            if (value instanceof GeometryType) {
                GeometryType geometry = (GeometryType)value;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectConverterUtil.write((OutputStream)baos, (InputStream)geometry.getBinaryStream(), (int)-1, (boolean)true);
                int srid = geometry.getSrid();
                baos.write(srid >>> 24 & 0xFF);
                baos.write(srid >>> 16 & 0xFF);
                baos.write(srid >>> 8 & 0xFF);
                baos.write(srid >>> 0 & 0xFF);
                return baos.toByteArray();
            }
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                return ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream());
            }
            if (value instanceof SQLXML) {
                SQLXML xml = (SQLXML)value;
                return ObjectConverterUtil.convertToByteArray((InputStream)xml.getBinaryStream());
            }
            if (value instanceof BinaryType) {
                BinaryType binary = (BinaryType)value;
                return binary.getBytes();
            }
            if (value instanceof byte[]) {
                return bytesLexicoder.encode((byte[])value);
            }
            if (value instanceof Object[]) {
                throw new TeiidRuntimeException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19003, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19003, new Object[0]));
            }
            if (value instanceof String || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof BigDecimal || value instanceof Float || value instanceof Double || value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                return ((String)DataTypeManager.transformValue((Object)value, String.class)).getBytes(UTF_8);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (TransformationException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static Object deserialize(final byte[] value, Class<?> expectedType) {
        if (value == null || Arrays.equals(value, EMPTY_BYTES)) {
            return null;
        }
        try {
            if (expectedType.isAssignableFrom(Clob.class)) {
                return new ClobImpl(new InputStreamFactory(){

                    public InputStream getInputStream() throws IOException {
                        return ObjectConverterUtil.convertToInputStream((byte[])value);
                    }
                }, -1L);
            }
            if (expectedType.isAssignableFrom(Blob.class)) {
                return new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

                    public InputStream getInputStream() throws IOException {
                        return ObjectConverterUtil.convertToInputStream((byte[])value);
                    }
                }));
            }
            if (expectedType.isAssignableFrom(SQLXML.class)) {
                return new SQLXMLImpl(new InputStreamFactory(){

                    public InputStream getInputStream() throws IOException {
                        return ObjectConverterUtil.convertToInputStream((byte[])value);
                    }
                });
            }
            if (expectedType.isAssignableFrom(BinaryType.class)) {
                return new BinaryType(value);
            }
            if (expectedType.isAssignableFrom(GeometryType.class)) {
                GeometryType result = new GeometryType(Arrays.copyOf(value, value.length - 4));
                int srid = ((value[value.length - 4] & 0xFF) << 24) + ((value[value.length - 3] & 0xFF) << 16) + ((value[value.length - 2] & 0xFF) << 8) + ((value[value.length - 1] & 0xFF) << 0);
                result.setSrid(srid);
                return result;
            }
            if (expectedType.isAssignableFrom(byte[].class)) {
                return value;
            }
            if (expectedType.isAssignableFrom(String.class) || expectedType.isAssignableFrom(Boolean.class) || expectedType.isAssignableFrom(Boolean.class) || expectedType.isAssignableFrom(Byte.class) || expectedType.isAssignableFrom(Short.class) || expectedType.isAssignableFrom(Character.class) || expectedType.isAssignableFrom(Integer.class) || expectedType.isAssignableFrom(Long.class) || expectedType.isAssignableFrom(BigInteger.class) || expectedType.isAssignableFrom(BigDecimal.class) || expectedType.isAssignableFrom(Float.class) || expectedType.isAssignableFrom(Double.class) || expectedType.isAssignableFrom(Date.class) || expectedType.isAssignableFrom(Time.class) || expectedType.isAssignableFrom(Timestamp.class)) {
                return DataTypeManager.transformValue((Object)new String(value, UTF_8), expectedType);
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(value));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (TransformationException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private static byte[] toLexiCode(Object value) {
        if (value == null) {
            return EMPTY_BYTES;
        }
        try {
            if (value instanceof Date || value instanceof Timestamp || value instanceof Time) {
                return dateLexicoder.encode((java.util.Date)value);
            }
            if (value instanceof Long) {
                return longLexicoder.encode((Long)value);
            }
            if (value instanceof Double) {
                return doubleLexicoder.encode((Double)value);
            }
            if (value instanceof Float) {
                return doubleLexicoder.encode(Double.valueOf(((Float)value).doubleValue()));
            }
            if (value instanceof Integer) {
                return integerLexicoder.encode((Integer)value);
            }
            if (value instanceof BigInteger) {
                return bigIntegerLexicoder.encode((BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                return stringLexicoder.encode(((BigDecimal)value).toPlainString());
            }
            if (value instanceof Byte) {
                return integerLexicoder.encode(Integer.valueOf(((Byte)value).intValue()));
            }
            if (value instanceof Short) {
                return integerLexicoder.encode(Integer.valueOf(((Short)value).intValue()));
            }
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                return bytesLexicoder.encode(ObjectConverterUtil.convertToByteArray((InputStream)clob.getAsciiStream()));
            }
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                return bytesLexicoder.encode(ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream()));
            }
            if (value instanceof SQLXML) {
                SQLXML xml = (SQLXML)value;
                return bytesLexicoder.encode(ObjectConverterUtil.convertToByteArray((InputStream)xml.getBinaryStream()));
            }
            if (value instanceof BinaryType) {
                BinaryType binary = (BinaryType)value;
                return bytesLexicoder.encode(binary.getBytes());
            }
            if (value instanceof GeometryType) {
                GeometryType geometry = (GeometryType)value;
                return bytesLexicoder.encode(ObjectConverterUtil.convertToByteArray((InputStream)geometry.getBinaryStream()));
            }
            if (value instanceof byte[]) {
                return bytesLexicoder.encode((byte[])value);
            }
            if (value instanceof Object[]) {
                throw new TeiidRuntimeException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19003, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19003, new Object[0]));
            }
            return stringLexicoder.encode((String)DataTypeManager.transformValue((Object)value, String.class));
        }
        catch (TransformationException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private static Object fromLexiCode(final byte[] value, Class<?> expectedType) {
        if (value == null || Arrays.equals(value, EMPTY_BYTES)) {
            return null;
        }
        if (expectedType.isAssignableFrom(String.class)) {
            return stringLexicoder.decode(value);
        }
        if (expectedType.isAssignableFrom(Date.class)) {
            return new Date(dateLexicoder.decode(value).getTime());
        }
        if (expectedType.isAssignableFrom(Timestamp.class)) {
            return new Timestamp(dateLexicoder.decode(value).getTime());
        }
        if (expectedType.isAssignableFrom(Time.class)) {
            return new Time(dateLexicoder.decode(value).getTime());
        }
        if (expectedType.isAssignableFrom(Long.class)) {
            return longLexicoder.decode(value);
        }
        if (expectedType.isAssignableFrom(Double.class)) {
            return doubleLexicoder.decode(value);
        }
        if (expectedType.isAssignableFrom(Float.class)) {
            return Float.valueOf(doubleLexicoder.decode(value).floatValue());
        }
        if (expectedType.isAssignableFrom(Integer.class)) {
            return integerLexicoder.decode(value);
        }
        if (expectedType.isAssignableFrom(BigInteger.class)) {
            return bigIntegerLexicoder.decode(value);
        }
        if (expectedType.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(stringLexicoder.decode(value));
        }
        if (expectedType.isAssignableFrom(Byte.class)) {
            return integerLexicoder.decode(value).byteValue();
        }
        if (expectedType.isAssignableFrom(Short.class)) {
            return integerLexicoder.decode(value).shortValue();
        }
        if (expectedType.isAssignableFrom(Clob.class)) {
            return new ClobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return ObjectConverterUtil.convertToInputStream((byte[])bytesLexicoder.decode(value));
                }
            }, -1L);
        }
        if (expectedType.isAssignableFrom(Blob.class)) {
            return new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return ObjectConverterUtil.convertToInputStream((byte[])bytesLexicoder.decode(value));
                }
            }));
        }
        if (expectedType.isAssignableFrom(SQLXML.class)) {
            return new SQLXMLImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return ObjectConverterUtil.convertToInputStream((byte[])bytesLexicoder.decode(value));
                }
            });
        }
        if (expectedType.isAssignableFrom(BinaryType.class)) {
            return new BinaryType(bytesLexicoder.decode(value));
        }
        if (expectedType.isAssignableFrom(GeometryType.class)) {
            return new GeometryType(bytesLexicoder.decode(value));
        }
        if (expectedType.isAssignableFrom(byte[].class)) {
            return bytesLexicoder.decode(value);
        }
        throw new TeiidRuntimeException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19004, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19004, new Object[]{expectedType.getName()}));
    }
}

