/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.conf.ColumnSet;
import org.apache.accumulo.core.iterators.user.RowFilter;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;

public abstract class BaseFilterIterator
extends RowFilter {
    public static final String NEGATE = "NEGATE";
    protected AccumuloMetadataProcessor.ValueIn valueIn;
    protected ColumnSet columnFilter;
    private boolean negate = false;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        String cf = options.get("{http://www.teiid.org/translator/accumulo/2013}CF");
        String cq = options.get("{http://www.teiid.org/translator/accumulo/2013}CQ");
        if (options.get("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN") != null) {
            String value = options.get("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN");
            this.valueIn = AccumuloMetadataProcessor.ValueIn.valueOf(value.substring(1, value.length() - 1));
        } else {
            this.valueIn = AccumuloMetadataProcessor.ValueIn.VALUE;
        }
        this.columnFilter = cq != null ? new ColumnSet(Arrays.asList(cf + ":" + cq)) : new ColumnSet(Arrays.asList(cf));
        this.negate = false;
        if (options.get(NEGATE) != null) {
            this.negate = Boolean.parseBoolean(options.get(NEGATE));
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        BaseFilterIterator instance = (BaseFilterIterator)super.deepCopy(env);
        instance.valueIn = this.valueIn;
        instance.columnFilter = this.columnFilter;
        return instance;
    }

    public boolean acceptRow(SortedKeyValueIterator<Key, Value> rowItem) throws IOException {
        if (this.negate) {
            return !this.accept(rowItem);
        }
        return this.accept(rowItem);
    }

    private boolean accept(SortedKeyValueIterator<Key, Value> rowItem) {
        while (rowItem.hasTop()) {
            Key key = (Key)rowItem.getTopKey();
            if (!this.columnFilter.contains(key)) continue;
            byte[] value = this.valueIn.equals((Object)AccumuloMetadataProcessor.ValueIn.VALUE) ? ((Value)rowItem.getTopValue()).get() : key.getColumnQualifier().getBytes();
            return this.accept(value);
        }
        return true;
    }

    public boolean accept(byte[] value) {
        return true;
    }
}

