/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;

public class CountStarIterator
extends WrappingIterator {
    public static final String ALIAS = "alias";
    private Key topKey;
    private Value topValue;
    private String alias;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.alias = options.get(ALIAS);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        CountStarIterator newInstance;
        try {
            newInstance = (CountStarIterator)((Object)((Object)((Object)this)).getClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.alias = this.alias;
        newInstance.topKey = this.topKey;
        newInstance.topValue = this.topValue;
        return newInstance;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        if (this.getSource().hasTop()) {
            int count = 0;
            ByteSequence prevRowId = null;
            while (this.getSource().hasTop()) {
                Key key = (Key)this.getSource().getTopKey();
                ByteSequence rowId = key.getRowData();
                if (prevRowId == null || !prevRowId.equals((Object)rowId)) {
                    ++count;
                    prevRowId = rowId;
                }
                this.getSource().next();
            }
            this.topKey = new Key((CharSequence)"1", (CharSequence)this.alias, (CharSequence)this.alias);
            this.topValue = new Value(AccumuloDataTypeManager.serialize(count));
        }
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public void next() throws IOException {
        this.topKey = null;
        this.topValue = null;
    }
}

