/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.Text;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;

public class EvaluatorIterator
extends WrappingIterator {
    private static final SystemFunctionManager SFM = SystemMetadata.getInstance().getSystemFunctionManager();
    public static final String QUERYSTRING = "QUERYSTRING";
    public static final String TABLE = "TABLE";
    public static final String DDL = "DDL";
    public static final String IMPLICIT_MODEL_NAME = "model";
    private Criteria criteria;
    private Evaluator evaluator;
    private Collection<ElementSymbol> elementsInExpression;
    private EvaluatorUtil evaluatorUtil;
    private ArrayList<KeyValuePair> currentValues;
    private Iterator<KeyValuePair> rowIterator;
    private Key topKey;
    private Value topValue;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        try {
            GroupSymbol gs = null;
            String query = options.get(QUERYSTRING);
            TransformationMetadata tm = EvaluatorIterator.createTransformationMetadata(options.get(DDL));
            this.criteria = QueryParser.getQueryParser().parseCriteria(query);
            this.elementsInExpression = ElementCollectorVisitor.getElements((LanguageObject)this.criteria, (boolean)false);
            for (ElementSymbol es : this.elementsInExpression) {
                gs = es.getGroupSymbol();
                ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)tm);
            }
            ResolverVisitor.resolveLanguageObject((LanguageObject)this.criteria, (QueryMetadataInterface)tm);
            this.evaluatorUtil = new EvaluatorUtil(gs);
        }
        catch (QueryParserException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (QueryResolverException e) {
            throw new IOException(e);
        }
        catch (TeiidComponentException e) {
            throw new IOException(e);
        }
        CommandContext cc = new CommandContext();
        this.evaluator = new Evaluator(this.evaluatorUtil.getElementMap(), null, cc);
    }

    public static TransformationMetadata createTransformationMetadata(String ddl) {
        MetadataStore mds = new MetadataStore();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, IMPLICIT_MODEL_NAME, SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf, ddl);
        mf.mergeInto(mds);
        CompositeMetadataStore store = new CompositeMetadataStore(mds);
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName("vdb");
        vdbMetaData.setVersion(1);
        ArrayList udfs = new ArrayList();
        for (Schema schema : store.getSchemas().values()) {
            vdbMetaData.addModel(EvaluatorIterator.createModel(schema.getName(), schema.isPhysical()));
        }
        TransformationMetadata metadata = new TransformationMetadata(vdbMetaData, store, null, SFM.getSystemFunctions(), udfs);
        vdbMetaData.addAttchment(TransformationMetadata.class, (Object)metadata);
        vdbMetaData.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        return metadata;
    }

    public static ModelMetaData createModel(String name, boolean source) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        if (source) {
            model.setModelType(Model.Type.PHYSICAL);
        } else {
            model.setModelType(Model.Type.VIRTUAL);
        }
        model.setVisible(true);
        model.setSupportsMultiSourceBindings(false);
        model.addSourceMapping(name, name, null);
        return model;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        EvaluatorIterator newInstance;
        try {
            newInstance = (EvaluatorIterator)((Object)((Object)((Object)this)).getClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.criteria = this.criteria;
        newInstance.currentValues = this.currentValues;
        newInstance.elementsInExpression = this.elementsInExpression;
        newInstance.evaluator = this.evaluator;
        newInstance.evaluatorUtil = this.evaluatorUtil;
        newInstance.topKey = this.topKey;
        newInstance.topValue = this.topValue;
        newInstance.rowIterator = this.rowIterator;
        return newInstance;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Key sk = range.getStartKey();
        if (sk != null && sk.getColumnFamilyData().length() == 0 && sk.getColumnQualifierData().length() == 0 && sk.getColumnVisibilityData().length() == 0 && sk.getTimestamp() == Long.MAX_VALUE && !range.isStartKeyInclusive()) {
            Key followingRowKey = sk.followingKey(PartialKey.ROW);
            if (range.getEndKey() != null && followingRowKey.compareTo(range.getEndKey()) > 0) {
                return;
            }
            range = new Range(sk.followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
        }
        this.getSource().seek(range, columnFamilies, inclusive);
        this.prepKeys();
    }

    private void prepKeys() throws IOException {
        this.currentValues = new ArrayList();
        do {
            this.currentValues.clear();
            this.rowIterator = null;
            if (!this.getSource().hasTop()) {
                this.currentValues = null;
                return;
            }
            Text currentRow = new Text(((Key)this.getSource().getTopKey()).getRow());
            while (this.getSource().hasTop() && ((Key)this.getSource().getTopKey()).getRow().equals((Object)currentRow)) {
                KeyValuePair kv = new KeyValuePair();
                kv.key = (Key)this.getSource().getTopKey();
                kv.value = new Value((Value)this.getSource().getTopValue());
                this.currentValues.add(kv);
                this.getSource().next();
            }
        } while (!this.filter(this.currentValues));
    }

    protected boolean filter(ArrayList<KeyValuePair> values) throws IOException {
        if (this.acceptRow(values)) {
            this.rowIterator = values.iterator();
            this.advanceRow();
            return true;
        }
        return false;
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public boolean hasTop() {
        return this.topKey != null;
    }

    public void next() throws IOException {
        if (!this.advanceRow()) {
            this.prepKeys();
        }
    }

    private boolean advanceRow() {
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            KeyValuePair kv = this.rowIterator.next();
            this.topKey = kv.key;
            this.topValue = kv.value;
            return true;
        }
        this.topKey = null;
        this.topValue = null;
        this.rowIterator = null;
        return false;
    }

    private boolean acceptRow(ArrayList<KeyValuePair> values) throws IOException {
        try {
            return this.evaluator.evaluate(this.criteria, this.evaluatorUtil.buildTuple(values));
        }
        catch (ExpressionEvaluationException e) {
            throw new IOException(e);
        }
        catch (BlockedException e) {
            throw new IOException(e);
        }
        catch (TeiidComponentException e) {
            throw new IOException(e);
        }
    }

    private static class EvaluatorUtil {
        private Map<ColumnSet, ColumnInfo> columnMap = new HashMap<ColumnSet, ColumnInfo>();
        private Map<ElementSymbol, Integer> elementMap = new HashMap<ElementSymbol, Integer>();

        public EvaluatorUtil(GroupSymbol group) throws ClassNotFoundException {
            List columns = ((Table)group.getMetadataID()).getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                ElementSymbol element = new ElementSymbol(column.getName(), group, Class.forName(column.getDatatype().getJavaClassName()));
                this.elementMap.put(element, i);
                String valueIn = column.getProperty("{http://www.teiid.org/translator/accumulo/2013}VALUE-IN", false);
                String cf = column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CF", false);
                String cq = column.getProperty("{http://www.teiid.org/translator/accumulo/2013}CQ", false);
                AccumuloMetadataProcessor.ValueIn valueInEnum = AccumuloMetadataProcessor.ValueIn.VALUE;
                if (valueIn != null) {
                    valueInEnum = AccumuloMetadataProcessor.ValueIn.valueOf(valueIn.substring(1, valueIn.length() - 1));
                }
                ColumnInfo col = new ColumnInfo();
                col.es = element;
                col.in = valueInEnum;
                col.pos = i;
                ColumnSet cs = null;
                if (cf != null && cq != null) {
                    cs = new ColumnSet(new Text(cf), new Text(cq));
                } else {
                    if (cf == null) {
                        cf = "rowid";
                    }
                    cs = new ColumnSet(new Text(cf));
                }
                this.columnMap.put(cs, col);
            }
        }

        public List<?> buildTuple(ArrayList<KeyValuePair> values) {
            Object[] tuple = new Object[this.elementMap.size()];
            for (KeyValuePair kv : values) {
                ColumnInfo info = this.findColumnInfo(kv.key);
                if (info != null) {
                    Value v = kv.value;
                    tuple[info.pos] = AccumuloMetadataProcessor.ValueIn.CQ.equals((Object)info.in) ? this.convert(kv.key.getColumnQualifier().getBytes(), info.es) : this.convert(v.get(), info.es);
                }
                info = this.columnMap.get((Object)new ColumnSet(new Text("rowid")));
                tuple[info.pos] = this.convert(kv.key.getRow().getBytes(), info.es);
            }
            return Arrays.asList(tuple);
        }

        private Object convert(byte[] content, ElementSymbol es) {
            return AccumuloDataTypeManager.deserialize(content, es.getType());
        }

        private ColumnInfo findColumnInfo(Key key) {
            for (ColumnSet cs : this.columnMap.keySet()) {
                if (!cs.contains(key)) continue;
                return this.columnMap.get((Object)cs);
            }
            return null;
        }

        public Map<ElementSymbol, Integer> getElementMap() {
            return this.elementMap;
        }
    }

    private static class ColumnSet
    extends org.apache.accumulo.core.iterators.conf.ColumnSet {
        private Text colf;
        private Text colq;

        public ColumnSet(Text colf, Text colq) {
            super.add(colf, colq);
            this.colf = colf;
            this.colq = colq;
        }

        public ColumnSet(Text colf) {
            super.add(colf);
            this.colf = colf;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.colf == null ? 0 : this.colf.hashCode());
            result = 31 * result + (this.colq == null ? 0 : this.colq.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ColumnSet other = (ColumnSet)((Object)obj);
            if (this.colf == null ? other.colf != null : !this.colf.equals((Object)other.colf)) {
                return false;
            }
            return !(this.colq == null ? other.colq != null : !this.colq.equals((Object)other.colq));
        }
    }

    private static class ColumnInfo {
        ElementSymbol es;
        int pos;
        AccumuloMetadataProcessor.ValueIn in;

        private ColumnInfo() {
        }
    }

    static class KeyValuePair {
        Key key;
        Value value;

        KeyValuePair() {
        }
    }
}

