/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.accumulo.AccumuloExecutionFactory;
import org.teiid.translator.accumulo.AccumuloQueryVisitor;

public class TestAccumuloQueryVisitor {
    private AccumuloExecutionFactory translator;
    private TranslationUtility utility;

    @Before
    public void setUp() throws Exception {
        this.translator = new AccumuloExecutionFactory();
        this.translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"sampledb.ddl")), (String)"sakila", (String)"rental");
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    @Test
    public void testSelectStar() throws Exception {
        Command cmd = this.utility.parseCommand("select * from Customer");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertTrue((boolean)visitor.getRanges().isEmpty());
        Assert.assertNotNull((Object)visitor.projectedColumns());
        List columns = visitor.projectedColumns();
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)3L, (long)columns.size());
        Column rowid = (Column)columns.get(0);
        Column firstName = (Column)columns.get(1);
        Assert.assertEquals((Object)"customer_id", (Object)rowid.getName());
        Assert.assertEquals((Object)"rowid", (Object)rowid.getNameInSource());
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"customer", (Object)firstName.getProperty("teiid_accumulo:CF", false));
        Assert.assertEquals((Object)"firstNameAttribute", (Object)firstName.getProperty("teiid_accumulo:CQ", false));
    }

    @Test
    public void testSelectColumn() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertTrue((boolean)visitor.getRanges().isEmpty());
        Assert.assertNotNull((Object)visitor.projectedColumns());
        List columns = visitor.projectedColumns();
        Assert.assertEquals((long)1L, (long)columns.size());
        Column name = (Column)columns.get(0);
        Assert.assertEquals((Object)"firstName", (Object)name.getName());
        Assert.assertEquals((Object)"customer", (Object)name.getProperty("teiid_accumulo:CF", false));
        Assert.assertEquals((Object)"firstNameAttribute", (Object)name.getProperty("teiid_accumulo:CQ", false));
    }

    private AccumuloQueryVisitor buildVisitor(Command cmd) throws TranslatorException {
        AccumuloQueryVisitor visitor = new AccumuloQueryVisitor(this.translator);
        visitor.visitNode((LanguageObject)cmd);
        if (!visitor.exceptions.isEmpty()) {
            throw (TranslatorException)visitor.exceptions.get(0);
        }
        return visitor;
    }

    @Test
    public void testSelectEquality() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id = 1");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)1L, (long)visitor.getRanges().size());
        Range range = (Range)visitor.getRanges().get(0);
        Assert.assertEquals((Object)AccumuloQueryVisitor.singleRowRange((Key)AccumuloQueryVisitor.buildKey((Object)new Integer(1))), (Object)range);
    }

    @Test
    public void testWhereIN() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id IN (1,2)");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)2L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)AccumuloQueryVisitor.singleRowRange((Key)AccumuloQueryVisitor.buildKey((Object)new Integer(2))), visitor.getRanges().get(0));
        Assert.assertEquals((Object)AccumuloQueryVisitor.singleRowRange((Key)AccumuloQueryVisitor.buildKey((Object)new Integer(1))), visitor.getRanges().get(1));
    }

    @Test
    public void testWhereNOT_IN() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id NOT IN (1,2)");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)3L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false, null, true), visitor.getRanges().get(0));
        Assert.assertEquals((Object)new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(1)), false, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false), visitor.getRanges().get(1));
        Assert.assertEquals((Object)new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(1)), false), visitor.getRanges().get(2));
    }

    @Test
    @Ignore
    public void testWhereComapreLE() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id < 2");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)1L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false), visitor.getRanges().get(0));
    }

    @Test
    @Ignore
    public void testWhereComapreLEEQ() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id <= 2");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)2L, (long)visitor.getRanges().size());
        Range r1 = new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false);
        Range r2 = AccumuloQueryVisitor.singleRowRange((Key)AccumuloQueryVisitor.buildKey((Object)new Integer(2)));
        Assert.assertEquals((Object)r1, visitor.getRanges().get(0));
        Assert.assertEquals((Object)r2, visitor.getRanges().get(1));
    }

    @Test
    @Ignore
    public void testWhereComapreGT() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id > 2");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)1L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(2)).followingKey(PartialKey.ROW), null, false, true, false, true), visitor.getRanges().get(0));
    }

    @Test
    @Ignore
    public void testWhereComapreGTEQ() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id >= 2");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)1L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(2)), true, null, true), visitor.getRanges().get(0));
    }

    @Test
    public void testWhereComapreNOTEQ() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id <> 2");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)2L, (long)visitor.getRanges().size());
        Assert.assertEquals((Object)new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false), visitor.getRanges().get(0));
        Assert.assertEquals((Object)new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(2)).followingKey(PartialKey.ROW), null, false, true, false, true), visitor.getRanges().get(1));
    }

    @Test
    @Ignore
    public void testWhereComapreAND1() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id < 2 and customer_id > 4");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)2L, (long)visitor.getRanges().size());
        Range r1 = new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false);
        Range r2 = new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(4)).followingKey(PartialKey.ROW), null, false, true, false, true);
        Assert.assertEquals((Object)Range.mergeOverlapping(Arrays.asList(r1, r2)), (Object)visitor.getRanges());
    }

    @Test
    public void testWhereComapreAND2() throws Exception {
        Command cmd = this.utility.parseCommand("select firstname from Customer where customer_id < 2 and customer_id != 4");
        AccumuloQueryVisitor visitor = this.buildVisitor(cmd);
        Assert.assertEquals((Object)"customer", (Object)visitor.getScanTable().getName());
        Assert.assertEquals((long)2L, (long)visitor.getRanges().size());
        Range r1 = new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(2)), false);
        Range r2 = new Range(null, true, AccumuloQueryVisitor.buildKey((Object)new Integer(4)), false);
        Range r3 = new Range(AccumuloQueryVisitor.buildKey((Object)new Integer(4)).followingKey(PartialKey.ROW), null, false, true, false, true);
        Assert.assertEquals((Object)Range.mergeOverlapping(Arrays.asList(r1, r2, r3)), (Object)visitor.getRanges());
    }
}

