/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.accumulo.AccumuloConnection;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;
import org.teiid.translator.accumulo.AccumuloQueryExecution;
import org.teiid.translator.accumulo.AccumuloUpdateExecution;

@Translator(name="accumulo", description="Accumulo Translator, reads and writes the data to Accumulo Key/Value store")
public class AccumuloExecutionFactory
extends ExecutionFactory<ConnectionFactory, AccumuloConnection> {
    private int queryThreadsCount = 10;

    public AccumuloExecutionFactory() {
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSourceRequiredForMetadata(true);
    }

    public void start() throws TranslatorException {
        super.start();
    }

    @TranslatorProperty(display="Execution Query Threads", description="Number of threads to use on Accumulo for Query", advanced=true)
    public int getQueryThreadsCount() {
        return this.queryThreadsCount;
    }

    public void setQueryThreadsCount(int queryThreadsCount) {
        this.queryThreadsCount = queryThreadsCount;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, AccumuloConnection connection) throws TranslatorException {
        return new AccumuloQueryExecution(this, (Select)command, executionContext, metadata, connection);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, AccumuloConnection connection) throws TranslatorException {
        return new AccumuloUpdateExecution(this, command, executionContext, metadata, connection);
    }

    public MetadataProcessor<AccumuloConnection> getMetadataProcessor() {
        return new AccumuloMetadataProcessor();
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return false;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean returnsSingleUpdateCount() {
        return true;
    }
}

