/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.util.Arrays;
import java.util.Map;
import java.util.SortedSet;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.hadoop.io.Text;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.accumulo.AccumuloConnection;

public class AccumuloMetadataProcessor
implements MetadataProcessor<AccumuloConnection> {
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Column Family", description="Column Familiy from the Key", required=true)
    public static final String CF = "teiid_accumulo:CF";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Column Qualifier", description="If Column Qualifier from key makes the key value unique, then this is required")
    public static final String CQ = "teiid_accumulo:CQ";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Value In", description="The value of key exists in Column Qualifier or Value slot; Default is VALUE, if value is in CQ then this property is required", allowed="CQ,VALUE")
    public static final String VALUE_IN = "teiid_accumulo:VALUE-IN";
    public static final String DEFAULT_COLUMN_NAME_PATTERN = "{CF}_{CQ}";
    public static final String DEFAULT_VALUE_PATTERN = "{VALUE}";
    public static final String ROWID = "rowid";
    private String columnNamePattern = "{CF}_{CQ}";
    private String valueIn = "{VALUE}";

    public void process(MetadataFactory mf, AccumuloConnection conn) {
        Connector connector = conn.getInstance();
        SortedSet tableNames = connector.tableOperations().list();
        for (String tableName : tableNames) {
            try {
                if (tableName.equals("!METADATA") || tableName.equals("trace")) continue;
                Text previousRow = null;
                Table table = null;
                Scanner scanner = connector.createScanner(tableName, conn.getAuthorizations());
                for (Map.Entry entry : scanner) {
                    Column column;
                    Key key = (Key)entry.getKey();
                    Text cf = key.getColumnFamily();
                    Text cq = key.getColumnQualifier();
                    Text row = key.getRow();
                    if (previousRow != null && !previousRow.equals((Object)row)) break;
                    previousRow = row;
                    if (mf.getSchema().getTable(tableName) == null) {
                        table = mf.addTable(tableName);
                        column = mf.addColumn(ROWID, "string", (ColumnSet)table);
                        column.setSearchType(Column.SearchType.All_Except_Like);
                        mf.addPrimaryKey("PK0", Arrays.asList(ROWID), table);
                        column.setUpdatable(false);
                    } else {
                        table = mf.getSchema().getTable(tableName);
                    }
                    column = mf.addColumn(this.buildColumnName(cf, cq, row), "string", (ColumnSet)table);
                    column.setSearchType(Column.SearchType.All_Except_Like);
                    column.setProperty(CF, cf.toString());
                    column.setProperty(CQ, cq.toString());
                    column.setProperty(VALUE_IN, this.getValueIn());
                    column.setUpdatable(true);
                }
                scanner.close();
                if (table == null) continue;
                table.setSupportsUpdate(true);
            }
            catch (TableNotFoundException e) {}
        }
    }

    private String buildColumnName(Text cf, Text cq, Text rowid) {
        String pattern = this.getColumnNamePattern();
        pattern = pattern.replace("{CF}", cf.toString());
        pattern = pattern.replace("{CQ}", cq.toString());
        pattern = pattern.replace("{ROWID}", rowid.toString());
        return pattern;
    }

    @TranslatorProperty(display="Column Name Pattern", category=TranslatorProperty.PropertyType.IMPORT, description="Pattern to derive column names from, available expressions to use({CF}, {CQ}, {ROW_ID}")
    public String getColumnNamePattern() {
        return this.columnNamePattern;
    }

    public void setColumnNamePattern(String columnNamePattern) {
        this.columnNamePattern = columnNamePattern;
    }

    @TranslatorProperty(display="Value In", category=TranslatorProperty.PropertyType.IMPORT, description="Defines where the data value of property is in {VALUE} or {CQ}")
    public String getValueIn() {
        return this.valueIn;
    }

    public void setValueIn(String valueIn) {
        this.valueIn = valueIn;
    }

    public static enum ValueIn {
        CQ,
        VALUE;

    }
}

