/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;
import org.teiid.translator.accumulo.AccumuloExecutionFactory;
import org.teiid.translator.accumulo.CountStarIterator;
import org.teiid.translator.accumulo.EvaluatorIterator;

public class AccumuloQueryVisitor
extends HierarchyVisitor {
    protected Stack<Object> onGoingExpression = new Stack();
    protected List<Range> ranges = new ArrayList<Range>();
    protected Table scanTable;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private HashMap<String, Column> keybasedColumnMap = new HashMap();
    private ArrayList<Column> selectColumns = new ArrayList();
    private ArrayList<IteratorSetting> scanIterators = new ArrayList();
    private String currentAlias;
    private int aliasIdx = 0;
    private int iteratorPriority = 2;
    private boolean doScanEvaluation = false;
    private AccumuloExecutionFactory ef;

    public AccumuloQueryVisitor(AccumuloExecutionFactory ef) {
        this.ef = ef;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public Table getScanTable() {
        return this.scanTable;
    }

    public Column lookupColumn(String key) {
        return this.keybasedColumnMap.get(key);
    }

    public List<Column> projectedColumns() {
        return this.selectColumns;
    }

    public List<IteratorSetting> scanIterators() {
        return this.scanIterators;
    }

    public void visit(Select obj) {
        this.visitNodes(obj.getFrom());
        this.visitNodes(obj.getDerivedColumns());
        this.visitNode((LanguageObject)obj.getWhere());
        this.visitNode((LanguageObject)obj.getGroupBy());
        this.visitNode((LanguageObject)obj.getHaving());
        this.visitNode((LanguageObject)obj.getOrderBy());
        this.visitNode((LanguageObject)obj.getLimit());
        if (this.doScanEvaluation) {
            HashMap<String, String> options = AccumuloQueryVisitor.buildEvaluatorOptions(this.scanTable);
            SQLStringVisitor visitor = new SQLStringVisitor(){

                public String getName(AbstractMetadataRecord object) {
                    return object.getName();
                }
            };
            visitor.append((LanguageObject)obj.getWhere());
            options.put("QUERYSTRING", visitor.toString());
            IteratorSetting it = new IteratorSetting(1, EvaluatorIterator.class, options);
            this.scanIterators.add(it);
        }
    }

    public void visit(DerivedColumn obj) {
        this.currentAlias = this.buildAlias(obj.getAlias());
        this.visitNode((LanguageObject)obj.getExpression());
        Column column = (Column)this.onGoingExpression.pop();
        String CF = column.getProperty("teiid_accumulo:CF", false);
        String CQ = column.getProperty("teiid_accumulo:CQ", false);
        if (CQ != null) {
            this.keybasedColumnMap.put(CF + "/" + CQ, column);
        } else {
            this.keybasedColumnMap.put(CF, column);
        }
        this.selectColumns.add(column);
    }

    private String buildAlias(String alias) {
        if (alias != null) {
            return alias;
        }
        return "_m" + this.aliasIdx;
    }

    public void visit(ColumnReference obj) {
        this.onGoingExpression.push(obj.getMetadataObject());
    }

    public void visit(AndOr obj) {
        this.visitNode((LanguageObject)obj.getLeftCondition());
        this.visitNode((LanguageObject)obj.getRightCondition());
        this.ranges = Range.mergeOverlapping(this.ranges);
    }

    public void visit(Comparison obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        Column column = (Column)this.onGoingExpression.pop();
        this.visitNode((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        Key rightKey = AccumuloQueryVisitor.buildKey(rightExpr);
        if (AccumuloQueryVisitor.isPartOfPrimaryKey(column)) {
            switch (obj.getOperator()) {
                case EQ: {
                    this.ranges.add(AccumuloQueryVisitor.singleRowRange(rightKey));
                    break;
                }
                case NE: {
                    this.ranges.add(new Range(null, true, rightKey, false));
                    this.ranges.add(new Range(rightKey.followingKey(PartialKey.ROW), null, false, true, false, true));
                }
            }
            this.doScanEvaluation = true;
        } else {
            this.doScanEvaluation = true;
        }
    }

    static Key buildKey(Object value) {
        byte[] row = AccumuloDataTypeManager.serialize(value);
        Key rangeKey = new Key(row, AccumuloDataTypeManager.EMPTY_BYTES, AccumuloDataTypeManager.EMPTY_BYTES, AccumuloDataTypeManager.EMPTY_BYTES, Long.MAX_VALUE);
        return rangeKey;
    }

    public void visit(In obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        Column column = (Column)this.onGoingExpression.pop();
        this.visitNodes(obj.getRightExpressions());
        if (AccumuloQueryVisitor.isPartOfPrimaryKey(column)) {
            Object prevExpr = null;
            for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
                Object rightExpr = this.onGoingExpression.pop();
                Key rightKey = AccumuloQueryVisitor.buildKey(rightExpr);
                Key prevKey = null;
                if (prevExpr != null) {
                    prevKey = AccumuloQueryVisitor.buildKey(prevExpr);
                }
                Range range = AccumuloQueryVisitor.singleRowRange(rightKey);
                if (obj.isNegated()) {
                    if (prevExpr == null) {
                        this.ranges.add(new Range(rightKey, false, null, true));
                        this.ranges.add(new Range(null, true, rightKey, false));
                    } else {
                        this.ranges.remove(this.ranges.size() - 1);
                        this.ranges.add(new Range(rightKey, false, prevKey, false));
                        this.ranges.add(new Range(null, true, rightKey, false));
                    }
                    prevExpr = rightExpr;
                    continue;
                }
                this.ranges.add(range);
            }
        } else {
            this.doScanEvaluation = true;
        }
    }

    static Range singleRowRange(Key key) {
        Range range = new Range(key, key.followingKey(PartialKey.ROW), true, false, false, false);
        return range;
    }

    public static boolean isPartOfPrimaryKey(Column column) {
        KeyRecord pk = ((Table)column.getParent()).getPrimaryKey();
        if (pk != null) {
            for (Column col : pk.getColumns()) {
                if (!col.getName().equals(column.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void visit(AggregateFunction obj) {
        if (!obj.getParameters().isEmpty()) {
            this.visitNodes(obj.getParameters());
        }
        if (obj.getName().equals("COUNT")) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("alias", this.currentAlias);
            IteratorSetting it = new IteratorSetting(this.iteratorPriority++, CountStarIterator.class, options);
            Column c = new Column();
            c.setName(this.currentAlias);
            c.setDatatype((Datatype)SystemMetadata.getInstance().getSystemStore().getDatatypes().get("integer"));
            c.setProperty("teiid_accumulo:CF", this.currentAlias);
            this.scanIterators.add(it);
            this.onGoingExpression.push(c);
        } else if (obj.getName().equals("AVG") || obj.getName().equals("SUM") || obj.getName().equals("MIN") || obj.getName().equals("MAX")) {
            // empty if block
        }
    }

    public void visit(IsNull obj) {
        this.visitNode((LanguageObject)obj.getExpression());
        Column column = (Column)this.onGoingExpression.pop();
        this.doScanEvaluation = true;
    }

    public void visit(Literal obj) {
        this.onGoingExpression.push(obj.getValue());
    }

    public void visit(NamedTable obj) {
        this.scanTable = obj.getMetadataObject();
    }

    private static HashMap<String, String> buildEvaluatorOptions(Table table) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("TABLE", table.getName());
        String ddl = DDLStringVisitor.getDDLString((Schema)((Schema)table.getParent()), null, (String)table.getName());
        options.put("DDL", ddl);
        return options;
    }
}

