/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.accumulo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.accumulo.AccumuloConnection;
import org.teiid.translator.accumulo.AccumuloDataTypeManager;
import org.teiid.translator.accumulo.AccumuloExecutionFactory;
import org.teiid.translator.accumulo.AccumuloMetadataProcessor;
import org.teiid.translator.accumulo.AccumuloPlugin;
import org.teiid.translator.accumulo.AccumuloQueryExecution;
import org.teiid.translator.accumulo.AccumuloQueryVisitor;

public class AccumuloUpdateExecution
implements UpdateExecution {
    private Command command;
    private AccumuloConnection connection;
    private AccumuloExecutionFactory aef;
    private int updateCount = 0;
    private ExecutionContext executionContext;

    public AccumuloUpdateExecution(AccumuloExecutionFactory aef, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, AccumuloConnection connection) {
        this.aef = aef;
        this.command = command;
        this.connection = connection;
        this.executionContext = executionContext;
    }

    public void execute() throws TranslatorException {
        try {
            if (this.command instanceof Insert) {
                Insert insert = (Insert)this.command;
                this.performInsert(insert);
            } else if (this.command instanceof Update) {
                Update update = (Update)this.command;
                this.performUpdate(update);
            } else if (this.command instanceof Delete) {
                Delete delete = (Delete)this.command;
                this.performDelete(delete);
            }
        }
        catch (MutationsRejectedException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (TableNotFoundException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void performInsert(Insert insert) throws TranslatorException, TableNotFoundException, MutationsRejectedException {
        Table table = insert.getTable().getMetadataObject();
        this.updateCount = 0;
        Connector connector = this.connection.getInstance();
        BatchWriter writer = this.createBatchWriter(table, connector);
        List columns = insert.getColumns();
        if (insert.getParameterValues() == null) {
            List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
            this.writeMutation(writer, columns, values);
            ++this.updateCount;
        } else {
            int batchSize = this.executionContext.getBatchSize();
            Iterator args = insert.getParameterValues();
            while (args.hasNext()) {
                List values = (List)args.next();
                this.writeMutation(writer, columns, values);
                ++this.updateCount;
                if (this.updateCount % batchSize != 0) continue;
                writer.close();
                writer = this.createBatchWriter(table, connector);
            }
        }
        writer.close();
    }

    private void writeMutation(BatchWriter writer, List<ColumnReference> columns, List<Expression> values) throws MutationsRejectedException, TranslatorException {
        byte[] rowId = this.getRowId(columns, values);
        Mutation mutation = new Mutation(rowId);
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i).getMetadataObject();
            if (SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equalsIgnoreCase("rowid")) continue;
            Expression value = values.get(i);
            if (value instanceof Literal) {
                this.buildMutation(mutation, column, ((Literal)value).getValue());
                continue;
            }
            this.buildMutation(mutation, column, value);
        }
        writer.addMutation(mutation);
    }

    private void performUpdate(Update update) throws TranslatorException, TableNotFoundException, MutationsRejectedException {
        Table table = update.getTable().getMetadataObject();
        if (update.getParameterValues() != null) {
            throw new TranslatorException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19005, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19005, new Object[0]));
        }
        AccumuloQueryVisitor visitor = new AccumuloQueryVisitor(this.aef);
        visitor.visitNode((LanguageObject)update.getWhere());
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        Connector connector = this.connection.getInstance();
        BatchWriter writer = this.createBatchWriter(table, connector);
        Text prevRow = null;
        Iterator<Map.Entry<Key, Value>> results = AccumuloQueryExecution.runQuery(this.aef, this.connection.getInstance(), this.connection.getAuthorizations(), visitor.getRanges(), table, visitor.scanIterators());
        while (results.hasNext()) {
            Key key = results.next().getKey();
            Text rowId = key.getRow();
            if (prevRow != null && prevRow.equals((Object)rowId)) continue;
            prevRow = rowId;
            Mutation mutation = new Mutation(rowId);
            List changes = update.getChanges();
            for (SetClause clause : changes) {
                Column column = clause.getSymbol().getMetadataObject();
                if (SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equalsIgnoreCase("rowid")) {
                    throw new TranslatorException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19002, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19002, new Object[]{table.getName()}));
                }
                Expression value = clause.getValue();
                if (value instanceof Literal) {
                    this.buildMutation(mutation, column, ((Literal)value).getValue());
                    continue;
                }
                throw new TranslatorException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19001, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19001, new Object[0]));
            }
            writer.addMutation(mutation);
            ++this.updateCount;
        }
        writer.close();
    }

    private BatchWriter createBatchWriter(Table table, Connector connector) throws TranslatorException, TableNotFoundException {
        BatchWriter writer;
        String tableName = SQLStringVisitor.getRecordName((AbstractMetadataRecord)table);
        try {
            writer = connector.createBatchWriter(tableName, new BatchWriterConfig());
        }
        catch (TableNotFoundException e) {
            try {
                connector.tableOperations().create(tableName, true, TimeType.LOGICAL);
            }
            catch (AccumuloException e1) {
                throw new TranslatorException((Throwable)e1);
            }
            catch (AccumuloSecurityException e1) {
                throw new TranslatorException((Throwable)e1);
            }
            catch (TableExistsException e1) {
                throw new TranslatorException((Throwable)e1);
            }
            writer = connector.createBatchWriter(tableName, new BatchWriterConfig());
        }
        return writer;
    }

    private void performDelete(Delete delete) throws TableNotFoundException, MutationsRejectedException, TranslatorException {
        if (delete.getParameterValues() != null) {
            throw new TranslatorException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19005, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19005, new Object[0]));
        }
        Table table = delete.getTable().getMetadataObject();
        AccumuloQueryVisitor visitor = new AccumuloQueryVisitor(this.aef);
        visitor.visitNode((LanguageObject)delete.getWhere());
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        Text prevRow = null;
        Connector connector = this.connection.getInstance();
        BatchWriter writer = this.createBatchWriter(table, connector);
        Iterator<Map.Entry<Key, Value>> results = AccumuloQueryExecution.runQuery(this.aef, this.connection.getInstance(), this.connection.getAuthorizations(), visitor.getRanges(), table, null);
        while (results.hasNext()) {
            Key key = results.next().getKey();
            Text rowId = key.getRow();
            if (prevRow == null || !prevRow.equals((Object)rowId)) {
                ++this.updateCount;
            }
            prevRow = rowId;
            Mutation mutation = new Mutation(rowId);
            mutation.putDelete(key.getColumnFamily(), key.getColumnQualifier());
            writer.addMutation(mutation);
        }
        writer.close();
    }

    private byte[] getRowId(List<ColumnReference> columns, List<Expression> values) throws TranslatorException {
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i).getMetadataObject();
            String rowId = SQLStringVisitor.getRecordName((AbstractMetadataRecord)column);
            if (!rowId.equalsIgnoreCase("rowid") && !AccumuloQueryVisitor.isPartOfPrimaryKey(column)) continue;
            Expression value = values.get(i);
            if (value instanceof Literal) {
                return AccumuloDataTypeManager.serialize(((Literal)value).getValue());
            }
            throw new TranslatorException((BundleUtil.Event)AccumuloPlugin.Event.TEIID19006, AccumuloPlugin.Util.gs((BundleUtil.Event)AccumuloPlugin.Event.TEIID19006, new Object[0]));
        }
        return null;
    }

    private void buildMutation(Mutation mutation, Column column, Object value) {
        String CF = column.getProperty("teiid_accumulo:CF", false);
        String CQ = column.getProperty("teiid_accumulo:CQ", false);
        String valuePattern = column.getProperty("teiid_accumulo:VALUE-IN", false);
        if (valuePattern == null) {
            valuePattern = "{VALUE}";
        }
        byte[] columnFamily = CF.getBytes();
        byte[] columnQualifier = CQ == null ? AccumuloDataTypeManager.EMPTY_BYTES : CQ.getBytes();
        byte[] columnValue = AccumuloDataTypeManager.EMPTY_BYTES;
        if ((valuePattern = valuePattern.substring(1, valuePattern.length() - 1)).equals(AccumuloMetadataProcessor.ValueIn.VALUE.name())) {
            columnValue = AccumuloDataTypeManager.serialize(value);
        } else if (valuePattern.equals(AccumuloMetadataProcessor.ValueIn.CQ.name())) {
            columnQualifier = AccumuloDataTypeManager.serialize(value);
        }
        mutation.put(columnFamily, columnQualifier, columnValue);
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.updateCount};
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

