/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.amazon.s3;

import java.nio.charset.Charset;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.language.Call;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.WSConnection;
import org.teiid.translator.amazon.s3.S3ProcedureExecution;

@Translator(name="amazon-s3", description="Amazon S3 Translator, reads contents of files or writes to them")
public class S3ExecutionFactory
extends ExecutionFactory<ConnectionFactory, WSConnection> {
    public static BundleUtil UTIL = BundleUtil.getBundleUtil(S3ExecutionFactory.class);
    public static final String GETTEXTFILE = "getTextFile";
    public static final String GETFILE = "getFile";
    public static final String SAVEFILE = "saveFile";
    public static final String DELETEFILE = "deleteFile";
    public static final String LISTBUCKET = "list";
    private Charset encoding = Charset.defaultCharset();
    private String awsAccessKey;
    private String awsSecretKey;
    private String bucket;
    private String region;
    private String encryption;
    private String encryptionKey;

    public S3ExecutionFactory() {
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSourceRequiredForMetadata(false);
    }

    @TranslatorProperty(display="File Encoding", advanced=true)
    public String getEncoding() {
        return this.encoding.name();
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    @TranslatorProperty(display="Amazon Access Key", advanced=true)
    public String getAccesskey() {
        return this.awsAccessKey;
    }

    public void setAccesskey(String value) {
        this.awsAccessKey = value;
    }

    @TranslatorProperty(display="Amazon Secret Key", advanced=true)
    public String getSecretkey() {
        return this.awsSecretKey;
    }

    public void setSecretkey(String value) {
        this.awsSecretKey = value;
    }

    @TranslatorProperty(display="Amazon Region", advanced=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String value) {
        this.region = value;
    }

    @TranslatorProperty(display="Amazon Bucket", advanced=true)
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String value) {
        this.bucket = value;
    }

    @TranslatorProperty(display="Server Side Customer Encryption Algorithm Used", advanced=true)
    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String value) {
        this.encryption = value;
    }

    @TranslatorProperty(display="Server Side Customer Encryption Key to be used to decrypt the object", advanced=true)
    public String getEncryptionkey() {
        return this.encryptionKey;
    }

    public void setEncryptionkey(String value) {
        this.encryptionKey = value;
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection conn) throws TranslatorException {
        return new S3ProcedureExecution(command, this, metadata, executionContext, conn);
    }

    public void getMetadata(MetadataFactory metadataFactory, WSConnection connection) throws TranslatorException {
        this.addGetTextFileMethod(metadataFactory);
        this.addGetFileMethod(metadataFactory);
        this.saveFile(metadataFactory);
        this.deleteFile(metadataFactory);
        this.listBucket(metadataFactory);
        Table t = metadataFactory.addTable("Bucket");
        t.setVirtual(true);
        t.setSupportsUpdate(false);
        metadataFactory.addColumn("Key", "string", (ColumnSet)t);
        metadataFactory.addColumn("LastModified", "string", (ColumnSet)t);
        metadataFactory.addColumn("ETag", "string", (ColumnSet)t);
        metadataFactory.addColumn("Size", "string", (ColumnSet)t);
        metadataFactory.addColumn("StorageClass", "string", (ColumnSet)t);
        metadataFactory.addColumn("NextContinuationToken", "string", (ColumnSet)t);
        t.setSelectTransformation("select b.* from (exec list()) as a,  XMLTABLE(XMLNAMESPACES(DEFAULT 'http://s3.amazonaws.com/doc/2006-03-01/'), '/ListBucketResult/Contents' \n PASSING XMLPARSE(CONTENT a.result WELLFORMED) COLUMNS Key string, LastModified string, ETag string, Size string, StorageClass string, \n NextContinuationToken string PATH '../NextContinuationToken') as b;");
    }

    private void saveFile(MetadataFactory metadataFactory) {
        Procedure p = metadataFactory.addProcedure(SAVEFILE);
        p.setAnnotation("Saves the given value to the given bucket.  Any existing file will be overriden.");
        ProcedureParameter param = metadataFactory.addProcedureParameter("name", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The name of the object to save");
        this.addCommonParameters(metadataFactory, p);
        param = metadataFactory.addProcedureParameter("contents", "object", ProcedureParameter.Type.In, p);
        param.setAnnotation("The contents to save.  Can be one of CLOB, BLOB, or XML");
    }

    private void listBucket(MetadataFactory metadataFactory) {
        Procedure p = metadataFactory.addProcedure(LISTBUCKET);
        p.setAnnotation("Lists the Objects in a given bucket.");
        ProcedureParameter param = metadataFactory.addProcedureParameter("bucket", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The name of the bucket in Amazon S3");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("region", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("region in which the bucket exists on Amazon S3");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("accesskey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Security Access Key, if not provided will use translator configured keys.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("secretkey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Security Secret Key, if not provided will use translator configured keys.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("nexttoken", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("If the response is truncated, Amazon S3 returns this parameter with a continuation token that you can specify as the continuation-token in your next request to retrieve the next set of keys");
        param.setNullType(BaseColumn.NullType.Nullable);
        metadataFactory.addProcedureResultSetColumn("result", "clob", p);
    }

    private void deleteFile(MetadataFactory metadataFactory) {
        Procedure p = metadataFactory.addProcedure(DELETEFILE);
        p.setAnnotation("Delete the given file from bucket.");
        ProcedureParameter param = metadataFactory.addProcedureParameter("name", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Name of the file");
        this.addCommonParameters(metadataFactory, p);
    }

    private void addCommonParameters(MetadataFactory metadataFactory, Procedure p) {
        ProcedureParameter param = metadataFactory.addProcedureParameter("bucket", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The name of the bucket in Amazon S3");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("region", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("region in which the bucket exists on Amazon S3");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("endpoint", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Endpoint point of the Object, if provided this overwirtes the name and bucket properties");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("accesskey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Security Access Key, if not provided will use translator configured keys.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("secretkey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Security Secret Key, if not provided will use translator configured keys.");
        param.setNullType(BaseColumn.NullType.Nullable);
    }

    private void addGetTextFileMethod(MetadataFactory metadataFactory) {
        Procedure p = metadataFactory.addProcedure(GETTEXTFILE);
        p.setAnnotation("Returns text files that match the given path as CLOBs");
        ProcedureParameter param = metadataFactory.addProcedureParameter("name", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The name of the file to return.  Currently the patterns like *.<ext> are not supported");
        this.addCommonParameters(metadataFactory, p);
        param = metadataFactory.addProcedureParameter("encryption", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Server side encryption algorithm used");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("encryptionkey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Server side encryption key to decrypt the object");
        param.setNullType(BaseColumn.NullType.Nullable);
        metadataFactory.addProcedureResultSetColumn("file", "clob", p);
        metadataFactory.addProcedureResultSetColumn("endpoint", "string", p);
        metadataFactory.addProcedureResultSetColumn("lastModified", "timestamp", p);
        metadataFactory.addProcedureResultSetColumn("etag", "string", p);
        metadataFactory.addProcedureResultSetColumn("size", "long", p);
    }

    private void addGetFileMethod(MetadataFactory metadataFactory) {
        Procedure p = metadataFactory.addProcedure(GETFILE);
        p.setAnnotation("Returns file that match the given path as BLOB");
        ProcedureParameter param = metadataFactory.addProcedureParameter("name", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The name of the file to return.  Currently the patterns like *.<ext> are not supported");
        this.addCommonParameters(metadataFactory, p);
        param = metadataFactory.addProcedureParameter("encryption", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Server side encryption algorithm used");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("encryptionkey", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Server side encryption key to decrypt the object");
        param.setNullType(BaseColumn.NullType.Nullable);
        metadataFactory.addProcedureResultSetColumn("file", "blob", p);
        metadataFactory.addProcedureResultSetColumn("endpoint", "string", p);
        metadataFactory.addProcedureResultSetColumn("lastModified", "timestamp", p);
        metadataFactory.addProcedureResultSetColumn("etag", "string", p);
        metadataFactory.addProcedureResultSetColumn("size", "long", p);
    }

    public boolean areLobsUsableAfterClose() {
        return true;
    }
}

