/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.amazon.s3;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.amazon.s3.AWS4SignerBase;
import org.teiid.translator.amazon.s3.AWS4SignerForAuthorizationHeader;
import org.teiid.translator.amazon.s3.BinaryUtils;
import org.teiid.translator.amazon.s3.S3ExecutionFactory;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class S3ProcedureExecution
implements ProcedureExecution {
    private final Call command;
    private final WSConnection conn;
    private S3ExecutionFactory ef;
    private RuntimeMetadata metadata;
    private ExecutionContext ec;
    private String endpoint;
    private BinaryWSProcedureExecution execution = null;
    boolean isText = false;
    boolean isList = false;
    boolean streaming = false;

    public S3ProcedureExecution(Call command, S3ExecutionFactory ef, RuntimeMetadata metadata, ExecutionContext ec, WSConnection conn) {
        this.command = command;
        this.conn = conn;
        this.ef = ef;
        this.metadata = metadata;
        this.ec = ec;
    }

    public void execute() throws TranslatorException {
        List arguments = this.command.getArguments();
        if (this.command.getProcedureName().equalsIgnoreCase("saveFile")) {
            this.execution = this.saveFile(arguments);
            this.execution.execute();
            if (this.execution.getResponseCode() != 200) {
                throw new TranslatorException(S3ExecutionFactory.UTIL.gs("error_writing", new Object[]{this.endpoint, this.execution.getResponseCode(), this.getErrorDescription()}));
            }
        } else if (this.command.getProcedureName().equalsIgnoreCase("deleteFile")) {
            this.execution = this.deleteFile(arguments);
            this.execution.execute();
            if (this.execution.getResponseCode() != 204) {
                throw new TranslatorException(S3ExecutionFactory.UTIL.gs("error_deleting", new Object[]{this.endpoint, this.execution.getResponseCode(), this.getErrorDescription()}));
            }
        } else if (this.command.getProcedureName().equalsIgnoreCase("getFile") || this.command.getProcedureName().equalsIgnoreCase("getTextFile")) {
            if (this.command.getProcedureName().equalsIgnoreCase("getTextFile")) {
                this.isText = true;
            }
            this.execution = this.getFile(arguments);
            this.execution.execute();
            if (this.execution.getResponseCode() != 200) {
                throw new TranslatorException(S3ExecutionFactory.UTIL.gs("error_reading", new Object[]{this.endpoint, this.execution.getResponseCode(), this.getErrorDescription()}));
            }
        } else if (this.command.getProcedureName().equalsIgnoreCase("list")) {
            this.execution = this.listBucket(arguments);
            this.execution.execute();
            if (this.execution.getResponseCode() != 200) {
                throw new TranslatorException(S3ExecutionFactory.UTIL.gs("error_list", new Object[]{this.endpoint, this.execution.getResponseCode(), this.getErrorDescription()}));
            }
        }
    }

    private BinaryWSProcedureExecution saveFile(List<Argument> arguments) throws TranslatorException {
        Object file;
        String name = (String)arguments.get(0).getArgumentValue().getValue();
        String bucket = (String)arguments.get(1).getArgumentValue().getValue();
        String region = (String)arguments.get(2).getArgumentValue().getValue();
        this.endpoint = (String)arguments.get(3).getArgumentValue().getValue();
        String accessKey = (String)arguments.get(4).getArgumentValue().getValue();
        String secretKey = (String)arguments.get(5).getArgumentValue().getValue();
        if (bucket == null) {
            bucket = this.ef.getBucket();
        }
        if (region == null) {
            region = this.ef.getRegion();
        }
        if (this.endpoint == null) {
            this.endpoint = region.equals("us-east-1") ? "https://s3.amazonaws.com/" + bucket + "/" + name : "https://s3-" + region + ".amazonaws.com/" + bucket + "/" + name;
        }
        if (accessKey == null) {
            accessKey = this.ef.getAccesskey();
        }
        if (secretKey == null) {
            secretKey = this.ef.getSecretkey();
        }
        if ((file = ((Argument)this.command.getArguments().get(6)).getArgumentValue().getValue()) == null) {
            throw new TranslatorException(S3ExecutionFactory.UTIL.getString("non_null"));
        }
        try {
            long length = 0L;
            byte[] contents = null;
            if (file instanceof XMLType) {
                length = ((XMLType)file).length();
                contents = ObjectConverterUtil.convertToByteArray((InputStream)((XMLType)file).getBinaryStream());
            } else if (file instanceof Clob) {
                length = ((Clob)file).length();
                contents = ObjectConverterUtil.convertToByteArray((InputStream)((Clob)file).getAsciiStream());
            } else if (file instanceof Blob) {
                length = ((Blob)file).length();
                contents = ObjectConverterUtil.convertToByteArray((InputStream)((Blob)file).getBinaryStream());
            } else if (file instanceof String) {
                length = ((String)file).length();
                contents = ((String)file).getBytes();
            } else {
                throw new TranslatorException(S3ExecutionFactory.UTIL.getString("unknown_type"));
            }
            byte[] contentHash = AWS4SignerBase.hash(contents);
            String contentHashString = BinaryUtils.toHex(contentHash);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-amz-content-sha256", contentHashString);
            headers.put("content-length", "" + length);
            headers.put("x-amz-storage-class", "STANDARD");
            if (accessKey != null) {
                AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(new URL(this.endpoint), "PUT", "s3", region);
                String authorization = signer.computeSignature(headers, null, contentHashString, accessKey, secretKey);
                headers.put("Authorization", authorization);
            }
            headers.put("Content-Type", "application/octet-stream");
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Saving", (Object)this.endpoint);
            return this.invokeHTTP("PUT", this.endpoint, new BlobType(contents), headers);
        }
        catch (IOException | SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private BinaryWSProcedureExecution getFile(List<Argument> arguments) throws TranslatorException {
        String name = (String)arguments.get(0).getArgumentValue().getValue();
        String bucket = (String)arguments.get(1).getArgumentValue().getValue();
        String region = (String)arguments.get(2).getArgumentValue().getValue();
        this.endpoint = (String)arguments.get(3).getArgumentValue().getValue();
        String accessKey = (String)arguments.get(4).getArgumentValue().getValue();
        String secretKey = (String)arguments.get(5).getArgumentValue().getValue();
        String encryption = (String)arguments.get(6).getArgumentValue().getValue();
        String encryptionKey = (String)arguments.get(7).getArgumentValue().getValue();
        Boolean isStreaming = (Boolean)arguments.get(8).getArgumentValue().getValue();
        if (isStreaming != null) {
            this.streaming = isStreaming;
        }
        if (bucket == null) {
            bucket = this.ef.getBucket();
        }
        if (region == null) {
            region = this.ef.getRegion();
        }
        if (this.endpoint == null) {
            this.endpoint = "https://s3.amazonaws.com/" + bucket + "/" + name;
        }
        if (accessKey == null) {
            accessKey = this.ef.getAccesskey();
        }
        if (secretKey == null) {
            secretKey = this.ef.getSecretkey();
        }
        if (encryption == null) {
            encryption = this.ef.getEncryption();
        }
        if (encryptionKey == null) {
            encryptionKey = this.ef.getEncryptionkey();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            if (accessKey != null) {
                AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(new URL(this.endpoint), "GET", "s3", region);
                String authorization = signer.computeSignature(headers, null, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", accessKey, secretKey);
                headers.put("Authorization", authorization);
                headers.put("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
            }
            if (encryption != null) {
                assert (encryptionKey != null);
                headers.put("x-amz-server-side\u200b-encryption\u200b-customer-algorithm", encryption);
                headers.put("x-amz-server-side\u200b-encryption\u200b-customer-key", encryptionKey);
                MessageDigest messageDigest = MessageDigest.getInstance("md5");
                headers.put("x-amz-server-side\u200b-encryption\u200b-customer-key-MD5", Base64.getEncoder().encodeToString(messageDigest.digest(encryptionKey.getBytes())));
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Getting", (Object)this.endpoint);
            return this.invokeHTTP("GET", this.endpoint, null, headers);
        }
        catch (MalformedURLException | NoSuchAlgorithmException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private BinaryWSProcedureExecution deleteFile(List<Argument> arguments) throws TranslatorException {
        String name = (String)arguments.get(0).getArgumentValue().getValue();
        String bucket = (String)arguments.get(1).getArgumentValue().getValue();
        String region = (String)arguments.get(2).getArgumentValue().getValue();
        this.endpoint = (String)arguments.get(3).getArgumentValue().getValue();
        String accessKey = (String)arguments.get(4).getArgumentValue().getValue();
        String secretKey = (String)arguments.get(5).getArgumentValue().getValue();
        if (bucket == null) {
            bucket = this.ef.getBucket();
        }
        if (region == null) {
            region = this.ef.getRegion();
        }
        if (this.endpoint == null) {
            this.endpoint = region.equals("us-east-1") ? "https://s3.amazonaws.com/" + bucket + "/" + name : "https://s3-" + region + ".amazonaws.com/" + bucket + "/" + name;
        }
        if (accessKey == null) {
            accessKey = this.ef.getAccesskey();
        }
        if (secretKey == null) {
            secretKey = this.ef.getSecretkey();
        }
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (accessKey != null) {
                AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(new URL(this.endpoint), "DELETE", "s3", region);
                String authorization = signer.computeSignature(headers, null, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", accessKey, secretKey);
                headers.put("Authorization", authorization);
                headers.put("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
            }
            headers.put("Content-Type", "text/plain");
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Deleting", (Object)this.endpoint);
            return this.invokeHTTP("DELETE", this.endpoint, null, headers);
        }
        catch (MalformedURLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private BinaryWSProcedureExecution listBucket(List<Argument> arguments) throws TranslatorException {
        String bucket = (String)arguments.get(0).getArgumentValue().getValue();
        String region = (String)arguments.get(1).getArgumentValue().getValue();
        String accessKey = (String)arguments.get(2).getArgumentValue().getValue();
        String secretKey = (String)arguments.get(3).getArgumentValue().getValue();
        String next = (String)arguments.get(4).getArgumentValue().getValue();
        if (bucket == null) {
            bucket = this.ef.getBucket();
        }
        if (region == null) {
            region = this.ef.getRegion();
        }
        if (this.endpoint == null) {
            this.endpoint = "https://s3.amazonaws.com/" + bucket + "/?list-type=2";
            if (next != null) {
                this.endpoint = this.endpoint + "&continuation-token=" + next;
            }
        }
        if (accessKey == null) {
            accessKey = this.ef.getAccesskey();
        }
        if (secretKey == null) {
            secretKey = this.ef.getSecretkey();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            if (accessKey != null) {
                URL url = new URL(this.endpoint);
                AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(url, "GET", "s3", region);
                HashMap<String, String> query = new HashMap<String, String>();
                query.put("list-type", "2");
                if (next != null) {
                    query.put("continuation-token", next);
                }
                String authorization = signer.computeSignature(headers, query, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", accessKey, secretKey);
                headers.put("Authorization", authorization);
                headers.put("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
            }
            this.isText = true;
            this.isList = true;
            LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Getting", (Object)this.endpoint);
            return this.invokeHTTP("GET", this.endpoint, null, headers);
        }
        catch (MalformedURLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    protected BinaryWSProcedureExecution invokeHTTP(String method, String uri, Object payload, Map<String, String> headers) throws TranslatorException {
        HashMap targetHeaders = new HashMap();
        headers.forEach((k, v) -> targetHeaders.put(k, Arrays.asList(v)));
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR.WS", (int)5)) {
            try {
                LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"Source-URL=", (Object)URLDecoder.decode(uri, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        ArrayList<Argument> parameters = new ArrayList<Argument>();
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)method, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal(payload, TypeFacility.RUNTIME_TYPES.OBJECT), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)uri, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)true, TypeFacility.RUNTIME_TYPES.BOOLEAN), null));
        parameters.add(new Argument(Argument.Direction.OUT, TypeFacility.RUNTIME_TYPES.STRING, null));
        Call call = this.ef.getLanguageFactory().createCall("invokeHttp", parameters, null);
        BinaryWSProcedureExecution execution = new BinaryWSProcedureExecution(call, this.metadata, this.ec, null, this.conn);
        execution.setUseResponseContext(true);
        execution.setCustomHeaders(targetHeaders);
        return execution;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private String getHeader(String name) {
        ArrayList list = (ArrayList)this.execution.getResponseHeader(name);
        return list == null || list.isEmpty() ? null : (String)list.get(0);
    }

    private String getErrorDescription() throws TranslatorException {
        try {
            if (this.execution != null) {
                Blob contents = (Blob)this.execution.getOutputParameterValues().get(0);
                return ObjectConverterUtil.convertToString((InputStream)contents.getBinaryStream());
            }
            return null;
        }
        catch (IOException | NumberFormatException | SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.command.getProcedureName().equalsIgnoreCase("saveFile") || this.command.getProcedureName().equalsIgnoreCase("deleteFile")) {
            return null;
        }
        if (this.execution == null || this.execution.getResponseCode() < 200 || this.execution.getResponseCode() > 300) {
            return null;
        }
        Blob contents = (Blob)this.execution.getOutputParameterValues().get(0);
        InputStreamFactory.BlobInputStreamFactory isf = new InputStreamFactory.BlobInputStreamFactory(contents);
        String length = this.getHeader("Content-Length");
        if (length != null) {
            isf.setLength(Long.parseLong(length));
        }
        Object value = null;
        if (this.isText) {
            ClobImpl clob = new ClobImpl((InputStreamFactory)isf, -1L);
            clob.setCharset(Charset.forName(this.ef.getEncoding()));
            value = new ClobType((Clob)clob);
            if (!this.streaming) {
                value = new InputStreamFactory.ClobInputStreamFactory((Clob)clob);
            }
        } else {
            value = this.streaming ? new BlobType(contents) : isf;
        }
        String lastModified = this.getHeader("Last-Modified");
        ArrayList<Object> result = new ArrayList<Object>(2);
        result.add(value);
        if (!this.isList) {
            result.add(this.endpoint);
            try {
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz");
                result.add(lastModified == null ? null : new Timestamp(df.parse(lastModified).getTime()));
            }
            catch (ParseException e) {
                result.add(null);
            }
            result.add(this.getHeader("ETag"));
            result.add(length);
        }
        this.execution = null;
        return result;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return Collections.emptyList();
    }
}

