/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.amazon.s3;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.teiid.logging.LogManager;
import org.teiid.translator.amazon.s3.AWS4SignerBase;
import org.teiid.translator.amazon.s3.BinaryUtils;

public class AWS4SignerForChunkedUpload
extends AWS4SignerBase {
    public static final String STREAMING_BODY_SHA256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String CLRF = "\r\n";
    private static final String CHUNK_STRING_TO_SIGN_PREFIX = "AWS4-HMAC-SHA256-PAYLOAD";
    private static final String CHUNK_SIGNATURE_HEADER = ";chunk-signature=";
    private static final int SIGNATURE_LENGTH = 64;
    private static final byte[] FINAL_CHUNK = new byte[0];
    private String lastComputedSignature;
    private String dateTimeStamp;
    private String scope;
    private byte[] signingKey;

    public AWS4SignerForChunkedUpload(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        this.dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", this.dateTimeStamp);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWS4SignerForChunkedUpload.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4SignerForChunkedUpload.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AWS4SignerForChunkedUpload.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4SignerForChunkedUpload.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"--------- Canonical request --------");
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)canonicalRequest);
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"------------------------------------");
        String dateStamp = this.dateStampFormat.format(now);
        this.scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        String stringToSign = AWS4SignerForChunkedUpload.getStringToSign("AWS4", "HMAC-SHA256", this.dateTimeStamp, this.scope, canonicalRequest);
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"--------- String to sign -----------");
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)stringToSign);
        LogManager.logDetail((String)"org.teiid.CONNECTOR.WS", (Object)"------------------------------------");
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes();
        byte[] kDate = AWS4SignerForChunkedUpload.sign(dateStamp, kSecret, "HmacSHA256");
        byte[] kRegion = AWS4SignerForChunkedUpload.sign(this.regionName, kDate, "HmacSHA256");
        byte[] kService = AWS4SignerForChunkedUpload.sign(this.serviceName, kRegion, "HmacSHA256");
        this.signingKey = AWS4SignerForChunkedUpload.sign("aws4_request", kService, "HmacSHA256");
        byte[] signature = AWS4SignerForChunkedUpload.sign(stringToSign, this.signingKey, "HmacSHA256");
        this.lastComputedSignature = BinaryUtils.toHex(signature);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + this.scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + this.lastComputedSignature;
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        return authorizationHeader;
    }

    public static long calculateChunkedContentLength(long originalLength, long chunkSize) {
        if (originalLength <= 0L) {
            throw new IllegalArgumentException("Nonnegative content length expected.");
        }
        long maxSizeChunks = originalLength / chunkSize;
        long remainingBytes = originalLength % chunkSize;
        return maxSizeChunks * AWS4SignerForChunkedUpload.calculateChunkHeaderLength(chunkSize) + (remainingBytes > 0L ? AWS4SignerForChunkedUpload.calculateChunkHeaderLength(remainingBytes) : 0L) + AWS4SignerForChunkedUpload.calculateChunkHeaderLength(0L);
    }

    private static long calculateChunkHeaderLength(long chunkDataSize) {
        return (long)(Long.toHexString(chunkDataSize).length() + CHUNK_SIGNATURE_HEADER.length() + 64 + CLRF.length()) + chunkDataSize + (long)CLRF.length();
    }

    public byte[] constructSignedChunk(int userDataLen, byte[] userData) {
        String chunkSignature;
        byte[] dataToChunk;
        if (userDataLen == 0) {
            dataToChunk = FINAL_CHUNK;
        } else if (userDataLen < userData.length) {
            dataToChunk = new byte[userDataLen];
            System.arraycopy(userData, 0, dataToChunk, 0, userDataLen);
        } else {
            dataToChunk = userData;
        }
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(dataToChunk.length));
        String nonsigExtension = "";
        String chunkStringToSign = "AWS4-HMAC-SHA256-PAYLOAD\n" + this.dateTimeStamp + "\n" + this.scope + "\n" + this.lastComputedSignature + "\n" + BinaryUtils.toHex(AWS4SignerBase.hash(nonsigExtension)) + "\n" + BinaryUtils.toHex(AWS4SignerBase.hash(dataToChunk));
        this.lastComputedSignature = chunkSignature = BinaryUtils.toHex(AWS4SignerBase.sign(chunkStringToSign, this.signingKey, "HmacSHA256"));
        chunkHeader.append(nonsigExtension + CHUNK_SIGNATURE_HEADER + chunkSignature);
        chunkHeader.append(CLRF);
        try {
            byte[] header = chunkHeader.toString().getBytes("UTF-8");
            byte[] trailer = CLRF.getBytes("UTF-8");
            byte[] signedChunk = new byte[header.length + dataToChunk.length + trailer.length];
            System.arraycopy(header, 0, signedChunk, 0, header.length);
            System.arraycopy(dataToChunk, 0, signedChunk, header.length, dataToChunk.length);
            System.arraycopy(trailer, 0, signedChunk, header.length + dataToChunk.length, trailer.length);
            return signedChunk;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sign the chunked data. " + e.getMessage(), e);
        }
    }
}

