/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraExecutionFactory;

public class TestNativeCassandra {
    @Test
    public void testDirect() throws TranslatorException {
        CassandraExecutionFactory cef = new CassandraExecutionFactory();
        cef.setSupportsDirectQueryProcedure(true);
        String input = "call native('select $1', 'a')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        CassandraConnection connection = (CassandraConnection)Mockito.mock(CassandraConnection.class);
        ResultSetFuture rsf = (ResultSetFuture)Mockito.mock(ResultSetFuture.class);
        Mockito.stub((Object)rsf.isDone()).toReturn((Object)true);
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.stub((Object)rsf.getUninterruptibly()).toReturn((Object)rs);
        Row row = (Row)Mockito.mock(Row.class);
        ColumnDefinitions cd = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.stub((Object)row.getColumnDefinitions()).toReturn((Object)cd);
        Mockito.stub((Object)rs.one()).toReturn((Object)row).toReturn(null);
        Mockito.stub((Object)connection.executeQuery("select 'a'")).toReturn((Object)rsf);
        ResultSetExecution execution = (ResultSetExecution)cef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        List vals = execution.next();
        Assert.assertTrue((boolean)(vals.get(0) instanceof Object[]));
    }

    @Test
    public void testNativeQuery() throws Exception {
        CassandraExecutionFactory cef = new CassandraExecutionFactory();
        cef.setSupportsDirectQueryProcedure(true);
        String input = "call proc('a', 1)";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)"create foreign procedure proc (in x string, in y integer) options (\"teiid_rel:native-query\" 'delete from $1 where $2')", (String)"x", (String)"y");
        TranslationUtility util = new TranslationUtility((QueryMetadataInterface)metadata);
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        CassandraConnection connection = (CassandraConnection)Mockito.mock(CassandraConnection.class);
        ResultSetFuture rsf = (ResultSetFuture)Mockito.mock(ResultSetFuture.class);
        Mockito.stub((Object)connection.executeQuery("delete from 'a' where 1")).toReturn((Object)rsf);
        Execution execution = cef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ((CassandraConnection)Mockito.verify((Object)connection)).executeQuery("delete from 'a' where 1");
    }
}

