/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.VersionNumber;
import java.util.List;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraDirectQueryExecution;
import org.teiid.translator.cassandra.CassandraMetadataProcessor;
import org.teiid.translator.cassandra.CassandraQueryExecution;
import org.teiid.translator.cassandra.CassandraUpdateExecution;

@Translator(name="cassandra", description="A translator for Cassandra NoSql database")
public class CassandraExecutionFactory
extends ExecutionFactory<ConnectionFactory, CassandraConnection> {
    private static final VersionNumber DEFAULT_VERSION = VersionNumber.parse((String)"1.2.0");
    private static final VersionNumber V2 = VersionNumber.parse((String)"2.0.0");
    private static final VersionNumber V2_2 = VersionNumber.parse((String)"2.2.0");
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(CassandraExecutionFactory.class);
    private VersionNumber version;

    public void start() throws TranslatorException {
        super.start();
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Cassandra ExecutionFactory Started");
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, CassandraConnection connection) throws TranslatorException {
        return new CassandraQueryExecution((Command)command, connection, executionContext);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, CassandraConnection connection) throws TranslatorException {
        return new CassandraUpdateExecution(command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, CassandraConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new CassandraDirectQueryExecution(nativeQuery, command.getArguments(), (Command)command, connection, executionContext, false);
        }
        throw new TranslatorException("Missing native-query extension metadata.");
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, CassandraConnection connection) throws TranslatorException {
        return new CassandraDirectQueryExecution((String)arguments.get(0).getArgumentValue().getValue(), arguments.subList(1, arguments.size()), command, connection, executionContext, true);
    }

    public MetadataProcessor<CassandraConnection> getMetadataProcessor() {
        return new CassandraMetadataProcessor();
    }

    public boolean supportsOrderBy() {
        return false;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return this.version.compareTo(V2) >= 0;
    }

    public boolean supportsBatchedUpdates() {
        return this.version.compareTo(V2) >= 0;
    }

    public boolean supportsAggregatesSum() {
        return this.version.compareTo(V2_2) >= 0;
    }

    public boolean supportsAggregatesAvg() {
        return this.version.compareTo(V2_2) >= 0;
    }

    public boolean supportsAggregatesMin() {
        return this.version.compareTo(V2_2) >= 0;
    }

    public boolean supportsAggregatesMax() {
        return this.version.compareTo(V2_2) >= 0;
    }

    public boolean returnsSingleUpdateCount() {
        return true;
    }

    public void initCapabilities(CassandraConnection connection) throws TranslatorException {
        if (connection == null) {
            return;
        }
        this.version = connection.getVersion();
        if (this.version == null) {
            this.version = DEFAULT_VERSION;
        }
    }

    public boolean isSourceRequiredForCapabilities() {
        return true;
    }

    public static enum Event implements BundleUtil.Event
    {
        TEIID22000;

    }
}

