/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.TableMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraExecutionFactory;
import org.teiid.util.FullyQualifiedName;

public class CassandraMetadataProcessor
implements MetadataProcessor<CassandraConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Allow Filtering", description="This is to avoid the warning from Cassandra when it might not be able to execute the query in an efficient way", required=false)
    public static final String ALLOWFILTERING = "ALLOWFILTERING";

    public void process(MetadataFactory factory, CassandraConnection connection) throws TranslatorException {
        try {
            for (TableMetadata columnFamily : connection.keyspaceInfo().getTables()) {
                this.addTable(factory, columnFamily);
            }
        }
        catch (TranslatorException e) {
            throw new TranslatorException((BundleUtil.Event)CassandraExecutionFactory.Event.TEIID22000, (Throwable)e, CassandraExecutionFactory.UTIL.gs((BundleUtil.Event)CassandraExecutionFactory.Event.TEIID22000, new Object[0]));
        }
    }

    private void addTable(MetadataFactory factory, TableMetadata columnFamily) {
        Table table = factory.addTable(columnFamily.getName());
        table.setNameInSource(this.quoteName(table.getName()));
        this.addColumnsToTable(factory, table, columnFamily);
        this.addPrimaryKey(factory, table, columnFamily);
        for (IndexMetadata index : columnFamily.getIndexes()) {
            Column c = table.getColumnByName(index.getTarget());
            if (c == null) continue;
            c.setSearchType(Column.SearchType.Searchable);
            factory.addIndex(index.getName(), false, Arrays.asList(index.getTarget()), table);
        }
        table.setSupportsUpdate(true);
        FullyQualifiedName fqn = new FullyQualifiedName();
        fqn.append("keyspace", columnFamily.getKeyspace().getName());
        fqn.append("table", columnFamily.getName());
        table.setProperty("{http://www.teiid.org/ext/relational/2012}fqn", fqn.toString());
    }

    protected String quoteName(String name) {
        return "\"" + StringUtil.replaceAll((String)name, (String)"\"", (String)"\"\"") + "\"";
    }

    private void addPrimaryKey(MetadataFactory factory, Table table, TableMetadata columnFamily) {
        List primaryKeys = columnFamily.getPrimaryKey();
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnMetadata columnName : primaryKeys) {
            names.add(columnName.getName());
            table.getColumnByName(columnName.getName()).setSearchType(Column.SearchType.Searchable);
        }
        factory.addPrimaryKey("PK_" + columnFamily.getName(), names, table);
    }

    private void addColumnsToTable(MetadataFactory factory, Table table, TableMetadata columnFamily) {
        for (ColumnMetadata column : columnFamily.getColumns()) {
            String type = this.asTeiidRuntimeType(column.getType().getName());
            Column c = factory.addColumn(column.getName(), type, (ColumnSet)table);
            c.setUpdatable(true);
            c.setSearchType(Column.SearchType.Unsearchable);
            c.setNameInSource(this.quoteName(c.getName()));
        }
    }

    private String asTeiidRuntimeType(DataType.Name name) {
        switch (name) {
            case ASCII: {
                return "string";
            }
            case BIGINT: {
                return "long";
            }
            case BLOB: {
                return "blob";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case COUNTER: {
                return "long";
            }
            case DECIMAL: {
                return "bigdecimal";
            }
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INET: {
                return "object";
            }
            case INT: {
                return "integer";
            }
            case TEXT: {
                return "string";
            }
            case UUID: {
                return "object";
            }
            case VARCHAR: {
                return "string";
            }
            case VARINT: {
                return "biginteger";
            }
            case LIST: {
                return "object";
            }
            case SET: {
                return "object";
            }
            case MAP: {
                return "object";
            }
            case CUSTOM: {
                return "blob";
            }
            case UDT: {
                return "object";
            }
            case TUPLE: {
                return "object";
            }
            case SMALLINT: {
                return "short";
            }
            case TINYINT: {
                return "byte";
            }
            case TIMEUUID: {
                return "object";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "timestamp";
            }
        }
        return "object";
    }
}

