/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.TypeFacility;

public class CassandraSQLVisitor
extends SQLStringVisitor {
    private static final String ALLOW_FILTERING = "ALLOW FILTERING";

    public String getTranslatedSQL() {
        return this.buffer.toString();
    }

    protected String replaceElementName(String group, String element) {
        return element;
    }

    public void translateSQL(LanguageObject obj) {
        this.append(obj);
    }

    public void visit(Select obj) {
        boolean allowFiltering = false;
        this.buffer.append("SELECT").append(" ");
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            NamedTable table = (NamedTable)obj.getFrom().get(0);
            allowFiltering = Boolean.parseBoolean((String)table.getMetadataObject().getProperties().get("ALLOWFILTERING"));
            if (table.getMetadataObject().getColumns() != null) {
                this.append(obj.getDerivedColumns());
            }
            this.buffer.append(" ").append("FROM").append(" ");
            this.append(obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getLimit());
        }
        if (allowFiltering) {
            this.buffer.append(" ");
            this.buffer.append(ALLOW_FILTERING);
        }
    }

    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            super.visit(obj);
            return;
        }
        if (obj.getValue() instanceof Timestamp) {
            this.buffer.append(((Timestamp)obj.getValue()).getTime());
            return;
        }
        if (obj.getValue() instanceof UUID) {
            this.buffer.append(obj.getValue());
            return;
        }
        Class type = obj.getType();
        if (type == TypeFacility.RUNTIME_TYPES.VARBINARY) {
            this.buffer.append("0x").append(obj.getValue());
            return;
        }
        if (type == TypeFacility.RUNTIME_TYPES.BLOB) {
            this.buffer.append("0x");
            Blob b = (Blob)obj.getValue();
            InputStream binaryStream = null;
            try {
                if (b.length() > Integer.MAX_VALUE) {
                    throw new AssertionError((Object)"Blob is too large");
                }
                binaryStream = b.getBinaryStream();
                PropertiesUtils.toHex((StringBuilder)this.buffer, (InputStream)binaryStream);
            }
            catch (SQLException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            finally {
                if (binaryStream != null) {
                    try {
                        binaryStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        if (!Number.class.isAssignableFrom(type) && type != TypeFacility.RUNTIME_TYPES.BOOLEAN && type != TypeFacility.RUNTIME_TYPES.VARBINARY) {
            type = TypeFacility.RUNTIME_TYPES.STRING;
        }
        super.appendLiteral(obj, type);
    }
}

