/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraExecutionFactory;
import org.teiid.translator.cassandra.CassandraSQLVisitor;

public class CassandraQueryExecution
implements ResultSetExecution {
    private Command query;
    private CassandraConnection connection;
    private ResultSetFuture resultSetFuture;
    private ResultSet resultSet;
    private ExecutionContext executionContext;
    protected boolean returnsArray;

    public CassandraQueryExecution(Command query, CassandraConnection connection, ExecutionContext context) {
        this.query = query;
        this.connection = connection;
        this.executionContext = context;
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CassandraExecutionFactory.UTIL.getString("close_query"));
        this.resultSet = null;
        this.resultSetFuture = null;
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CassandraExecutionFactory.UTIL.getString("cancel_query"));
        if (this.resultSetFuture != null) {
            this.resultSetFuture.cancel(true);
        }
    }

    public void execute() throws TranslatorException {
        CassandraSQLVisitor visitor = new CassandraSQLVisitor();
        visitor.translateSQL((LanguageObject)this.query);
        String cql = visitor.getTranslatedSQL();
        this.execute(cql);
    }

    protected void execute(String cql) {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Source-Query:", (Object)cql);
        this.executionContext.logCommand(new Object[]{cql});
        this.resultSetFuture = this.connection.executeQuery(cql);
        this.resultSetFuture.addListener(new Runnable(){

            @Override
            public void run() {
                CassandraQueryExecution.this.executionContext.dataAvailable();
            }
        }, GuavaCompatibility.INSTANCE.sameThreadExecutor());
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (!this.resultSetFuture.isDone()) {
            throw DataNotAvailableException.NO_POLLING;
        }
        if (this.resultSet == null) {
            this.resultSet = this.resultSetFuture.getUninterruptibly();
        }
        return this.getRow(this.resultSet.one());
    }

    List<Object> getRow(Row row) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        ArrayList<Object> values = new ArrayList<Object>(columnDefinitions.size());
        block22: for (int i = 0; i < columnDefinitions.size(); ++i) {
            if (row.isNull(i)) {
                values.add(null);
                continue;
            }
            switch (columnDefinitions.getType(i).getName()) {
                case ASCII: {
                    values.add(row.getString(i));
                    continue block22;
                }
                case BIGINT: {
                    values.add(row.getLong(i));
                    continue block22;
                }
                case BOOLEAN: {
                    values.add(row.getBool(i));
                    continue block22;
                }
                case COUNTER: {
                    values.add(row.getLong(i));
                    continue block22;
                }
                case DECIMAL: {
                    values.add(row.getDecimal(i));
                    continue block22;
                }
                case DOUBLE: {
                    values.add(row.getDouble(i));
                    continue block22;
                }
                case FLOAT: {
                    values.add(Float.valueOf(row.getFloat(i)));
                    continue block22;
                }
                case INET: {
                    values.add(row.getInet(i));
                    continue block22;
                }
                case INT: {
                    values.add(row.getInt(i));
                    continue block22;
                }
                case LIST: {
                    values.add(row.getList(i, Object.class));
                    continue block22;
                }
                case MAP: {
                    values.add(row.getMap(i, Object.class, Object.class));
                    continue block22;
                }
                case SET: {
                    values.add(row.getSet(i, Object.class));
                    continue block22;
                }
                case TEXT: {
                    values.add(row.getString(i));
                    continue block22;
                }
                case TIME: {
                    long val = row.getTime(i);
                    Timestamp ts = new Timestamp(val / 1000000L);
                    ts.setNanos((int)(val % 1000000L));
                    values.add(ts);
                    continue block22;
                }
                case DATE: {
                    values.add(Date.valueOf(row.getDate(i).toString()));
                    continue block22;
                }
                case TIMESTAMP: {
                    values.add(row.getTimestamp(i));
                    continue block22;
                }
                case TIMEUUID: {
                    values.add(row.getUUID(i));
                    continue block22;
                }
                case UUID: {
                    values.add(row.getUUID(i));
                    continue block22;
                }
                case VARCHAR: {
                    values.add(row.getString(i));
                    continue block22;
                }
                case VARINT: {
                    values.add(row.getVarint(i));
                    continue block22;
                }
                default: {
                    ByteBuffer bytesUnsafe = row.getBytesUnsafe(i);
                    byte[] b = new byte[bytesUnsafe.remaining()];
                    bytesUnsafe.get(b);
                    values.add(b);
                }
            }
        }
        if (this.returnsArray) {
            return Arrays.asList(new Object[]{values.toArray()});
        }
        return values;
    }
}

