/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import com.datastax.driver.core.ResultSetFuture;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Command;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Parameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.cassandra.CassandraConnection;
import org.teiid.translator.cassandra.CassandraExecutionFactory;

public class TestUpdates {
    @Test
    public void testBatchedUpdate() throws TranslatorException {
        CassandraExecutionFactory cef = new CassandraExecutionFactory();
        String input = "insert into pm1.g1 (e1) values ('a')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        Command command1 = util.parseCommand("update pm1.g1 set e1 = 'b'");
        command = new BatchedUpdates(Arrays.asList(command, command1));
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        CassandraConnection connection = (CassandraConnection)Mockito.mock(CassandraConnection.class);
        ResultSetFuture rsf = (ResultSetFuture)Mockito.mock(ResultSetFuture.class);
        Mockito.stub((Object)rsf.isDone()).toReturn((Object)true);
        Mockito.stub((Object)connection.executeBatch(Arrays.asList("INSERT INTO g1 (e1) VALUES ('a')", "UPDATE g1 SET e1 = 'b'"))).toReturn((Object)rsf);
        UpdateExecution execution = (UpdateExecution)cef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])execution.getUpdateCounts());
        ((CassandraConnection)Mockito.verify((Object)connection)).executeBatch(Arrays.asList("INSERT INTO g1 (e1) VALUES ('a')", "UPDATE g1 SET e1 = 'b'"));
    }

    @Test
    public void testBulkUpdate() throws Exception {
        CassandraExecutionFactory cef = new CassandraExecutionFactory();
        String input = "insert into pm1.g1 (e1) values ('a')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        Insert insert = (Insert)command;
        Parameter p = new Parameter();
        p.setType(String.class);
        p.setValueIndex(0);
        ((ExpressionValueSource)insert.getValueSource()).getValues().set(0, p);
        insert.setParameterValues(Arrays.asList(Arrays.asList("a"), Arrays.asList("b")).iterator());
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        CassandraConnection connection = (CassandraConnection)Mockito.mock(CassandraConnection.class);
        ResultSetFuture rsf = (ResultSetFuture)Mockito.mock(ResultSetFuture.class);
        Mockito.stub((Object)rsf.isDone()).toReturn((Object)true);
        Mockito.stub((Object)connection.executeBatch((String)Mockito.eq((Object)"INSERT INTO g1 (e1) VALUES (?)"), (List)Mockito.anyObject())).toReturn((Object)rsf);
        UpdateExecution execution = (UpdateExecution)cef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])execution.getUpdateCounts());
    }
}

