/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.cassandra;

import java.util.Properties;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.cdk.CommandBuilder;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.cassandra.CassandraSQLVisitor;

public class TestTeiidLanguageToCQL {
    private QueryMetadataInterface cassandraMetadata(Properties modelProperties) {
        MetadataFactory factory = new MetadataFactory("", (Object)1, "", SystemMetadata.getInstance().getRuntimeTypeMap(), modelProperties, "");
        this.createFakeMetadata(factory);
        return new TransformationMetadata(null, new CompositeMetadataStore(factory.asMetadataStore()), null, RealMetadataFactory.SFM.getSystemFunctions(), null);
    }

    private void createFakeMetadata(MetadataFactory factory) {
        Table person = factory.addTable("Person");
        factory.addColumn("id", "integer", (ColumnSet)person);
        factory.addColumn("name", "string", (ColumnSet)person);
        Column c = factory.addColumn("age", "integer", (ColumnSet)person);
        c.setNameInSource("\"Age\"");
        factory.addColumn("bday", "date", (ColumnSet)person);
        factory.addColumn("bts", "timestamp", (ColumnSet)person);
        factory.addColumn("employed", "boolean", (ColumnSet)person);
        factory.addColumn("custom", "varbinary", (ColumnSet)person);
        factory.addColumn("custom1", "blob", (ColumnSet)person);
        Properties pros = factory.getModelProperties();
        for (Object key : pros.keySet()) {
            person.setProperty(key.toString(), pros.getProperty(key.toString()));
        }
    }

    private String getTranslation(String sql, Properties modelProperties) {
        CommandBuilder builder = new CommandBuilder(this.cassandraMetadata(modelProperties));
        Command c = builder.getCommand(sql);
        CassandraSQLVisitor visitor = new CassandraSQLVisitor();
        visitor.translateSQL((LanguageObject)c);
        return visitor.getTranslatedSQL();
    }

    @Test
    public void testSelect() throws Exception {
        Properties props = new Properties();
        Assert.assertEquals((Object)"SELECT id FROM Person", (Object)this.getTranslation("select id FROM Person", props));
        Assert.assertEquals((Object)"SELECT name, \"Age\" FROM Person", (Object)this.getTranslation("select name,age from Person", props));
        Assert.assertEquals((Object)"SELECT id, name, \"Age\", bday, bts, employed, custom, custom1 FROM Person", (Object)this.getTranslation("SELECT * FROM Person", props));
        Assert.assertEquals((Object)"SELECT COUNT(*) FROM Person LIMIT 10", (Object)this.getTranslation("SELECT count(*) FROM Person limit 10", props));
        Assert.assertEquals((Object)"SELECT id, name, \"Age\" FROM Person WHERE id = 1 AND \"Age\" >= 18 AND \"Age\" <= 100", (Object)this.getTranslation("SELECT id, name, age from Person where id=1 and age>=18 and age<=100", props));
        Assert.assertEquals((Object)"SELECT id, name, \"Age\" FROM Person WHERE id IN (1, 2, 3)", (Object)this.getTranslation("SELECT id, name, age from Person where id in(1,2,3)", props));
        Assert.assertEquals((Object)"SELECT id FROM Person WHERE bday = '1900-01-01' AND employed = TRUE", (Object)this.getTranslation("select id from Person where bday = {d '1900-01-01'} and employed = true", props));
        Assert.assertEquals((Object)"SELECT id FROM Person WHERE bts = -2208949200000 AND employed = TRUE", (Object)this.getTranslation("select id from Person where bts = {ts '1900-01-01 12:00:00'} and employed = true", props));
    }

    @Test
    public void testSelectWithAllowFiltering() throws Exception {
        Properties props = new Properties();
        props.put("ALLOWFILTERING", "TRUE");
        Assert.assertEquals((Object)"SELECT id, name, \"Age\", bday, employed, custom, custom FROM Person WHERE \"Age\" = 8 ALLOW FILTERING", (Object)this.getTranslation("select id, name, age, bday, employed, custom, custom from Person WHERE age = 8", props));
    }

    @BeforeClass
    public static void oneTimeSetup() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT+1"));
    }

    @AfterClass
    public static void oneTimeTeardown() {
        TimestampWithTimezone.resetCalendar(null);
    }
}

