/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonValue;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbaseMetadataProcessor;
import org.teiid.translator.couchbase.TestCouchbaseMetadataProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestVisitor {
    private static Path N1QL_PATH = Paths.get("src/test/resources", "N1QL.properties");
    static Properties N1QL = new Properties();
    static final Boolean PRINT_TO_CONSOLE = Boolean.FALSE;
    static final Boolean REPLACE_EXPECTED = Boolean.FALSE;
    static TranslationUtility translationUtility = new TranslationUtility((QueryMetadataInterface)TestVisitor.queryMetadataInterface());
    static RuntimeMetadata runtimeMetadata = new RuntimeMetadataImpl((QueryMetadataInterface)TestVisitor.queryMetadataInterface());
    static CouchbaseExecutionFactory TRANSLATOR;

    private static TransformationMetadata queryMetadataInterface() {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("couchbase");
            CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
            MetadataFactory mf = new MetadataFactory("couchbase", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), mmd);
            Table customer = TestCouchbaseMetadataProcessor.createTable(mf, "test", "Customer");
            mp.scanRow("test", "`test`", (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, customer, customer.getName(), false, new CouchbaseMetadataProcessor.Dimension());
            Table order = TestCouchbaseMetadataProcessor.createTable(mf, "test", "Oder");
            mp.scanRow("test", "`test`", (JsonValue)TestCouchbaseMetadataProcessor.formOder(), mf, order, order.getName(), false, new CouchbaseMetadataProcessor.Dimension());
            Table t2 = TestCouchbaseMetadataProcessor.createTable(mf, "T2", "T2");
            mp.scanRow("T2", "`T2`", (JsonValue)TestCouchbaseMetadataProcessor.formDataTypeJson(), mf, t2, t2.getName(), false, new CouchbaseMetadataProcessor.Dimension());
            Table t3 = TestCouchbaseMetadataProcessor.createTable(mf, "T3", "T3");
            mp.scanRow("T3", "`T3`", (JsonValue)TestCouchbaseMetadataProcessor.nestedJson(), mf, t3, t3.getName(), false, new CouchbaseMetadataProcessor.Dimension());
            mp.scanRow("T3", "`T3`", (JsonValue)TestCouchbaseMetadataProcessor.nestedArray(), mf, t3, t3.getName(), false, new CouchbaseMetadataProcessor.Dimension());
            mp.addProcedures(mf, null);
            TransformationMetadata tm = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[0]);
            ValidatorReport report = new MetadataValidator().validate(tm.getVdbMetaData(), (MetadataStore)tm.getMetadataStore());
            if (report.hasItems()) {
                throw new RuntimeException(report.getFailureMessage());
            }
            return tm;
        }
        catch (MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    @BeforeClass
    public static void init() throws TranslatorException {
        block3: {
            TRANSLATOR = new CouchbaseExecutionFactory();
            TRANSLATOR.start();
            translationUtility.addUDF("SYS", (Collection)TRANSLATOR.getPushDownFunctions());
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(Files.newInputStream(N1QL_PATH, new OpenOption[0]));
                doc.getDocumentElement().normalize();
                NodeList list = doc.getElementsByTagName("entry");
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    N1QL.put(element.getAttribute("key"), element.getTextContent());
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void replaceProperties() {
        if (REPLACE_EXPECTED.booleanValue()) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(N1QL_PATH.toFile());
                String encoding = "UTF-8";
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                Element properties = (Element)doc.appendChild(doc.createElement("properties"));
                for (Map.Entry<Object, Object> e : N1QL.entrySet()) {
                    String key = (String)e.getKey();
                    String value = (String)e.getValue();
                    if (!key.startsWith("N1QL")) continue;
                    Element entry = (Element)properties.appendChild(doc.createElement("entry"));
                    entry.setAttribute("key", key);
                    entry.appendChild(doc.createTextNode(value));
                }
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer t = tf.newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("method", "xml");
                t.setOutputProperty("encoding", encoding);
                DOMSource doms = new DOMSource(doc);
                StreamResult sr = new StreamResult(out);
                t.transform(doms, sr);
            }
            catch (IOException | ParserConfigurationException | TransformerException e) {
                assert (false);
            }
            finally {
                out = null;
            }
        }
    }
}

