/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.util.Assertion;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.couchbase.CouchbaseDirectQueryExecution;
import org.teiid.translator.couchbase.CouchbaseMetadataProcessor;
import org.teiid.translator.couchbase.CouchbasePlugin;
import org.teiid.translator.couchbase.CouchbaseProcedureExecution;
import org.teiid.translator.couchbase.CouchbaseQueryExecution;
import org.teiid.translator.couchbase.CouchbaseUpdateExecution;
import org.teiid.translator.couchbase.N1QLUpdateVisitor;
import org.teiid.translator.couchbase.N1QLVisitor;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;

@Translator(name="couchbase", description="Couchbase Translator, reads and writes the data to Couchbase")
public class CouchbaseExecutionFactory
extends ExecutionFactory<ConnectionFactory, CouchbaseConnection> {
    private static final String COUCHBASE = "couchbase";
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private int maxBulkInsertSize = 100;

    public CouchbaseExecutionFactory() {
        this.setSupportsSelectDistinct(true);
        this.setSourceRequiredForMetadata(false);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSourceRequiredForMetadata(true);
    }

    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("substring", (FunctionModifier)new AliasModifier("SUBSTR"));
        this.registerFunctionModifier("ceiling", (FunctionModifier)new AliasModifier("CEIL"));
        this.registerFunctionModifier("log", (FunctionModifier)new AliasModifier("LN"));
        this.registerFunctionModifier("log10", (FunctionModifier)new AliasModifier("LOG"));
        this.registerFunctionModifier("rand", (FunctionModifier)new AliasModifier("RANDOM"));
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("LOWER"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("UPPER"));
        this.registerFunctionModifier("convert", new FunctionModifier(){

            public List<?> translate(Function function) {
                Expression param = (Expression)function.getParameters().get(0);
                int targetCode = 1.getCode((Class)function.getType());
                if (targetCode == 3 || targetCode == 4 || targetCode == 5 || targetCode == 6 || targetCode == 8 || targetCode == 9 || targetCode == 7 || targetCode == 10) {
                    return Arrays.asList("TONUMBER(", param, ")");
                }
                if (targetCode == 0 || targetCode == 1) {
                    return Arrays.asList("TOSTRING(", param, ")");
                }
                if (targetCode == 2) {
                    return Arrays.asList("TOBOOLEAN(", param, ")");
                }
                return Arrays.asList("TOATOM(", param, ")");
            }
        });
        this.addPushDownFunction(COUCHBASE, "CONTAINS", "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "TITLE", "string", new String[]{"string"});
        this.addPushDownFunction(COUCHBASE, "LTRIM", "string", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "TRIM", "string", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "RTRIM", "string", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "POSITION", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "CLOCK_MILLIS", "double", new String[0]);
        this.addPushDownFunction(COUCHBASE, "CLOCK_STR", "string", new String[0]);
        this.addPushDownFunction(COUCHBASE, "CLOCK_STR", "string", new String[]{"string"});
        this.addPushDownFunction(COUCHBASE, "DATE_ADD_MILLIS", "long", new String[]{"long", "integer", "string"});
        this.addPushDownFunction(COUCHBASE, "DATE_ADD_STR", "string", new String[]{"string", "integer", "string"});
        this.addPushDownFunction(COUCHBASE, "DATE_DIFF_MILLIS", "long", new String[]{"long", "long", "string"});
        this.addPushDownFunction(COUCHBASE, "DATE_DIFF_STR", "long", new String[]{"string", "string", "string"});
        this.addPushDownFunction(COUCHBASE, "DATE_PART_MILLIS", "integer", new String[]{"long", "string"});
        this.addPushDownFunction(COUCHBASE, "DATE_PART_STR", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(COUCHBASE, "NOW_MILLIS", "double", new String[0]);
        this.addPushDownFunction(COUCHBASE, "NOW_STR", "string", new String[]{"string"});
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("cos");
        supportedFunctions.add("degrees");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("radians");
        supportedFunctions.add("rand");
        supportedFunctions.add("round");
        supportedFunctions.add("sign");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("tan");
        supportedFunctions.add("tan");
        supportedFunctions.add("initcap");
        supportedFunctions.add("length");
        supportedFunctions.add("lcase");
        supportedFunctions.add("repeat");
        supportedFunctions.add("translate");
        supportedFunctions.add("substring");
        supportedFunctions.add("ucase");
        supportedFunctions.add("replace");
        supportedFunctions.add("convert");
        return supportedFunctions;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) throws TranslatorException {
        return new CouchbaseQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) throws TranslatorException {
        return new CouchbaseProcedureExecution(this, command, executionContext, metadata, connection);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) throws TranslatorException {
        return new CouchbaseUpdateExecution(command, this, executionContext, metadata, connection);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, CouchbaseConnection connection) throws TranslatorException {
        return new CouchbaseDirectQueryExecution(arguments, command, this, executionContext, metadata, connection);
    }

    public MetadataProcessor<CouchbaseConnection> getMetadataProcessor() {
        return new CouchbaseMetadataProcessor();
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsAggregatesDistinct() {
        return true;
    }

    public boolean supportsArrayAgg() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsUnions() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public N1QLVisitor getN1QLVisitor() {
        return new N1QLVisitor(this);
    }

    public N1QLUpdateVisitor getN1QLUpdateVisitor() {
        return new N1QLUpdateVisitor(this);
    }

    public Object retrieveValue(Class<?> columnType, Object value) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(columnType)) {
            return value;
        }
        if (columnType.equals(ClobType.class)) {
            ClobImpl clob = new ClobImpl(value.toString());
            return new ClobType((Clob)clob);
        }
        return value;
    }

    public void setValue(JsonObject json, String attr, Class<?> type, Object attrValue) {
        if (type.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            json.put(attr, (String)attrValue);
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.INTEGER)) {
            json.put(attr, (Number)((Integer)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.LONG)) {
            json.put(attr, (Number)((Long)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.DOUBLE)) {
            json.put(attr, (Number)((Double)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            json.put(attr, (Object)((Boolean)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BIG_INTEGER)) {
            json.put(attr, (Number)((BigInteger)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            json.put(attr, (Number)((BigDecimal)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.NULL)) {
            json.putNull(attr);
        }
    }

    public void setValue(JsonArray array, Class<?> type, Object attrValue) {
        if (type.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            array.add((String)attrValue);
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.INTEGER)) {
            array.add((Number)((Integer)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.LONG)) {
            array.add((Number)((Long)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.DOUBLE)) {
            array.add((Number)((Double)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            array.add((Object)((Boolean)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BIG_INTEGER)) {
            array.add((Number)((BigInteger)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            array.add((Number)((BigDecimal)attrValue));
        } else if (type.equals(TypeFacility.RUNTIME_TYPES.NULL)) {
            array.addNull();
        }
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsUpsert() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    @TranslatorProperty(display="Max Bulk Insert Document Size", description="The max size of documents in a bulk insert. Default 100.", advanced=true)
    public int getMaxBulkInsertSize() {
        return this.maxBulkInsertSize;
    }

    public void setMaxBulkInsertSize(int maxBulkInsertSize) {
        Assertion.assertTrue((maxBulkInsertSize > 0 ? 1 : 0) != 0, (String)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29020, new Object[0]));
        this.maxBulkInsertSize = maxBulkInsertSize;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (toType == 0 || toType == 5 || toType == 6 || toType == 9 || toType == 2 || toType == 7 || toType == 10 || toType == 14) {
            return true;
        }
        return super.supportsConvert(fromType, toType);
    }
}

