/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlQueryRow;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.couchbase.CouchbasePlugin;

public class CouchbaseMetadataProcessor
implements MetadataProcessor<CouchbaseConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Boolean.class, display="Is Array Table", description="Declare whether the table is array table")
    public static final String IS_ARRAY_TABLE = "{http://www.teiid.org/translator/couchbase/2017}ISARRAYTABLE";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Named Type Pair", description="Declare the name of typed key/value pair")
    public static final String NAMED_TYPE_PAIR = "{http://www.teiid.org/translator/couchbase/2017}NAMEDTYPEPAIR";
    private Integer sampleSize;
    private String typeNameList;
    private String sampleKeyspaces = "*";
    private Map<String, List<String>> typeNameMap;

    public void process(MetadataFactory mf, CouchbaseConnection conn) throws TranslatorException {
        if (this.typeNameList == null) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29009, new Object[0]));
        }
        try {
            List<String> keyspaces = this.loadKeyspaces(conn);
            for (String keyspace : keyspaces) {
                this.addTable(mf, conn, conn.getNamespace(), keyspace);
            }
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
        this.addProcedures(mf, conn);
    }

    private List<String> loadKeyspaces(CouchbaseConnection conn) throws ResourceException {
        String namespace = conn.getNamespace();
        boolean isValidSchema = false;
        String n1qlNamespaces = this.buildN1QLNamespaces();
        Iterator namespaces = conn.execute(n1qlNamespaces).iterator();
        while (namespaces.hasNext()) {
            JsonObject row = ((N1qlQueryRow)namespaces.next()).value();
            if (!row.getString("name").equals(namespace)) continue;
            isValidSchema = true;
            break;
        }
        if (!isValidSchema) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29010, new Object[]{"default"}));
            namespace = "default";
        }
        HashSet<String> keyspaceSet = null;
        if (this.sampleKeyspaces.trim().length() > 0 && !this.sampleKeyspaces.equals("*")) {
            String[] array = this.sampleKeyspaces.split(",");
            keyspaceSet = new HashSet<String>(Arrays.asList(array));
        }
        ArrayList<String> results = new ArrayList<String>();
        String n1qlKeyspaces = this.buildN1QLKeyspaces(namespace);
        List keyspaces = conn.execute(n1qlKeyspaces).allRows();
        for (N1qlQueryRow row : keyspaces) {
            String keyspace = row.value().getString("name");
            if (keyspaceSet == null) {
                results.add(keyspace);
                continue;
            }
            if (!keyspaceSet.contains(keyspace) && !keyspaceSet.contains(CouchbaseMetadataProcessor.nameInSource(keyspace))) continue;
            results.add(keyspace);
        }
        Collections.sort(results);
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29011, new Object[]{n1qlKeyspaces, results}));
        return results;
    }

    private void addTable(MetadataFactory mf, CouchbaseConnection conn, String namespace, String keyspace) throws ResourceException {
        String nameInSource = CouchbaseMetadataProcessor.nameInSource(keyspace);
        HashMap<String, String> tableNameTypeMap = new HashMap<String, String>();
        List<String> typeNameList = this.getTypeName(nameInSource);
        ArrayList<String> dataSrcTableList = new ArrayList<String>();
        if (typeNameList != null && typeNameList.size() > 0) {
            String typeQuery = this.buildN1QLTypeQuery(typeNameList, namespace, keyspace);
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29003, new Object[]{typeQuery}));
            List rows = conn.execute(typeQuery).allRows();
            block0: for (N1qlQueryRow row : rows) {
                JsonObject rowJson = row.value();
                for (String typeName : typeNameList) {
                    String type = CouchbaseMetadataProcessor.trimWave(typeName);
                    String value = rowJson.getString(type);
                    if (value == null) continue;
                    dataSrcTableList.add(value);
                    tableNameTypeMap.put(value, typeName);
                    continue block0;
                }
            }
        } else {
            dataSrcTableList.add(keyspace);
        }
        Iterator iterator = dataSrcTableList.iterator();
        while (iterator.hasNext()) {
            String name;
            String tableName = name = (String)iterator.next();
            if (mf.getSchema().getTable(name) != null && !name.equals(keyspace)) {
                tableName = keyspace + "_" + name;
            }
            Table table = mf.addTable(tableName);
            table.setNameInSource(nameInSource);
            table.setSupportsUpdate(true);
            table.setProperty(IS_ARRAY_TABLE, "false");
            Column column = mf.addColumn("documentID", "string", (ColumnSet)table);
            column.setUpdatable(true);
            mf.addPrimaryKey("PK0", Arrays.asList("documentID"), table);
            if (!name.equals(keyspace)) {
                String namedTypePair = this.buildNamedTypePair((String)tableNameTypeMap.get(name), name);
                table.setProperty(NAMED_TYPE_PAIR, namedTypePair);
            }
            boolean hasTypeIdentifier = true;
            if (dataSrcTableList.size() == 1 && ((String)dataSrcTableList.get(0)).equals(keyspace)) {
                hasTypeIdentifier = false;
            }
            if (this.sampleSize == null || this.sampleSize == 0) {
                this.sampleSize = 100;
                LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29008, new Object[]{this.sampleSize}));
            }
            String query = this.buildN1QLQuery((String)tableNameTypeMap.get(name), name, namespace, keyspace, this.sampleSize, hasTypeIdentifier);
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29003, new Object[]{query}));
            Iterator result = conn.execute(query).iterator();
            while (result.hasNext()) {
                JsonObject row = ((N1qlQueryRow)result.next()).value();
                JsonObject currentRowJson = row.getObject(keyspace);
                this.scanRow(keyspace, CouchbaseMetadataProcessor.nameInSource(keyspace), (JsonValue)currentRowJson, mf, table, table.getName(), false, new Dimension());
            }
        }
    }

    protected void scanRow(String key, String keyInSource, JsonValue value, MetadataFactory mf, Table table, String referenceTableName, boolean isNestedType, Dimension dimension) {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29013, new Object[]{table, key, value}));
        if (this.isObjectJsonType(value)) {
            this.scanObjectRow(key, keyInSource, (JsonObject)value, mf, table, referenceTableName, isNestedType, dimension);
        } else if (this.isArrayJsonType(value)) {
            this.scanArrayRow(key, keyInSource, (JsonArray)value, mf, table, referenceTableName, isNestedType, dimension);
        }
    }

    private void scanObjectRow(String key, String keyInSource, JsonObject value, MetadataFactory mf, Table table, String referenceTableName, boolean isNestedType, Dimension dimension) {
        TreeSet names = new TreeSet(value.getNames());
        for (String name : names) {
            String columnName = name;
            Object columnValue = value.get(columnName);
            String columnType = this.getDataType(columnValue);
            if (columnType.equals("object")) {
                JsonValue jsonValue = (JsonValue)columnValue;
                String newKey = key + "_" + columnName;
                String newKeyInSource = keyInSource + "." + CouchbaseMetadataProcessor.nameInSource(columnName);
                if (this.isObjectJsonType(columnValue)) {
                    this.scanRow(newKey, newKeyInSource, jsonValue, mf, table, referenceTableName, true, dimension);
                    continue;
                }
                if (!this.isArrayJsonType(columnValue)) continue;
                String tableName = this.repleaceTypedName(table.getName(), newKey);
                String tableNameInSource = newKeyInSource + "[]";
                Dimension d = new Dimension();
                Table subTable = this.addTable(tableName, tableNameInSource, true, referenceTableName, d, mf);
                this.scanRow(newKey, newKeyInSource, jsonValue, mf, subTable, referenceTableName, true, d);
                continue;
            }
            if (isNestedType) {
                columnName = key + "_" + columnName;
            }
            String columnNameInSource = keyInSource + "." + CouchbaseMetadataProcessor.nameInSource(name);
            this.addColumn(columnName, columnType, columnValue, true, columnNameInSource, table, mf);
        }
    }

    private void scanArrayRow(String keyspace, String keyInSource, JsonArray array, MetadataFactory mf, Table table, String referenceTableName, boolean isNestedType, Dimension dimension) {
        if (array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                Object element = array.get(i);
                if (this.isObjectJsonType(element)) {
                    JsonObject json = (JsonObject)element;
                    for (String name : new TreeSet(json.getNames())) {
                        Object columnValue = json.get(name);
                        String columnType = this.getDataType(columnValue);
                        if (columnType.equals("object")) {
                            JsonValue jsonValue = (JsonValue)columnValue;
                            if (this.isObjectJsonType(jsonValue)) {
                                this.scanRow(keyspace, keyInSource, jsonValue, mf, table, referenceTableName, true, dimension);
                                continue;
                            }
                            if (!this.isArrayJsonType(jsonValue)) continue;
                            String tableName = table.getName() + "_" + name + "_" + dimension.get();
                            String tableNameInSrc = table.getNameInSource() + "." + CouchbaseMetadataProcessor.nameInSource(name) + "[]";
                            Dimension d = new Dimension();
                            Table subTable = this.addTable(tableName, tableNameInSrc, true, referenceTableName, d, mf);
                            this.scanRow(keyspace, keyInSource, jsonValue, mf, subTable, referenceTableName, true, d);
                            continue;
                        }
                        String columnName = table.getName() + "_" + name;
                        String columnNameInSource = table.getNameInSource() + "." + CouchbaseMetadataProcessor.nameInSource(name);
                        this.addColumn(columnName, columnType, columnValue, true, columnNameInSource, table, mf);
                    }
                    continue;
                }
                if (this.isArrayJsonType(element)) {
                    String tableName = table.getName() + "_" + dimension.get();
                    String tableNameInSrc = table.getNameInSource() + "[]";
                    Dimension d = dimension.copy();
                    Table subTable = this.addTable(tableName, tableNameInSrc, true, referenceTableName, d, mf);
                    this.scanRow(keyspace, keyInSource, (JsonValue)element, mf, subTable, referenceTableName, true, d);
                    continue;
                }
                String elementType = this.getDataType(element);
                String columnName = table.getName();
                String columnNameInSource = table.getNameInSource();
                this.addColumn(columnName, elementType, element, true, columnNameInSource, table, mf);
            }
        } else {
            String columnName = table.getName();
            this.addColumn(columnName, null, null, true, null, table, mf);
        }
    }

    private Table addTable(String tableName, String nameInSource, boolean updatable, String referenceTableName, Dimension dimension, MetadataFactory mf) {
        Table table = null;
        if (mf.getSchema().getTable(tableName) != null) {
            table = mf.getSchema().getTable(tableName);
        } else {
            table = mf.addTable(tableName);
            table.setNameInSource(nameInSource);
            table.setSupportsUpdate(updatable);
            table.setProperty(IS_ARRAY_TABLE, "true");
            Column column = mf.addColumn("documentID", "string", (ColumnSet)table);
            column.setUpdatable(true);
            mf.addForiegnKey("FK0", Arrays.asList("documentID"), referenceTableName, table);
            for (int i = 1; i <= dimension.dimension; ++i) {
                String idxName = this.buildArrayTableIdxName(nameInSource, i);
                idxName = this.repleaceTypedName(referenceTableName, idxName);
                Column idx = mf.addColumn(idxName, "integer", (ColumnSet)table);
                idx.setUpdatable(true);
            }
        }
        dimension.increment();
        return table;
    }

    private void addColumn(String name, String type, Object columnValue, boolean updatable, String nameInSource, Table table, MetadataFactory mf) {
        String columnName = name;
        String columnType = type;
        if (columnType == null && columnValue == null && table.getColumnByName(columnName) == null) {
            columnType = "string";
        } else if (columnType == null && columnValue == null && table.getColumnByName(columnName) != null) {
            columnType = table.getColumnByName(columnName).getDatatype().getName();
        }
        if ("null".equals(columnType)) {
            columnType = "string";
        }
        String tableNameInSource = CouchbaseMetadataProcessor.trimWave(table.getNameInSource());
        if (table.getProperty(IS_ARRAY_TABLE, false).equals("false") && columnName.startsWith(tableNameInSource)) {
            columnName = columnName.substring(tableNameInSource.length() + 1);
        }
        if (table.getColumnByName(columnName) == null) {
            Column column = mf.addColumn(columnName, columnType, (ColumnSet)table);
            column.setUpdatable(updatable);
            if (nameInSource != null) {
                column.setNameInSource(nameInSource);
            }
        } else {
            Column column = table.getColumnByName(columnName);
            String existColumnType = column.getDatatype().getName();
            if (!existColumnType.equals(columnType) && !existColumnType.equals("object") && columnValue != null) {
                Datatype datatype = (Datatype)mf.getDataTypes().get("object");
                column.setDatatype(datatype, true, 0);
            }
        }
    }

    private boolean isObjectJsonType(Object jsonValue) {
        return jsonValue instanceof JsonObject;
    }

    private boolean isArrayJsonType(Object jsonValue) {
        return jsonValue instanceof JsonArray;
    }

    private String repleaceTypedName(String name, String path) {
        String tableName = path.substring(path.indexOf("_"));
        return name + tableName;
    }

    private String buildArrayTableIdxName(String nameInSource, int dimension) {
        StringBuilder sb = new StringBuilder();
        String dim1Name = nameInSource.substring(0, nameInSource.indexOf("[]"));
        String[] names = dim1Name.split(Pattern.quote("."));
        boolean isFirst = true;
        for (String name : names) {
            if (isFirst) {
                isFirst = false;
                sb.append(CouchbaseMetadataProcessor.trimWave(name));
                continue;
            }
            sb.append("_");
            sb.append(CouchbaseMetadataProcessor.trimWave(name));
        }
        for (int i = 1; i <= dimension; ++i) {
            if (i == 1) continue;
            sb.append("_");
            sb.append("dim").append(i);
        }
        sb.append("_idx");
        return sb.toString();
    }

    private String buildNamedTypePair(String columnIdentifierName, String typedValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(columnIdentifierName).append(":").append("'").append(typedValue).append("'");
        return sb.toString();
    }

    private List<String> getTypeName(String keyspace) {
        if (this.typeNameList == null) {
            return null;
        }
        if (this.typeNameMap == null) {
            this.typeNameMap = new HashMap<String, List<String>>();
            try {
                Pattern typeNamePattern = Pattern.compile("([a-zA-Z_]\\w*|(?:`[^`]*`)+):([a-zA-Z_]\\w*|(?:`[^`]*`)+)(?:$|,)");
                Matcher typeGroupMatch = typeNamePattern.matcher(this.typeNameList);
                while (typeGroupMatch.find()) {
                    String key = typeGroupMatch.group(1);
                    String value = typeGroupMatch.group(2);
                    if (this.typeNameMap.get(key) == null) {
                        this.typeNameMap.put(key, new ArrayList(3));
                    }
                    this.typeNameMap.get(key).add(value);
                }
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29012, new Object[]{this.typeNameList}));
            }
        }
        return this.typeNameMap.get(keyspace);
    }

    protected void addProcedures(MetadataFactory metadataFactory, CouchbaseConnection connection) {
        Procedure getDocuments = metadataFactory.addProcedure("getDocuments");
        getDocuments.setAnnotation(CouchbasePlugin.Util.getString("getDocuments.Annotation"));
        ProcedureParameter param = metadataFactory.addProcedureParameter("id", "string", ProcedureParameter.Type.In, getDocuments);
        param.setNullType(BaseColumn.NullType.No_Nulls);
        param.setAnnotation(CouchbasePlugin.Util.getString("getDocuments.id.Annotation"));
        param = metadataFactory.addProcedureParameter("keyspace", "string", ProcedureParameter.Type.In, getDocuments);
        param.setNullType(BaseColumn.NullType.No_Nulls);
        param.setAnnotation(CouchbasePlugin.Util.getString("getDocuments.keyspace.Annotation"));
        metadataFactory.addProcedureResultSetColumn("result", "blob", getDocuments);
        Procedure getDocument = metadataFactory.addProcedure("getDocument");
        getDocument.setAnnotation(CouchbasePlugin.Util.getString("getDocument.Annotation"));
        param = metadataFactory.addProcedureParameter("id", "string", ProcedureParameter.Type.In, getDocument);
        param.setNullType(BaseColumn.NullType.No_Nulls);
        param.setAnnotation(CouchbasePlugin.Util.getString("getDocument.id.Annotation"));
        param = metadataFactory.addProcedureParameter("keyspace", "string", ProcedureParameter.Type.In, getDocument);
        param.setNullType(BaseColumn.NullType.No_Nulls);
        param.setAnnotation(CouchbasePlugin.Util.getString("getDocument.keyspace.Annotation"));
        metadataFactory.addProcedureResultSetColumn("result", "blob", getDocument);
    }

    private String getDataType(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Integer) {
            return "integer";
        }
        if (value instanceof Long) {
            return "long";
        }
        if (value instanceof Double) {
            return "double";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof BigInteger) {
            return "biginteger";
        }
        if (value instanceof BigDecimal) {
            return "bigdecimal";
        }
        return "object";
    }

    private String buildN1QLNamespaces() {
        return "SELECT name FROM system:namespaces";
    }

    private String buildN1QLKeyspaces(String namespace) {
        return "SELECT name, namespace_id FROM system:keyspaces WHERE namespace_id = '" + namespace + "'";
    }

    private String buildN1QLTypeQuery(List<String> typeNameList, String namespace, String keyspace) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT ");
        boolean comma = false;
        for (String typeName : typeNameList) {
            if (comma) {
                sb.append(",").append(" ");
            } else {
                comma = true;
            }
            sb.append(typeName);
        }
        sb.append(this.buildN1QLFrom(namespace, keyspace));
        return sb.toString();
    }

    private String buildN1QLQuery(String columnIdentifierName, String typedValue, String namespace, String keyspace, int sampleSize, boolean hasTypeIdentifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT meta(").append("`");
        sb.append(keyspace);
        sb.append("`").append(").id as PK, ");
        sb.append("`").append(keyspace).append("`");
        sb.append(this.buildN1QLFrom(namespace, keyspace));
        if (hasTypeIdentifier) {
            sb.append(" WHERE ").append(columnIdentifierName).append("='").append(typedValue).append("'");
        }
        sb.append(" LIMIT ").append(sampleSize);
        return sb.toString();
    }

    private String buildN1QLFrom(String namespace, String keyspace) {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM ");
        sb.append("`").append(namespace).append("`");
        sb.append(":");
        sb.append("`").append(keyspace).append("`");
        return sb.toString();
    }

    static String trimWave(String value) {
        String results = value;
        if (results.startsWith("`") && results.endsWith("`")) {
            results = results.substring(1, results.length() - 1);
        }
        return results;
    }

    static String nameInSource(String path) {
        if (path.startsWith("`") && path.endsWith("`")) {
            return path;
        }
        return "`" + path + "`";
    }

    @TranslatorProperty(display="SampleSize", category=TranslatorProperty.PropertyType.IMPORT, description="Maximum number of documents per keyspace that should be map")
    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    @TranslatorProperty(display="TypeNameList", category=TranslatorProperty.PropertyType.IMPORT, description="A comma-separated list of the attributes that the buckets use to specify document types. Each list item must be a bucket name surrounded by back quotes (`), a colon (:), and an attribute name surrounded by back quotes (`).")
    public String getTypeNameList() {
        return this.typeNameList;
    }

    public void setTypeNameList(String typeNameList) {
        this.typeNameList = typeNameList;
    }

    @TranslatorProperty(display="SampleKeyspaces", category=TranslatorProperty.PropertyType.IMPORT, description="A comma-separated list of the keyspace names to define which keyspaces that should be map, default map all keyspaces")
    public String getSampleKeyspaces() {
        return this.sampleKeyspaces;
    }

    public void setSampleKeyspaces(String sampleKeyspaces) {
        this.sampleKeyspaces = sampleKeyspaces;
    }

    public static class Dimension {
        int dimension = 1;

        public void increment() {
            ++this.dimension;
        }

        public Dimension copy() {
            Dimension result = new Dimension();
            result.dimension = this.dimension;
            return result;
        }

        public String get() {
            return "dim" + this.dimension;
        }
    }
}

