/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.query.N1qlQueryResult;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.couchbase.CouchbaseConnection;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.couchbase.CouchbaseExecution;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbasePlugin;
import org.teiid.translator.couchbase.N1QLUpdateVisitor;

public class CouchbaseUpdateExecution
extends CouchbaseExecution
implements UpdateExecution {
    private Command command;
    private N1QLUpdateVisitor visitor;
    private int[] returns = new int[]{0};

    protected CouchbaseUpdateExecution(Command command, CouchbaseExecutionFactory ef, ExecutionContext context, RuntimeMetadata metadata, CouchbaseConnection conn) {
        super(ef, context, metadata, conn);
        this.command = command;
    }

    public void execute() throws TranslatorException {
        this.visitor = this.executionFactory.getN1QLUpdateVisitor();
        this.visitor.append((LanguageObject)this.command);
        int count = 0;
        if (this.visitor.getBulkCommands() != null) {
            for (String n1ql : this.visitor.getBulkCommands()) {
                N1qlQueryResult results = this.executeDirect(n1ql);
                if (results == null) continue;
                count += results.info().mutationCount();
            }
        } else {
            N1qlQueryResult results = this.executeDirect(this.visitor.toString());
            if (results != null) {
                count = results.info().mutationCount();
            }
        }
        if (count > 0) {
            this.returns = new int[1];
            this.returns[0] = count;
        }
    }

    private N1qlQueryResult executeDirect(String n1ql) throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29004, new Object[]{n1ql}));
        this.executionContext.logCommand(new Object[]{n1ql});
        try {
            return this.connection.execute(n1ql);
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.returns;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

