/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.couchbase.CouchbaseMetadataProcessor;

public class TestCouchbaseMetadataProcessor {
    static final String KEYSPACE = "test";
    static final String KEYSPACE_SOURCE = "`test`";
    private static final boolean PRINT_TO_CONSOLE = false;
    private static final boolean REPLACE_EXPECTED = false;

    @Test
    public void testCustomerOrder() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formOder(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("customerOrder.expected", mf);
    }

    @Test
    public void testCustomerOrderMultiple() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formOder(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formOder(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("customerOrder.expected", mf);
    }

    @Test
    public void testCustomerOrderWithTypedName() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        mp.setTypeNameList("`test`:`type`,`beer-sample`:`type`,` travel-sample`:`type`");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table customer = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "Customer");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, customer, customer.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table order = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "Oder");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formOder(), mf, order, order.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("customerOrderTypedName.expected", mf);
    }

    @Test
    public void testCustomerWithDuplicatedTypedName() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        mp.setTypeNameList("`test`:`type`,`test2`:`type`");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        String typedName = "Customer";
        String keyspace1 = KEYSPACE;
        String keyspace2 = "test2";
        Table table1 = TestCouchbaseMetadataProcessor.createTable(mf, keyspace1, typedName);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, table1, table1.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table table2 = TestCouchbaseMetadataProcessor.createTable(mf, keyspace2, typedName);
        mp.scanRow("test2", "`test2`", (JsonValue)TestCouchbaseMetadataProcessor.formCustomer(), mf, table2, table2.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("customerDuplicatedTypedName.expected", mf);
    }

    @Test
    public void testMoreTypedNameInOneKeyspace() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        mp.setTypeNameList("`test`:`type`,`test`:`name`,`test`:`category`");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table ea = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "name", "ExampleA");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("name", "ExampleA"), mf, ea, ea.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table eb = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "name", "ExampleB");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("name", "ExampleB"), mf, eb, eb.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table sa = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "type", "SampleA");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("type", "SampleA"), mf, sa, sa.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table sb = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "type", "SampleB");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("type", "SampleB"), mf, sb, sb.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table qa = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "category", "QuickstartA");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("category", "QuickstartA"), mf, qa, qa.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        Table qb = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "type", "QuickstartB");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)JsonObject.create().put("type", "QuickstartB").put("name", "SampleC").put("category", "ExampleC"), mf, qb, qb.getName(), false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("moreTypedNameInOneKeyspace.expected", mf);
    }

    @Test
    public void testNullValue() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, TestCouchbaseMetadataProcessor.formNullValueJson(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("nullValue.expected", mf);
    }

    @Test
    public void testDataType() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.formDataTypeJson(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("dataTypeJson.expected", mf);
    }

    @Test
    public void testNestedJson() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.nestedJson(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("nestedJson.expected", mf);
    }

    @Test
    public void testNestedJsonWithTypedName() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, "Sample");
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.nestedJson(), mf, table, "Sample", false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("nestedJsonTypedName.expected", mf);
    }

    @Test
    public void testNestedArray() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.nestedArray(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("nestedArray.expected", mf);
    }

    @Test
    public void testComplexJson() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)TestCouchbaseMetadataProcessor.complexJson(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("complexJson.expected", mf);
    }

    @Test
    public void testJsonNestedArray() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, TestCouchbaseMetadataProcessor.complexJsonNestedArray(), mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("complexJsonNestedArray.expected", mf);
    }

    @Ignore(value="not resolved so far")
    @Test
    public void testMetadataCaseSensitive() throws ResourceException {
        CouchbaseMetadataProcessor mp = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        JsonObject json = JsonObject.create().put("name", "value").put("Name", "value").put("nAmE", "value");
        Table table = TestCouchbaseMetadataProcessor.createTable(mf, KEYSPACE, KEYSPACE);
        mp.scanRow(KEYSPACE, KEYSPACE_SOURCE, (JsonValue)json, mf, table, KEYSPACE, false, new CouchbaseMetadataProcessor.Dimension());
        this.helpTest("TODO.expected", mf);
    }

    @Test
    public void testProcedures() throws ResourceException {
        CouchbaseMetadataProcessor metadataProcessor = new CouchbaseMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "couchbase", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        metadataProcessor.addProcedures(mf, null);
        this.helpTest("procedures.expected", mf);
    }

    static Table createTable(MetadataFactory mf, String keyspace, String tableName) {
        return TestCouchbaseMetadataProcessor.createTable(mf, keyspace, "type", tableName);
    }

    static Table createTable(MetadataFactory mf, String keyspace, String typedKey, String tableName) {
        if (mf.getSchema().getTable(tableName) != null && !tableName.equals(keyspace)) {
            tableName = keyspace + "_" + tableName;
        }
        Table table = mf.addTable(tableName);
        table.setNameInSource("`" + keyspace + "`");
        table.setSupportsUpdate(true);
        table.setProperty("{http://www.teiid.org/translator/couchbase/2017}ISARRAYTABLE", "false");
        if (!tableName.equals(keyspace)) {
            table.setProperty("{http://www.teiid.org/translator/couchbase/2017}NAMEDTYPEPAIR", TestCouchbaseMetadataProcessor.buildNamedTypePair("`" + typedKey + "`", tableName));
        }
        mf.addColumn("documentID", "string", (ColumnSet)table);
        mf.addPrimaryKey("PK0", Arrays.asList("documentID"), table);
        return table;
    }

    private static String buildNamedTypePair(String columnIdentifierName, String typedValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(columnIdentifierName).append(":").append("'").append(typedValue).append("'");
        return sb.toString();
    }

    static JsonObject formCustomer() {
        return JsonObject.create().put("Name", "John Doe").put("ID", "Customer_101").put("type", "Customer").put("SavedAddresses", JsonArray.from((Object[])new Object[]{"123 Main St.", "456 1st Ave"}));
    }

    static JsonObject formOder() {
        return JsonObject.create().put("Name", "Air Ticket").put("type", "Oder").put("CustomerID", "Customer_101").put("CreditCard", JsonObject.create().put("Type", "Visa").put("CardNumber", "4111 1111 1111 111").put("Expiry", "12/12").put("CVN", 123)).put("Items", JsonArray.from((Object[])new Object[]{JsonObject.create().put("ItemID", 89123).put("Quantity", 1), JsonObject.create().put("ItemID", 92312).put("Quantity", 5)}));
    }

    static JsonValue formNullValueJson() {
        return JsonObject.create().put("Name", "null value test").putNull("attr_null").put("attr_obj", JsonObject.create().putNull("attr_null")).put("attr_array", JsonArray.create().addNull());
    }

    static JsonObject formDataTypeJson() {
        return JsonObject.create().put("Name", "data type test").put("attr_string", "This is String value").put("attr_integer", Integer.MAX_VALUE).put("attr_long", Long.MAX_VALUE).put("attr_double", Double.MAX_VALUE).put("attr_boolean", (Object)Boolean.TRUE).put("attr_bigInteger", (Number)new BigInteger("fffffffffffff", 16)).put("attr_bigDecimal", (Number)new BigDecimal("1115.37")).put("attr_jsonObject", JsonObject.create().put("key", "value")).put("attr_jsonArray", TestCouchbaseMetadataProcessor.formDataTypeArray()).putNull("attr_null");
    }

    static JsonArray formDataTypeArray() {
        return JsonArray.create().add("This is String value").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add((Object)Boolean.TRUE).add((Number)new BigInteger("fffffffffffff", 16)).add((Number)new BigDecimal("1115.37")).add(JsonObject.create().put("key", "value")).add(JsonArray.create().add("array")).addNull();
    }

    static JsonObject nestedJson() {
        return JsonObject.create().put("Name", "Nested Json").put("nestedJson", JsonObject.create().put("Dimension", 1).put("nestedJson", JsonObject.create().put("Dimension", 2).put("nestedJson", JsonObject.create().put("Dimension", 3).put("nestedJson", "value"))));
    }

    static JsonObject nestedArray() {
        return JsonObject.create().put("Name", "Nested Array").put("nestedArray", JsonArray.create().add("dimension 1").add(JsonArray.create().add("dimension 2").add(JsonArray.create().add("dimension 3").add(JsonArray.create().add("dimension 4")))));
    }

    static JsonObject complexJson() {
        return JsonObject.create().put("Name", "Complex Json").put("attr_jsonObject", JsonObject.create().put("Name", "Nested Json").put("attr_jsonArray", JsonArray.create().add("Nested array").add(JsonObject.create().put("Name", "Nested Json")))).put("attr_jsonArray", JsonArray.create().add("Nested array").add(JsonObject.create().put("Name", "Nested Json")).add(JsonObject.create().put("Name", "Nested Json").put("Dimension", 1)));
    }

    static JsonValue complexJsonNestedArray() {
        return JsonObject.create().put("Name", "Complex Json").put("attr_jsonObject", JsonObject.create().put("Name", "Nested Json").put("attr_jsonArray", JsonArray.create().add("Nested array").add(JsonObject.create().put("Name", "Nested Json"))));
    }

    private void helpTest(String name, MetadataFactory mf) throws ResourceException {
        try {
            String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
            Path path = Paths.get(UnitTestUtil.getTestDataPath(), name);
            String expected = new String(Files.readAllBytes(path));
            Assert.assertEquals((Object)expected, (Object)metadataDDL);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Test
    public void testTypeListParse() {
        HashMap<String, String> typeNameMap = new HashMap<String, String>();
        String typeNameList = "`product`:`type`,`store`:`type`,`customer`:`jsonType`,`sales`:`type`";
        Pattern typeNamePattern = Pattern.compile("([a-zA-Z_]\\w*|(?:`[^`]*`)+):([a-zA-Z_]\\w*|(?:`[^`]*`)+)(?:$|,)");
        Matcher typeGroupMatch = typeNamePattern.matcher(typeNameList);
        while (typeGroupMatch.find()) {
            typeNameMap.put(typeGroupMatch.group(1), typeGroupMatch.group(2));
        }
        Assert.assertTrue((boolean)typeNameMap.values().contains("`type`"));
        Assert.assertEquals((Object)"`type`", typeNameMap.get("`product`"));
    }

    @Test
    public void testTypeListParse_2() {
        HashMap typeNameMap = new HashMap();
        String typeNameList = "`test`:`type`,`test`:`name`,`test`:`category`,`default`:`type`";
        Pattern typeNamePattern = Pattern.compile("([a-zA-Z_]\\w*|(?:`[^`]*`)+):([a-zA-Z_]\\w*|(?:`[^`]*`)+)(?:$|,)");
        Matcher typeGroupMatch = typeNamePattern.matcher(typeNameList);
        while (typeGroupMatch.find()) {
            String key = typeGroupMatch.group(1);
            String value = typeGroupMatch.group(2);
            if (typeNameMap.get(key) == null) {
                typeNameMap.put(key, new ArrayList(3));
            }
            ((List)typeNameMap.get(key)).add(value);
        }
        Assert.assertEquals((long)((List)typeNameMap.get(KEYSPACE_SOURCE)).size(), (long)3L);
        Assert.assertEquals((long)((List)typeNameMap.get("`default`")).size(), (long)1L);
        Assert.assertTrue((boolean)typeNameMap.keySet().contains(KEYSPACE_SOURCE));
    }
}

