/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.StringUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.LanguageUtil;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Parameter;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbaseMetadataProcessor;
import org.teiid.translator.couchbase.CouchbasePlugin;
import org.teiid.translator.couchbase.N1QLVisitor;

public class N1QLUpdateVisitor
extends N1QLVisitor {
    private static final String ESCAPED_QUOTE = "\\u0027";
    private int dimension = 0;
    private String keyspace;
    private String setAttr;
    private String setAttrArray;
    private String[] bulkCommands = null;

    public N1QLUpdateVisitor(CouchbaseExecutionFactory ef) {
        super(ef);
    }

    public void visit(Insert obj) {
        String path;
        String attr;
        CBColumnData columnData;
        this.visit(obj.getTable());
        ArrayList<CBColumnData> rowCache = new ArrayList<CBColumnData>();
        Integer typeIndex = null;
        for (int i = 0; i < obj.getColumns().size(); ++i) {
            ColumnReference col = (ColumnReference)obj.getColumns().get(i);
            N1QLVisitor.CBColumn column = this.formCBColumn(col);
            CBColumnData cacheData = new CBColumnData(col.getType(), column);
            rowCache.add(cacheData);
            if (this.typedName == null || !this.typedName.equals(CouchbaseMetadataProcessor.nameInSource(cacheData.getCBColumn().getLeafName()))) continue;
            typeIndex = i;
        }
        HashMap<Integer, Parameter> preparedValues = new HashMap<Integer, Parameter>();
        ExpressionValueSource evs = (ExpressionValueSource)obj.getValueSource();
        for (int i = 0; i < evs.getValues().size(); ++i) {
            Expression exp = (Expression)evs.getValues().get(i);
            if (exp instanceof Literal) {
                Literal l = (Literal)exp;
                ((CBColumnData)rowCache.get(i)).setValue(l.getValue());
                if (typeIndex == null || typeIndex != i || this.typedValue.equals(this.getValueString(l.getType(), l.getValue()))) continue;
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, new Object[]{this.typedValue}));
            }
            if (exp instanceof Parameter) {
                Parameter p = (Parameter)exp;
                preparedValues.put(i, p);
                if (typeIndex == null || typeIndex != i) continue;
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, new Object[]{this.typedValue}));
            }
            throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29024, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29024, new Object[0]));
        }
        if (this.typedName != null && typeIndex == null) {
            boolean added = false;
            for (Column c : obj.getTable().getMetadataObject().getColumns()) {
                if (!CouchbaseMetadataProcessor.nameInSource(c.getSourceName()).endsWith(this.typedName)) continue;
                ColumnReference cr = new ColumnReference(obj.getTable(), c.getName(), c, c.getJavaType());
                N1QLVisitor.CBColumn column = this.formCBColumn(cr);
                CBColumnData cacheData = new CBColumnData(TypeFacility.RUNTIME_TYPES.STRING, column);
                cacheData.setValue(this.getRawValue(this.typedValue));
                rowCache.add(cacheData);
                added = true;
                break;
            }
            if (!added) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29023, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29023, new Object[]{this.typedName}));
            }
        }
        if (this.isArrayTable) {
            if (preparedValues.size() > 0) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29017, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29017, new Object[]{obj}));
            }
            this.buffer.append("UPDATE").append(" ").append(this.keyspace).append(" ");
            this.appendDocumentID((LanguageObject)obj, rowCache);
            String arrayIDX = this.buildNestedArrayIdx((LanguageObject)obj, rowCache);
            JsonArray array = JsonArray.create();
            for (int i = 0; i < rowCache.size(); ++i) {
                columnData = (CBColumnData)rowCache.get(i);
                if (columnData.getCBColumn().isPK() || columnData.getCBColumn().isIdx()) continue;
                if (columnData.getCBColumn().hasLeaf()) {
                    attr = columnData.getCBColumn().getLeafName();
                    path = columnData.getCBColumn().getNameInSource();
                    JsonObject nestedObj = this.findObject(array, path);
                    if (nestedObj == null) {
                        nestedObj = JsonObject.create();
                        array.add(nestedObj);
                    }
                    this.ef.setValue(nestedObj, attr, columnData.getColumnType(), columnData.getValue());
                    continue;
                }
                this.ef.setValue(array, columnData.getColumnType(), columnData.getValue());
            }
            StringBuilder left = new StringBuilder();
            left.append("IFMISSINGORNULL").append("(").append(arrayIDX).append(",").append(" ").append("[]").append(")");
            this.appendConcat(arrayIDX, left, array);
        } else {
            if (obj.isUpsert()) {
                this.buffer.append(this.getUpsertKeyword());
            } else {
                this.buffer.append(this.getInsertKeyword());
            }
            this.buffer.append(" ").append("INTO").append(" ").append(this.keyspace).append(" ");
            this.buffer.append("(").append("KEY").append(",").append(" ").append("VALUE").append(")");
            if (preparedValues.size() > 0) {
                this.appendBulkValues(preparedValues, rowCache, obj);
                return;
            }
            String documentID = null;
            JsonObject json = JsonObject.create();
            for (int i = 0; i < rowCache.size(); ++i) {
                columnData = (CBColumnData)rowCache.get(i);
                if (columnData.getCBColumn().isPK()) {
                    Object value = columnData.getValue();
                    if (value == null) continue;
                    documentID = value.toString();
                    continue;
                }
                attr = columnData.getCBColumn().getLeafName();
                path = columnData.getCBColumn().getNameInSource();
                JsonObject nestedObj = this.findObject(json, path);
                this.ef.setValue(nestedObj, attr, columnData.getColumnType(), columnData.getValue());
            }
            if (null == documentID) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, new Object[]{obj}));
            }
            this.buffer.append(" ").append("VALUES").append(" ").append("(").append("'").append(this.escapeString(documentID, "'")).append("'");
            this.buffer.append(",").append(" ").append(json).append(")");
        }
        this.appendRetuning();
    }

    private void appendBulkValues(Map<Integer, Parameter> preparedValues, List<CBColumnData> rowCache, Insert command) {
        Insert batchCommand = command;
        Iterator vi = batchCommand.getParameterValues();
        int maxBulkSize = this.ef.getMaxBulkInsertSize();
        int cursor = 0;
        ArrayList<String> n1qlList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        while (vi != null && vi.hasNext()) {
            if (cursor == 0) {
                sb.append((CharSequence)this.buffer);
            }
            ++cursor;
            List row = (List)vi.next();
            String documentID = null;
            JsonObject json = JsonObject.create();
            for (int i = 0; i < rowCache.size(); ++i) {
                CBColumnData columnData = rowCache.get(i);
                Parameter p = preparedValues.get(i);
                Object value = null;
                value = p != null ? row.get(p.getValueIndex()) : columnData.getValue();
                if (columnData.getCBColumn().isPK()) {
                    if (value == null) continue;
                    documentID = value.toString();
                    continue;
                }
                String attr = columnData.getCBColumn().getLeafName();
                String path = columnData.getCBColumn().getNameInSource();
                JsonObject nestedObj = this.findObject(json, path);
                this.ef.setValue(nestedObj, attr, columnData.getColumnType(), value);
            }
            if (null == documentID) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, new Object[]{command}));
            }
            if (comma) {
                sb.append(",");
            } else {
                comma = true;
            }
            sb.append(" ").append("VALUES").append(" ").append("(").append("'").append(this.escapeString(documentID, "'")).append("'");
            sb.append(",").append(" ").append(json).append(")");
            if (cursor != maxBulkSize) continue;
            sb.append(" ").append("RETURNING").append(" ").append(this.buildMeta(this.keyspace)).append(" ");
            sb.append("AS").append(" ").append("PK");
            n1qlList.add(sb.toString());
            cursor = 0;
            sb.delete(0, sb.length());
            comma = false;
        }
        if (cursor > 0 && cursor < maxBulkSize) {
            sb.append(" ").append("RETURNING").append(" ").append(this.buildMeta(this.keyspace)).append(" ");
            sb.append("AS").append(" ").append("PK");
            n1qlList.add(sb.toString());
        }
        this.bulkCommands = n1qlList.toArray(new String[n1qlList.size()]);
    }

    public String[] getBulkCommands() {
        return this.bulkCommands;
    }

    private void appendRetuning() {
        this.buffer.append(" ").append("RETURNING").append(" ").append(this.buildMeta(this.keyspace)).append(" ");
        this.buffer.append("AS").append(" ").append("PK");
    }

    private void appendConcat(String setKey, Object left, Object right) {
        this.buffer.append(" ").append("SET").append(" ").append(setKey).append(" ");
        this.buffer.append("=").append(" ").append("ARRAY_CONCAT").append("(");
        this.buffer.append(left);
        this.buffer.append(",").append(" ");
        this.buffer.append(right).append(")");
    }

    private void appendDocumentID(LanguageObject obj, List<CBColumnData> rowCache) {
        CBColumnData pk = null;
        for (CBColumnData columnData : rowCache) {
            if (!columnData.getCBColumn().isPK()) continue;
            pk = columnData;
            break;
        }
        if (pk == null) {
            throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29006, new Object[]{obj}));
        }
        this.buffer.append(this.getUsesKeyString(rowCache));
    }

    private String buildNestedArrayIdx(LanguageObject obj, List<CBColumnData> rowCache) {
        ArrayList<CBColumnData> idxList = new ArrayList<CBColumnData>(this.dimension);
        for (CBColumnData columnData : rowCache) {
            if (!columnData.getCBColumn().isIdx()) continue;
            idxList.add(columnData);
        }
        return this.buildNestedArrayIdx(this.setAttr, this.dimension, idxList, obj);
    }

    private String buildNestedArrayIdx(String setAttr, int dimension, List<CBColumnData> idxList, LanguageObject obj) {
        if (idxList.size() != dimension) {
            throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29005, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29005, new Object[]{obj}));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(setAttr);
        for (int i = 0; i < dimension - 1; ++i) {
            sb.append("[").append(idxList.get(i).getValue()).append("]");
        }
        return sb.toString();
    }

    @Override
    public void visit(NamedTable obj) {
        this.retrieveTableProperty(obj);
        String tableNameInSource = obj.getMetadataObject().getSourceName();
        if (this.isArrayTable) {
            this.keyspace = tableNameInSource.substring(0, tableNameInSource.indexOf("."));
            this.dimension = 0;
            String baseName = tableNameInSource;
            while (baseName.endsWith("[]")) {
                ++this.dimension;
                baseName = baseName.substring(0, baseName.length() - "[]".length());
            }
            this.setAttr = baseName.substring(this.keyspace.length() + 1);
        } else {
            this.keyspace = tableNameInSource;
        }
    }

    private JsonObject findObject(JsonObject json, String path) {
        String[] array = path.split(Pattern.quote("."));
        return this.findObject(json, array);
    }

    private JsonObject findObject(JsonArray json, String path) {
        JsonObject result = null;
        for (Object obj : json) {
            if (!(obj instanceof JsonObject)) continue;
            result = (JsonObject)obj;
            break;
        }
        String nestedObjPath = path.substring(path.lastIndexOf("[]") + "[]".length() + ".".length());
        String[] array = nestedObjPath.split(Pattern.quote("."));
        return this.findObject(result, array);
    }

    private JsonObject findObject(JsonObject json, String[] array) {
        if (json == null) {
            return null;
        }
        JsonObject result = json;
        for (int i = 1; i < array.length - 1; ++i) {
            String interPath = CouchbaseMetadataProcessor.trimWave(array[i]);
            if (result.get(interPath) == null) {
                result.put(interPath, JsonObject.create());
            }
            result = result.getObject(interPath);
        }
        return result;
    }

    @Override
    public void visit(ColumnReference obj) {
        if (obj.getTable() != null) {
            N1QLVisitor.CBColumn column = this.formCBColumn(obj);
            if (this.isArrayTable) {
                String arrayRef = this.buildNestedAttrRef(this.setAttrArray, column);
                if (column.isPK()) {
                    arrayRef = this.buildMeta(this.keyspace);
                }
                this.buffer.append(arrayRef);
            } else {
                String ref = column.getNameInSource();
                if (column.isPK()) {
                    ref = this.buildMeta(this.keyspace);
                }
                this.buffer.append(ref);
            }
        } else {
            super.visit(obj);
        }
    }

    public void visit(Delete obj) {
        this.visit(obj.getTable());
        Condition where = obj.getWhere();
        ArrayList<CBColumnData> rowCache = new ArrayList<CBColumnData>();
        List<Condition> conditions = this.findEqualityPredicates(where, rowCache);
        if (this.isArrayTable) {
            if (rowCache.size() < this.dimension + 1) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29019, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29019, new Object[]{obj}));
            }
            this.buffer.append("UPDATE").append(" ").append(this.keyspace).append(" ");
            this.appendDocumentID((LanguageObject)obj, rowCache);
            ArrayList<CBColumnData> idxList = new ArrayList<CBColumnData>(this.dimension);
            ArrayList<CBColumnData> equalityWhereList = new ArrayList<CBColumnData>(rowCache.size());
            for (CBColumnData columnData : rowCache) {
                if (columnData.getCBColumn().isIdx()) {
                    idxList.add(columnData);
                    continue;
                }
                if (columnData.getCBColumn().isPK()) continue;
                equalityWhereList.add(columnData);
            }
            String setKey = this.buildNestedArrayIdx(this.setAttr, this.dimension, idxList, (LanguageObject)obj);
            String left = "[]";
            String right = "[]";
            int idx = (Integer)((CBColumnData)idxList.get(idxList.size() - 1)).getValue();
            if (idx > 0) {
                left = setKey + "[" + 0 + ":" + idx + "]";
                right = setKey + "[" + (idx + 1) + ":" + "]";
            } else {
                right = setKey + "[" + 1 + ":" + "]";
            }
            this.appendConcat(setKey, left, right);
            this.setAttrArray = setKey + "[" + idx + "]";
            boolean hasPredicate = false;
            for (CBColumnData columnData : equalityWhereList) {
                if (!hasPredicate) {
                    this.buffer.append(" ").append("WHERE");
                    hasPredicate = true;
                } else {
                    this.buffer.append(" ").append("AND");
                }
                String whereRef = this.buildNestedAttrRef(this.setAttrArray, columnData.getCBColumn());
                this.buffer.append(" ").append(whereRef).append(" ").append("=").append(" ").append(this.getValueString(columnData.getColumnType(), columnData.getValue()));
            }
            for (Condition condition : conditions) {
                if (!hasPredicate) {
                    this.buffer.append(" ").append("WHERE").append(" ");
                    hasPredicate = true;
                } else {
                    this.buffer.append(" ").append("AND").append(" ");
                }
                this.append((LanguageObject)condition);
            }
            this.appendRetuning();
        } else {
            this.buffer.append("DELETE").append(" ").append("FROM").append(" ");
            this.buffer.append(this.keyspace);
            this.appendClauses(rowCache, conditions, null);
        }
    }

    private List<Condition> findEqualityPredicates(Condition where, List<CBColumnData> rowCache) {
        List conditions = LanguageUtil.separateCriteriaByAnd((Condition)where);
        Iterator iter = conditions.iterator();
        while (iter.hasNext()) {
            Comparison comp;
            Condition c = (Condition)iter.next();
            if (!(c instanceof Comparison) || (comp = (Comparison)c).getOperator() != Comparison.Operator.EQ || !(comp.getLeftExpression() instanceof ColumnReference)) continue;
            ColumnReference col = (ColumnReference)comp.getLeftExpression();
            N1QLVisitor.CBColumn column = this.formCBColumn(col);
            CBColumnData cacheData = new CBColumnData(col.getType(), column);
            cacheData.setValue(((Literal)comp.getRightExpression()).getValue());
            rowCache.add(cacheData);
            iter.remove();
        }
        return conditions;
    }

    private String getValueString(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LanguageObject) {
            this.visitNode((LanguageObject)value);
            return "";
        }
        if (type.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            return "'" + StringUtil.replace((String)value.toString(), (String)"'", (String)ESCAPED_QUOTE) + "'";
        }
        if (type.equals(TypeFacility.RUNTIME_TYPES.INTEGER) || type.equals(TypeFacility.RUNTIME_TYPES.LONG) || type.equals(TypeFacility.RUNTIME_TYPES.DOUBLE) || type.equals(TypeFacility.RUNTIME_TYPES.DOUBLE) || type.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN) || type.equals(TypeFacility.RUNTIME_TYPES.BIG_INTEGER) || type.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            return String.valueOf(value);
        }
        throw new AssertionError((Object)("Unknown literal type: " + type));
    }

    private String getRawValue(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return StringUtil.replace((String)value.substring(1, value.length() - 1), (String)ESCAPED_QUOTE, (String)"'");
        }
        return value;
    }

    public void visit(Update obj) {
        this.visit(obj.getTable());
        this.buffer.append("UPDATE").append(" ").append(this.keyspace);
        Condition where = obj.getWhere();
        ArrayList<CBColumnData> whereRowCache = new ArrayList<CBColumnData>();
        List<Condition> conditions = this.findEqualityPredicates(where, whereRowCache);
        if (this.isArrayTable) {
            if (whereRowCache.size() < this.dimension + 1) {
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29019, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29019, new Object[]{obj}));
            }
            ArrayList<CBColumnData> rowCache = new ArrayList<CBColumnData>();
            for (SetClause clause : obj.getChanges()) {
                ColumnReference col = clause.getSymbol();
                if (this.isPKColumn(col)) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29025, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29025, new Object[]{this.typedValue}));
                }
                N1QLVisitor.CBColumn column = this.formCBColumn(col);
                CBColumnData cBColumnData = new CBColumnData(col.getType(), column);
                Object value = clause.getValue();
                if (value instanceof Literal) {
                    value = ((Literal)value).getValue();
                }
                if (this.typedName != null && this.typedName.equals(CouchbaseMetadataProcessor.nameInSource(cBColumnData.getCBColumn().getLeafName()))) {
                    if (this.typedValue.equals(this.getValueString(cBColumnData.getColumnType(), value))) continue;
                    throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, new Object[]{this.typedValue}));
                }
                cBColumnData.setValue(value);
                rowCache.add(cBColumnData);
            }
            ArrayList setList = new ArrayList(rowCache.size());
            for (int i = 0; i < rowCache.size(); ++i) {
                if (((CBColumnData)rowCache.get(i)).getCBColumn().isPK() || ((CBColumnData)rowCache.get(i)).getCBColumn().isIdx()) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29018, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29018, new Object[]{obj}));
                }
                setList.add(rowCache.get(i));
            }
            this.buffer.append(" ");
            this.appendDocumentID((LanguageObject)obj, whereRowCache);
            this.buffer.append(" ");
            ArrayList<CBColumnData> idxList = new ArrayList<CBColumnData>(this.dimension);
            ArrayList<CBColumnData> equalityWhereList = new ArrayList<CBColumnData>(whereRowCache.size());
            for (CBColumnData cBColumnData : whereRowCache) {
                if (cBColumnData.getCBColumn().isIdx()) {
                    idxList.add(cBColumnData);
                    continue;
                }
                if (cBColumnData.getCBColumn().isPK()) continue;
                equalityWhereList.add(cBColumnData);
            }
            this.setAttrArray = this.buildNestedArrayIdx(this.setAttr, this.dimension, idxList, (LanguageObject)obj) + "[" + ((CBColumnData)idxList.get(idxList.size() - 1)).getValue() + "]";
            this.buffer.append("SET");
            boolean comma = false;
            for (CBColumnData columnData : setList) {
                if (comma) {
                    this.buffer.append(",").append(" ");
                } else {
                    this.buffer.append(" ");
                    comma = true;
                }
                String setRef = this.buildNestedAttrRef(this.setAttrArray, columnData.getCBColumn());
                this.buffer.append(setRef).append(" ").append("=").append(" ").append(this.getValueString(columnData.getColumnType(), columnData.getValue()));
            }
            boolean bl = false;
            for (CBColumnData columnData : equalityWhereList) {
                boolean bl2;
                if (!bl2) {
                    this.buffer.append(" ").append("WHERE");
                    bl2 = true;
                } else {
                    this.buffer.append(" ").append("AND");
                }
                String whereRef = this.buildNestedAttrRef(this.setAttrArray, columnData.getCBColumn());
                this.buffer.append(" ").append(whereRef).append(" ").append("=").append(" ").append(this.getValueString(columnData.getColumnType(), columnData.getValue()));
            }
            for (Condition condition : conditions) {
                boolean bl3;
                if (!bl3) {
                    this.buffer.append(" ").append("WHERE").append(" ");
                    bl3 = true;
                } else {
                    this.buffer.append(" ").append("AND").append(" ");
                }
                this.append((LanguageObject)condition);
            }
        } else {
            this.appendClauses(whereRowCache, conditions, obj.getChanges());
        }
        this.appendRetuning();
    }

    private String buildNestedAttrRef(String prefix, N1QLVisitor.CBColumn column) {
        if (column.hasLeaf()) {
            String sourceName = column.getNameInSource();
            return prefix + sourceName.substring(sourceName.lastIndexOf("[]") + "[]".length());
        }
        return prefix;
    }

    private String getUsesKeyString(List<CBColumnData> rowCache) {
        CBColumnData pk = null;
        for (int i = 0; i < rowCache.size(); ++i) {
            if (!rowCache.get(i).getCBColumn().isPK()) continue;
            pk = rowCache.get(i);
            break;
        }
        if (pk != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("USE").append(" ").append("KEYS").append(" ");
            sb.append(this.getValueString(pk.getColumnType(), pk.getValue()));
            return sb.toString();
        }
        return null;
    }

    private void appendClauses(List<CBColumnData> rowCache, List<Condition> otherConditions, List<SetClause> setClauses) {
        boolean hasTypedValue;
        String useKey = this.getUsesKeyString(rowCache);
        boolean isTyped = false;
        if (useKey != null) {
            this.buffer.append(" ").append(useKey);
        }
        if (setClauses != null) {
            this.buffer.append(" ").append("SET").append(" ");
            for (SetClause clause : setClauses) {
                ColumnReference col = clause.getSymbol();
                if (this.isPKColumn(col)) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29025, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29025, new Object[]{this.typedValue}));
                }
                N1QLVisitor.CBColumn column = this.formCBColumn(col);
                CBColumnData cacheData = new CBColumnData(col.getType(), column);
                Object value = clause.getValue();
                if (clause.getValue() instanceof Literal) {
                    value = ((Literal)clause.getValue()).getValue();
                }
                if (this.typedName == null || !this.typedName.equals(CouchbaseMetadataProcessor.nameInSource(cacheData.getCBColumn().getLeafName())) || value != null && this.typedValue.equals(this.getValueString(cacheData.getColumnType(), value))) continue;
                throw new TeiidRuntimeException((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, CouchbasePlugin.Util.gs((BundleUtil.Event)CouchbasePlugin.Event.TEIID29022, new Object[]{this.typedValue}));
            }
            this.append(setClauses);
        }
        boolean hasPredicate = false;
        for (CBColumnData columnData : rowCache) {
            if (this.typedName != null && this.typedName.equals(CouchbaseMetadataProcessor.nameInSource(columnData.getCBColumn().getLeafName())) && this.typedValue.equals(this.getValueString(columnData.getColumnType(), columnData.getValue()))) {
                isTyped = true;
            }
            if (columnData.getCBColumn().isPK()) continue;
            if (!hasPredicate) {
                this.buffer.append(" ").append("WHERE");
                hasPredicate = true;
            } else {
                this.buffer.append(" ").append("AND");
            }
            this.buffer.append(" ").append(columnData.getCBColumn().getNameInSource()).append(" ");
            this.buffer.append("=").append(" ");
            this.buffer.append(this.getValueString(columnData.getColumnType(), columnData.getValue()));
        }
        boolean bl = hasTypedValue = !isTyped && this.typedName != null && this.typedValue != null;
        if (!otherConditions.isEmpty()) {
            if (!hasPredicate) {
                this.buffer.append(" ").append("WHERE");
                hasPredicate = true;
            } else {
                this.buffer.append(" ").append("AND");
            }
            this.buffer.append(" ");
            if (hasTypedValue) {
                this.buffer.append("(");
                this.append((LanguageObject)LanguageUtil.combineCriteria(otherConditions));
                this.buffer.append(")");
            } else {
                this.append((LanguageObject)LanguageUtil.combineCriteria(otherConditions));
            }
        }
        if (hasTypedValue) {
            if (hasPredicate) {
                this.buffer.append(" ").append("AND");
            } else {
                this.buffer.append(" ").append("WHERE");
            }
            this.buffer.append(" ").append(this.keyspace).append(".").append(this.typedName).append(" ").append("=").append(" ").append(this.typedValue);
        }
    }

    private static class CBColumnData {
        private Class<?> columnType;
        private N1QLVisitor.CBColumn column;
        private Object value;

        private CBColumnData(Class<?> columnType, N1QLVisitor.CBColumn column) {
            this.columnType = columnType;
            this.column = column;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Class<?> getColumnType() {
            return this.columnType;
        }

        public N1QLVisitor.CBColumn getCBColumn() {
            return this.column;
        }
    }
}

