/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;

public class TestCouchbase {
    @Test
    public void testConvert() throws TranslatorException {
        CouchbaseExecutionFactory cef = new CouchbaseExecutionFactory();
        cef.start();
        Assert.assertFalse((boolean)cef.supportsConvert(0, 11));
        Assert.assertTrue((boolean)cef.supportsConvert(0, 9));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetValue() {
        CouchbaseExecutionFactory cef = new CouchbaseExecutionFactory();
        JsonArray array = JsonArray.create();
        cef.setValue(array, Float.class, (Object)Float.valueOf(1.0f));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)array.get(0));
    }

    @Test
    public void testRetrieve() throws TranslatorException {
        CouchbaseExecutionFactory cef = new CouchbaseExecutionFactory();
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)cef.retrieveValue(BigInteger.class, (Object)new BigDecimal(1)));
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)cef.retrieveValue(BigInteger.class, (Object)1));
        Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)cef.retrieveValue(BigDecimal.class, (Object)BigInteger.valueOf(2L)));
    }

    @Test
    public void testUseDouble() throws TranslatorException {
        CouchbaseExecutionFactory cef = new CouchbaseExecutionFactory();
        cef.setUseDouble(false);
        cef.start();
        Assert.assertTrue((boolean)cef.supportsConvert(0, 6));
        cef.setUseDouble(true);
        Assert.assertFalse((boolean)cef.supportsConvert(0, 6));
    }
}

