/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.couchbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.StringUtil;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.NamedTable;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SetQuery;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.couchbase.CouchbaseExecutionFactory;
import org.teiid.translator.couchbase.CouchbaseMetadataProcessor;

public class N1QLVisitor
extends SQLStringVisitor {
    protected CouchbaseExecutionFactory ef;
    private List<String> selectColumns = new ArrayList<String>();
    private Map<String, CBColumn> columnMap = new HashMap<String, CBColumn>();
    private AliasGenerator columnAliasGenerator;
    private AliasGenerator tableAliasGenerator;
    protected boolean isArrayTable = false;
    private List<CBColumn> letStack = new ArrayList<CBColumn>();
    protected String typedName = null;
    protected String typedValue = null;
    private String topTableAlias;
    private int placeHolderIndex = 1;

    public N1QLVisitor(CouchbaseExecutionFactory ef) {
        this.ef = ef;
    }

    protected void appendSetQuery(SetQuery parent, QueryExpression obj, boolean right) {
        if (right) {
            N1QLVisitor rightVisitor = new N1QLVisitor(this.ef);
            rightVisitor.append((LanguageObject)obj);
            if (this.shouldNestSetChild(parent, obj, right)) {
                this.buffer.append("(");
                this.buffer.append(rightVisitor.toString());
                this.buffer.append(")");
            } else {
                this.buffer.append(rightVisitor.toString());
            }
            return;
        }
        super.appendSetQuery(parent, obj, right);
    }

    private void appendQueryExpressionEnd(QueryExpression obj) {
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getLimit());
        }
    }

    public void visit(Select obj) {
        Collection elements = CollectorVisitor.collectElements((LanguageObject)obj);
        this.defineColumns(elements);
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            this.buffer.append(" ").append("FROM").append(" ");
            this.append(obj.getFrom());
        }
        String from = this.buffer.toString();
        this.buffer.setLength(0);
        this.buffer.append("SELECT").append(" ");
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getDerivedColumns());
        this.buffer.append(from);
        this.appendLet();
        this.appendWhere(obj);
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append((LanguageObject)obj.getHaving());
        }
        this.appendQueryExpressionEnd((QueryExpression)obj);
    }

    private boolean appendLet() {
        boolean comma = false;
        for (int i = 0; i < this.letStack.size(); ++i) {
            CBColumn cbColumn = this.letStack.get(i);
            if (!cbColumn.isIdx()) continue;
            if (comma) {
                this.buffer.append(",").append(" ");
            } else {
                this.buffer.append(" ").append("LET").append(" ");
                comma = true;
            }
            this.buffer.append(CouchbaseMetadataProcessor.nameInSource(cbColumn.getNameReference()));
            this.buffer.append(" ").append("=").append(" ");
            this.buffer.append(cbColumn.getValueReference());
        }
        return comma;
    }

    private void defineColumns(Collection<ColumnReference> elements) {
        for (ColumnReference obj : elements) {
            if (this.columnMap.get(obj.getName()) != null || obj.getTable() == null) continue;
            CBColumn column = this.formCBColumn(obj);
            this.letStack.add(column);
            this.columnMap.put(obj.getName(), column);
        }
    }

    public void visit(AndOr obj) {
        this.appendNestedCondition(obj, obj.getLeftCondition());
        this.buffer.append(" ").append(obj.getOperator().toString()).append(" ");
        this.appendNestedCondition(obj, obj.getRightCondition());
    }

    private void appendWhere(Select obj) {
        if (this.typedName != null && this.typedValue != null) {
            String typedWhere = null;
            for (CBColumn column : this.letStack) {
                if (!column.getLeafName().equals(CouchbaseMetadataProcessor.trimWave(this.typedName))) continue;
                typedWhere = this.buildTypedWhere(CouchbaseMetadataProcessor.nameInSource(column.isIdx() ? column.getNameReference() : column.getValueReference()), this.typedValue);
                break;
            }
            if (typedWhere == null) {
                String keyspace = CouchbaseMetadataProcessor.nameInSource(this.topTableAlias);
                if (this.letStack.size() > 0) {
                    keyspace = CouchbaseMetadataProcessor.nameInSource(this.letStack.get(this.letStack.size() - 1).getTableAlias());
                }
                typedWhere = keyspace + "." + this.buildTypedWhere(this.typedName, this.typedValue);
            }
            this.buffer.append(" ").append("WHERE").append(" ");
            if (obj.getWhere() != null) {
                this.append((LanguageObject)obj.getWhere());
                this.buffer.append(" ").append("AND").append(" ");
            }
            this.buffer.append(typedWhere);
        } else if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
        }
    }

    public void visit(NamedTable obj) {
        String alias;
        this.retrieveTableProperty(obj);
        String tableNameInSource = obj.getMetadataObject().getSourceName();
        this.topTableAlias = alias = this.getTableAliasGenerator().generate();
        if (this.isArrayTable) {
            String baseName = tableNameInSource;
            for (int i = this.letStack.size(); i > 0; --i) {
                CBColumn column = this.letStack.get(i - 1);
                StringBuilder letValueReference = new StringBuilder();
                if (column.isPK()) {
                    letValueReference.append(this.buildMeta(alias));
                    column.setValueReference(letValueReference.toString());
                    column.setTableAlias(alias);
                    continue;
                }
                if (column.isIdx()) {
                    letValueReference.append("UNNEST_POSITION");
                    letValueReference.append("(").append(CouchbaseMetadataProcessor.nameInSource(alias)).append(")");
                    column.setValueReference(letValueReference.toString());
                    String newAlias = this.tableAliasGenerator.generate();
                    baseName = baseName.substring(0, baseName.length() - "[]".length());
                    StringBuilder unnestBuilder = new StringBuilder();
                    unnestBuilder.append("UNNEST").append(" ");
                    unnestBuilder.append(CouchbaseMetadataProcessor.nameInSource(newAlias));
                    if (!baseName.endsWith("[]")) {
                        String dimArrayAttrName = baseName.substring(baseName.lastIndexOf(".") + 1, baseName.length());
                        unnestBuilder.append(".").append(dimArrayAttrName);
                    }
                    unnestBuilder.append(" ").append(CouchbaseMetadataProcessor.nameInSource(alias));
                    column.setUnnest(unnestBuilder.toString());
                    alias = newAlias;
                    continue;
                }
                letValueReference.append(CouchbaseMetadataProcessor.nameInSource(alias));
                if (column.hasLeaf()) {
                    letValueReference.append(".").append(CouchbaseMetadataProcessor.nameInSource(column.getLeafName()));
                }
                column.setValueReference(letValueReference.toString());
                column.setTableAlias(alias);
            }
            String keyspace = baseName.substring(0, baseName.indexOf("."));
            this.buffer.append(keyspace);
            this.buffer.append(" ");
            this.buffer.append(CouchbaseMetadataProcessor.nameInSource(alias));
            for (int i = 0; i < this.letStack.size(); ++i) {
                CBColumn column = this.letStack.get(i);
                if (!column.hasUnnest()) continue;
                this.buffer.append(" ");
                this.buffer.append(column.getUnnest());
            }
        } else {
            for (int i = this.letStack.size(); i > 0; --i) {
                CBColumn column = this.letStack.get(i - 1);
                StringBuilder letValueReference = new StringBuilder();
                if (column.isPK()) {
                    this.buildMeta(alias);
                    letValueReference.append(this.buildMeta(alias));
                    column.setValueReference(letValueReference.toString());
                    column.setTableAlias(alias);
                    continue;
                }
                letValueReference.append(CouchbaseMetadataProcessor.nameInSource(alias));
                String nameInSource = column.getNameInSource();
                if (nameInSource != null) {
                    nameInSource = nameInSource.substring(nameInSource.indexOf(".") + 1, nameInSource.length());
                    letValueReference.append(".").append(nameInSource);
                }
                column.setValueReference(letValueReference.toString());
                column.setTableAlias(alias);
            }
            this.buffer.append(tableNameInSource);
            this.buffer.append(" ");
            this.buffer.append(CouchbaseMetadataProcessor.nameInSource(alias));
        }
    }

    private String buildTypedWhere(String typedName, String typedValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(typedName).append(" ").append("=").append(" ");
        sb.append(typedValue);
        return sb.toString();
    }

    protected String buildMeta(String alias) {
        StringBuilder sb = new StringBuilder();
        sb.append("META").append("(").append(CouchbaseMetadataProcessor.nameInSource(alias)).append(")").append(".id");
        return sb.toString();
    }

    public void visit(DerivedColumn obj) {
        String name = obj.getAlias();
        if (name == null) {
            name = "c" + this.placeHolderIndex++;
        }
        this.append((LanguageObject)obj.getExpression());
        this.buffer.append(" ").append(name);
        this.selectColumns.add(name);
    }

    public void visit(ColumnReference obj) {
        if (obj.getTable() != null) {
            CBColumn column = this.columnMap.get(obj.getName());
            String aliasName = column.isIdx() ? column.getNameReference() : column.getValueReference();
            this.buffer.append(CouchbaseMetadataProcessor.nameInSource(aliasName));
        } else {
            this.buffer.append(obj.getName());
        }
    }

    protected CBColumn formCBColumn(ColumnReference obj) {
        boolean isPK = false;
        boolean isIdx = false;
        String leafName = "";
        if (this.isPKColumn(obj)) {
            isPK = true;
        } else if (this.isIDXColumn(obj)) {
            isIdx = true;
        } else if (obj.getMetadataObject().getNameInSource() != null && !obj.getMetadataObject().getNameInSource().endsWith("[]")) {
            String nameInSource = obj.getMetadataObject().getSourceName();
            leafName = nameInSource.substring(nameInSource.lastIndexOf(".") + 1, nameInSource.length());
            leafName = CouchbaseMetadataProcessor.trimWave(leafName);
        }
        String colExpr = this.getColumnAliasGenerator().generate() + "_" + obj.getName();
        return new CBColumn(isPK, isIdx, colExpr, leafName, obj.getMetadataObject().getSourceName());
    }

    protected void retrieveTableProperty(NamedTable table) {
        String typedNamePair;
        if (!this.isArrayTable && table.getMetadataObject().getProperty("teiid_couchbase:ISARRAYTABLE", false) != null && table.getMetadataObject().getProperty("teiid_couchbase:ISARRAYTABLE", false).equals("true")) {
            this.isArrayTable = true;
        }
        if (this.typedName == null && this.typedValue == null && (typedNamePair = table.getMetadataObject().getProperty("teiid_couchbase:NAMEDTYPEPAIR", false)) != null && typedNamePair.length() > 0) {
            String[] pair = typedNamePair.split(":");
            this.typedName = pair[0];
            this.typedValue = pair[1];
        }
    }

    private boolean isIDXColumn(ColumnReference obj) {
        return obj.getMetadataObject().getNameInSource() == null && StringUtil.endsWithIgnoreCase((String)obj.getName(), (String)"_idx");
    }

    protected boolean isPKColumn(ColumnReference obj) {
        return obj.getMetadataObject().getNameInSource() == null && obj.getName().equalsIgnoreCase("documentID");
    }

    public void visit(Function obj) {
        List parts;
        String functionName = obj.getName();
        if (functionName.equalsIgnoreCase("TRIM")) {
            this.buffer.append(obj.getName()).append("(");
            this.append(obj.getParameters());
            this.buffer.append(")");
            return;
        }
        if (this.ef.getFunctionModifiers().containsKey(functionName) && (parts = this.ef.getFunctionModifiers().get(functionName).translate(obj)) != null) {
            for (Object part : parts) {
                if (part instanceof LanguageObject) {
                    this.append((LanguageObject)part);
                    continue;
                }
                this.buffer.append(part);
            }
            return;
        }
        super.visit(obj);
    }

    public void visit(Limit limit) {
        if (limit.getRowOffset() > 0) {
            this.buffer.append("LIMIT").append(" ");
            this.buffer.append(limit.getRowLimit()).append(" ");
            this.buffer.append("OFFSET").append(" ");
            this.buffer.append(limit.getRowOffset());
        } else {
            super.visit(limit);
        }
    }

    public List<String> getSelectColumns() {
        return this.selectColumns;
    }

    protected AliasGenerator getColumnAliasGenerator() {
        if (this.columnAliasGenerator == null) {
            this.columnAliasGenerator = new AliasGenerator("$cb_c");
        }
        return this.columnAliasGenerator;
    }

    protected AliasGenerator getTableAliasGenerator() {
        if (this.tableAliasGenerator == null) {
            this.tableAliasGenerator = new AliasGenerator("$cb_t");
        }
        return this.tableAliasGenerator;
    }

    public void visit(Call call) {
        String procName = call.getProcedureName();
        String keyspace = null;
        if (procName.equalsIgnoreCase("getDocuments") || procName.equalsIgnoreCase("getDocument")) {
            keyspace = (String)((Argument)call.getArguments().get(1)).getArgumentValue().getValue();
        }
        if (call.getProcedureName().equalsIgnoreCase("getDocuments")) {
            this.appendKeyspace(keyspace);
            this.appendN1QLWhere(call);
            return;
        }
        if (call.getProcedureName().equalsIgnoreCase("getDocument")) {
            this.appendKeyspace(keyspace);
            this.appendN1QLPK(call);
            return;
        }
    }

    protected String escapeString(String str, String quote) {
        return StringUtil.replaceAll((String)str, (String)quote, (String)"\\u0027");
    }

    private void appendKeyspace(String keyspace) {
        this.buffer.append("SELECT").append(" ");
        this.buffer.append("result").append(" ");
        this.buffer.append("FROM").append(" ");
        this.buffer.append(CouchbaseMetadataProcessor.nameInSource(keyspace)).append(" ");
        this.buffer.append("AS").append(" ").append("result").append(" ");
    }

    private void appendN1QLWhere(Call call) {
        this.buffer.append("WHERE").append(" ");
        this.buffer.append("META").append("(").append(")").append(".id").append(" ");
        this.buffer.append("LIKE").append(" ");
        this.append((LanguageObject)call.getArguments().get(0));
    }

    private void appendN1QLPK(Call call) {
        this.buffer.append("USE PRIMARY KEYS").append(" ");
        this.append((LanguageObject)call.getArguments().get(0));
    }

    protected static class CBColumn {
        private boolean isPK;
        private boolean isIdx;
        private String nameReference;
        private String leafName;
        private String nameInSource;
        private String valueReference;
        private String unnest;
        private String tableAlias;

        public CBColumn(boolean isPK, boolean isIdx, String nameReference, String leafName, String nameInSource) {
            this.isPK = isPK;
            this.isIdx = isIdx;
            this.nameReference = nameReference;
            this.leafName = leafName;
            this.nameInSource = nameInSource;
        }

        public boolean isPK() {
            return this.isPK;
        }

        public boolean isIdx() {
            return this.isIdx;
        }

        public String getNameReference() {
            return this.nameReference;
        }

        public boolean hasLeaf() {
            return this.leafName != null && this.leafName.length() > 0;
        }

        public String getLeafName() {
            return this.leafName;
        }

        public String getNameInSource() {
            return this.nameInSource;
        }

        public String getValueReference() {
            return this.valueReference;
        }

        public void setValueReference(String valueReference) {
            this.valueReference = valueReference;
        }

        boolean hasUnnest() {
            return this.unnest != null && this.unnest.length() > 0;
        }

        public String getUnnest() {
            return this.unnest;
        }

        public void setUnnest(String unnest) {
            this.unnest = unnest;
        }

        public String getTableAlias() {
            return this.tableAlias;
        }

        public void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }
    }

    private class AliasGenerator {
        private final String prefix;
        private Integer aliasCounter;

        AliasGenerator(String prefix) {
            this.prefix = prefix;
            this.aliasCounter = 1;
        }

        public String generate() {
            int index = this.aliasCounter;
            String alias = this.prefix + index;
            this.aliasCounter = this.aliasCounter + 1;
            return alias;
        }
    }
}

