/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.teiid.core.BundleUtil;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.In;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.ExcelPlugin;

public class ExcelQueryVisitor
extends HierarchyVisitor {
    protected Stack<Object> onGoingExpression = new Stack();
    private List<Integer> projectedColumns = new ArrayList<Integer>();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private Table table;
    private String xlsPath;
    private String sheetName;
    private int firstDataRowNumber;
    private ArrayList<Filter> filters = new ArrayList();

    public List<Integer> getProjectedColumns() {
        return this.projectedColumns;
    }

    public int getFirstDataRowNumber() {
        return this.firstDataRowNumber;
    }

    public ArrayList<TranslatorException> getExceptions() {
        return this.exceptions;
    }

    public Table getTable() {
        return this.table;
    }

    public String getXlsPath() {
        return this.xlsPath;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void visit(ColumnReference obj) {
        this.onGoingExpression.push(obj.getMetadataObject());
    }

    public void visit(DerivedColumn obj) {
        this.visitNode((LanguageObject)obj.getExpression());
        Column column = (Column)this.onGoingExpression.pop();
        String str = column.getProperty("{http://www.teiid.org/translator/excel/2014}CELL_NUMBER", false);
        if (str == null) {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23007, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23007, new Object[]{column.getName()})));
            return;
        }
        if (str.equalsIgnoreCase("ROW_ID")) {
            this.projectedColumns.add(-1);
        } else {
            this.projectedColumns.add(Integer.valueOf(str));
        }
    }

    public void visit(NamedTable obj) {
        this.table = obj.getMetadataObject();
        this.xlsPath = this.table.getProperty("{http://www.teiid.org/translator/excel/2014}FILE", false);
        this.sheetName = this.table.getSourceName();
        String firstRow = this.table.getProperty("{http://www.teiid.org/translator/excel/2014}FIRST_DATA_ROW_NUMBER", false);
        if (firstRow != null) {
            this.firstDataRowNumber = Integer.parseInt(firstRow) - 1;
        }
    }

    public void visit(AndOr obj) {
        this.visitNode((LanguageObject)obj.getLeftCondition());
        this.visitNode((LanguageObject)obj.getRightCondition());
    }

    public void visit(Comparison obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        Column column = (Column)this.onGoingExpression.pop();
        this.visitNode((LanguageObject)obj.getRightExpression());
        Integer rightExpr = (Integer)this.onGoingExpression.pop();
        if (ExcelQueryVisitor.isPartOfPrimaryKey(column)) {
            switch (obj.getOperator()) {
                case EQ: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.EQ));
                    break;
                }
                case NE: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.NE));
                    break;
                }
                case LT: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.LT));
                    break;
                }
                case LE: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.LE));
                    break;
                }
                case GT: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.GT));
                    break;
                }
                case GE: {
                    this.filters.add(new CompareFilter(rightExpr - 1, Comparison.Operator.GE));
                }
            }
        } else {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23008, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23008, new Object[]{column.getName()})));
        }
    }

    public void visit(In obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        Column column = (Column)this.onGoingExpression.pop();
        this.visitNodes(obj.getRightExpressions());
        if (ExcelQueryVisitor.isPartOfPrimaryKey(column)) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
                values.add((Integer)this.onGoingExpression.pop());
            }
            this.filters.add(new InFilter(values.toArray(new Integer[values.size()])));
        } else {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23008, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23008, new Object[]{column.getName()})));
        }
    }

    public void visit(Literal obj) {
        this.onGoingExpression.push(obj.getValue());
    }

    public void visit(Limit obj) {
        int offset = obj.getRowOffset();
        if (offset != 0) {
            this.firstDataRowNumber = offset + this.firstDataRowNumber;
        }
        this.filters.add(new CompareFilter(this.firstDataRowNumber, Comparison.Operator.GE));
        this.filters.add(new CompareFilter(this.firstDataRowNumber + obj.getRowLimit(), Comparison.Operator.LT));
    }

    public static boolean isPartOfPrimaryKey(Column column) {
        KeyRecord pk = ((Table)column.getParent()).getPrimaryKey();
        if (pk != null) {
            for (Column col : pk.getColumns()) {
                if (!col.getName().equals(column.getName()) || !col.getProperty("{http://www.teiid.org/translator/excel/2014}CELL_NUMBER", false).equalsIgnoreCase("ROW_ID")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allows(int row) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Filter f : this.filters) {
            if (f.allows(row)) continue;
            return false;
        }
        return true;
    }

    static class CompareFilter
    implements Filter {
        int start;
        Comparison.Operator op;

        public CompareFilter(int start, Comparison.Operator op) {
            this.start = start;
            this.op = op;
        }

        @Override
        public boolean allows(int row) {
            switch (this.op) {
                case EQ: {
                    return row == this.start;
                }
                case NE: {
                    return row != this.start;
                }
                case LT: {
                    return row < this.start;
                }
                case LE: {
                    return row <= this.start;
                }
                case GT: {
                    return row > this.start;
                }
                case GE: {
                    return row >= this.start;
                }
            }
            return false;
        }
    }

    static class InFilter
    implements Filter {
        Integer[] values;

        public InFilter(Integer[] allowed) {
            this.values = allowed;
        }

        @Override
        public boolean allows(int row) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != row) continue;
                return true;
            }
            return false;
        }
    }

    static interface Filter {
        public boolean allows(int var1);
    }
}

