/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.FileConnection;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.ExcelExecutionFactory;

public class TestExcelExecution {
    static String commonDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\t\"time\" time OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '14');";

    private ArrayList helpExecute(String ddl, FileConnection connection, String query) throws Exception {
        return this.helpExecute(ddl, connection, query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList helpExecute(String ddl, FileConnection connection, String query, boolean format) throws Exception {
        ExcelExecutionFactory translator = new ExcelExecutionFactory();
        translator.setFormatStrings(format);
        translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"vdb", (String)"excel");
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)metadata);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        try (ResultSetExecution execution = translator.createResultSetExecution((QueryExpression)cmd, context, utility.createRuntimeMetadata(), connection);){
            List row;
            execution.execute();
            ArrayList<List> results = new ArrayList<List>();
            while ((row = execution.next()) != null) {
                results.add(row);
            }
            ArrayList<List> arrayList = results;
            return arrayList;
        }
    }

    @Test
    public void testExecutionNoDataNumberXLS() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xls');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[13, FirstName, LastName, Age], [14, John, Doe, 44.0], [15, Jane, Smith, 40.0], [16, Matt, Liek, 13.0], [17, Sarah, Byne, 10.0], [18, Rocky, Dog, 3.0], [19, Total, null, 110.0]]", (Object)results.toString());
    }

    @Test
    public void testFileGlob() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n   ROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n   column1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n   column2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n   column3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n   CONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" '*.xls');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        File f = (File)Mockito.mock(File.class);
        Mockito.stub((Object)f.isDirectory()).toReturn((Object)true);
        Mockito.stub((Object)f.listFiles()).toReturn((Object)new File[]{UnitTestUtil.getTestDataFile((String)"names.xls")});
        Mockito.stub((Object)connection.getFile("*.xls")).toReturn((Object)f);
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[13, FirstName, LastName, Age], [14, John, Doe, 44.0], [15, Jane, Smith, 40.0], [16, Matt, Liek, 13.0], [17, Sarah, Byne, 10.0], [18, Rocky, Dog, 3.0], [19, Total, null, 110.0]]", (Object)results.toString());
    }

    @Test
    public void testExecutionNoDataNumberXLSX() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xlsx');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xlsx")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xlsx"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[1, FirstName, LastName, Age], [2, John, Doe, null], [3, Jane, Smith, 40.0], [4, Matt, Liek, 13.0], [5, Sarah, Byne, 10.0], [6, Rocky, Dog, 3.0]]", (Object)results.toString());
    }

    @Test
    public void testExecutionColumnWithNullCell() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1')\n) OPTIONS (\"teiid_excel:FILE\" '3219.xlsx');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("3219.xlsx")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"3219.xlsx"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((long)results.size(), (long)7L);
    }

    @Test
    public void testExecutionHeaderWithEmptyCell() throws Exception {
        String ddl = "SET NAMESPACE 'http://www.teiid.org/translator/excel/2014' AS teiid_excel;\n\nCREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'empty-ignore.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("empty-ignore.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"empty-ignore.xls"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((long)6L, (long)results.size());
        ArrayList row = (ArrayList)results.get(4);
        Assert.assertEquals((long)4L, (long)row.size());
    }

    @Test
    public void testExecutionColumnsWithNullCell() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2')\n) OPTIONS (\"teiid_excel:FILE\" '3219.xlsx');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("3219.xlsx")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"3219.xlsx"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((long)results.size(), (long)7L);
    }

    @Test
    public void testExecutionWithDataNumberXLS() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '18');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[18, Rocky, Dog, 3.0], [19, Total, null, 110.0]]", (Object)results.toString());
        results = this.helpExecute(ddl, connection, "select * from Sheet1", true);
        Assert.assertEquals((Object)"[[18, Rocky, Dog, 3], [19, Total, null, 110]]", (Object)results.toString());
    }

    @Test
    public void testExecutionWithDataNumberXLSX() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '6');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xlsx")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xlsx"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[6, Rocky, Dog, 3.0]]", (Object)results.toString());
    }

    @Test
    public void testExecutionWithDataNumberWithHeaderXLS() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (\"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '18');";
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(ddl, connection, "select * from Sheet1");
        Assert.assertEquals((Object)"[[18, Rocky, Dog, 3.0], [19, Total, null, 110.0]]", (Object)results.toString());
    }

    @Test
    public void testExecutionEquals() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID=16");
        Assert.assertEquals((Object)"[[Matt]]", (Object)results.toString());
    }

    @Test
    public void testExecutionGT() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID>16");
        Assert.assertEquals((Object)"[[Sarah], [Rocky], [Total]]", (Object)results.toString());
    }

    @Test
    public void testExecutionGE() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID>=16");
        Assert.assertEquals((Object)"[[Matt], [Sarah], [Rocky], [Total]]", (Object)results.toString());
    }

    @Test
    public void testExecutionLT() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID < 16");
        Assert.assertEquals((Object)"[[John], [Jane]]", (Object)results.toString());
    }

    @Test
    public void testExecutionLE() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID <= 16");
        Assert.assertEquals((Object)"[[John], [Jane], [Matt]]", (Object)results.toString());
    }

    @Test
    public void testExecutionNE() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID != 16");
        Assert.assertEquals((Object)"[[John], [Jane], [Sarah], [Rocky], [Total]]", (Object)results.toString());
    }

    @Test
    public void testExecutionLimit() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 LIMIT 3,1");
        Assert.assertEquals((Object)"[[Sarah]]", (Object)results.toString());
    }

    @Test
    public void testExecutionLimit2() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 LIMIT 1");
        Assert.assertEquals((Object)"[[John]]", (Object)results.toString());
    }

    @Test
    public void testExecutionAnd() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID > 16 and ROW_ID < 18");
        Assert.assertEquals((Object)"[[Sarah]]", (Object)results.toString());
    }

    @Test
    public void testExecutionIN() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID IN (13, 18)");
        Assert.assertEquals((Object)"[[John], [Total]]", (Object)results.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTime() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xlsx"));
        ArrayList results = this.helpExecute(commonDDL, connection, "select \"time\" from Sheet1");
        Assert.assertEquals((Object)"[[10:12:14]]", (Object)results.toString());
        String ddl = commonDDL.replace("\"time\" time", "\"time\" string");
        results = this.helpExecute(ddl, connection, "select \"time\" from Sheet1", true);
        Assert.assertEquals((Object)"[[10:12:14 AM]]", (Object)results.toString());
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/New_York"));
        try {
            results = this.helpExecute(ddl, connection, "select \"time\" from Sheet1", false);
            Assert.assertEquals((Object)"[[1899-12-31 10:12:14.0]]", (Object)results.toString());
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test(expected=TranslatorException.class)
    public void testExecutionNoFile() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)new File("does not exist"));
        this.helpExecute(commonDDL, connection, "select FirstName from Sheet1 WHERE ROW_ID != 16");
    }
}

