/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import javax.resource.cci.ConnectionFactory;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.FileConnection;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.excel.ExcelExecution;
import org.teiid.translator.excel.ExcelMetadataProcessor;

@Translator(name="excel", description="Excel file translator")
public class ExcelExecutionFactory
extends ExecutionFactory<ConnectionFactory, FileConnection> {
    private boolean formatStrings;

    public ExcelExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public void start() throws TranslatorException {
        super.start();
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, FileConnection connection) throws TranslatorException {
        ExcelExecution ex = new ExcelExecution((Select)command, executionContext, metadata, connection);
        if (this.formatStrings) {
            ex.setDataFormatter(new DataFormatter());
        }
        return ex;
    }

    public MetadataProcessor<FileConnection> getMetadataProcessor() {
        return new ExcelMetadataProcessor();
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    @TranslatorProperty(display="Format Strings", description="Format non-string cell values in a string column according to the worksheet format.", advanced=true)
    public boolean isFormatStrings() {
        return this.formatStrings;
    }

    public void setFormatStrings(boolean formatStrings) {
        this.formatStrings = formatStrings;
    }
}

