/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.FileConnection;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.ExcelMetadataProcessor;
import org.teiid.translator.excel.ExcelPlugin;
import org.teiid.translator.excel.ExcelQueryVisitor;

public class ExcelExecution
implements ResultSetExecution {
    private ExecutionContext executionContext;
    private RuntimeMetadata metadata;
    private FileConnection connection;
    private Iterator<Row> rowIterator;
    private Row currentRow;
    private File[] xlsFiles;
    private AtomicInteger fileCount = new AtomicInteger();
    private ExcelQueryVisitor visitor;
    private FormulaEvaluator evaluator;
    private FileInputStream xlsFileStream;
    private Class<?>[] expectedColumnTypes;
    private DataFormatter dataFormatter;

    public ExcelExecution(Select query, ExecutionContext executionContext, RuntimeMetadata metadata, FileConnection connection) throws TranslatorException {
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.connection = connection;
        this.expectedColumnTypes = query.getColumnTypes();
        this.visitor = new ExcelQueryVisitor();
        this.visitor.visitNode((LanguageObject)query);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
    }

    public void execute() throws TranslatorException {
        try {
            this.xlsFiles = FileConnection.Util.getFiles((String)this.visitor.getXlsPath(), (FileConnection)this.connection, (boolean)true);
            this.rowIterator = this.readXLSFile(this.xlsFiles[this.fileCount.getAndIncrement()]);
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private Iterator<Row> readXLSFile(File xlsFile) throws TranslatorException {
        try {
            HSSFSheet sheet;
            HSSFWorkbook workbook;
            this.xlsFileStream = new FileInputStream(xlsFile);
            Iterator rowIter = null;
            String extension = ExcelMetadataProcessor.getFileExtension(xlsFile);
            if (extension.equalsIgnoreCase("xls")) {
                workbook = new HSSFWorkbook((InputStream)this.xlsFileStream);
                sheet = workbook.getSheet(this.visitor.getSheetName());
                this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                rowIter = sheet.iterator();
            } else if (extension.equalsIgnoreCase("xlsx")) {
                workbook = new XSSFWorkbook((InputStream)this.xlsFileStream);
                sheet = workbook.getSheet(this.visitor.getSheetName());
                this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                rowIter = sheet.iterator();
            } else {
                throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23000, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23000, new Object[0]));
            }
            if (this.visitor.getFirstDataRowNumber() > 0 && rowIter != null) {
                while (rowIter.hasNext()) {
                    this.currentRow = (Row)rowIter.next();
                    if (this.currentRow.getRowNum() >= this.visitor.getFirstDataRowNumber()) break;
                    this.currentRow = null;
                }
            }
            return rowIter;
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        while (this.hasNext()) {
            Row row = this.nextRow();
            if (row.getFirstCellNum() == -1 || !this.visitor.allows(row.getRowNum())) continue;
            return this.projectRow(row);
        }
        return null;
    }

    private boolean hasNext() throws TranslatorException {
        if (this.currentRow != null) {
            return true;
        }
        boolean hasNext = false;
        if (this.rowIterator != null) {
            hasNext = this.rowIterator.hasNext();
        }
        if (!hasNext) {
            this.rowIterator = null;
            File nextXlsFile = this.getNextXLSFile();
            if (nextXlsFile != null) {
                this.rowIterator = this.readXLSFile(nextXlsFile);
                hasNext = this.rowIterator.hasNext();
            }
        }
        return hasNext;
    }

    private File getNextXLSFile() {
        if (this.xlsFiles.length > this.fileCount.get()) {
            try {
                this.xlsFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.xlsFiles[this.fileCount.getAndIncrement()];
        }
        return null;
    }

    private Row nextRow() {
        if (this.currentRow != null) {
            Row row = this.currentRow;
            this.currentRow = null;
            return row;
        }
        Row row = null;
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            row = this.rowIterator.next();
        }
        return row;
    }

    List<Object> projectRow(Row row) throws TranslatorException {
        ArrayList<Object> output = new ArrayList<Object>(this.visitor.getProjectedColumns().size());
        int id = row.getRowNum() + 1;
        int i = -1;
        block5: for (int index : this.visitor.getProjectedColumns()) {
            ++i;
            if (index == -1) {
                output.add(id);
                continue;
            }
            Cell cell = row.getCell(index - 1, Row.RETURN_BLANK_AS_NULL);
            if (cell == null) {
                output.add(null);
                continue;
            }
            switch (this.evaluator.evaluateInCell(cell).getCellType()) {
                case 0: {
                    output.add(this.convertFromExcelType(cell.getNumericCellValue(), cell, this.expectedColumnTypes[i]));
                    continue block5;
                }
                case 1: {
                    output.add(ExcelExecution.convertFromExcelType(cell.getStringCellValue(), this.expectedColumnTypes[i]));
                    continue block5;
                }
                case 4: {
                    output.add(this.convertFromExcelType(cell.getBooleanCellValue(), this.expectedColumnTypes[i]));
                    continue block5;
                }
            }
            output.add(null);
        }
        return output;
    }

    Object convertFromExcelType(boolean value, Class<?> expectedType) throws TranslatorException {
        if (expectedType.isAssignableFrom(Boolean.class)) {
            return value;
        }
        try {
            return DataTypeManager.transformValue((Object)value, expectedType);
        }
        catch (TransformationException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    Object convertFromExcelType(Double value, Cell cell, Class<?> expectedType) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(Double.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(Timestamp.class)) {
            java.util.Date date = cell.getDateCellValue();
            return new Timestamp(date.getTime());
        }
        if (expectedType.isAssignableFrom(Date.class)) {
            java.util.Date date = cell.getDateCellValue();
            return TimestampWithTimezone.createDate((java.util.Date)date);
        }
        if (expectedType.isAssignableFrom(Time.class)) {
            java.util.Date date = cell.getDateCellValue();
            return TimestampWithTimezone.createTime((java.util.Date)date);
        }
        if (expectedType == String.class && this.dataFormatter != null) {
            return this.dataFormatter.formatCellValue(cell);
        }
        Comparable<Double> val = value;
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            java.util.Date date = cell.getDateCellValue();
            val = new Timestamp(date.getTime());
        }
        try {
            return DataTypeManager.transformValue((Object)val, expectedType);
        }
        catch (TransformationException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    static Object convertFromExcelType(final String value, Class<?> expectedType) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(String.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(Blob.class)) {
            return new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(value.getBytes());
                }
            }));
        }
        if (expectedType.isAssignableFrom(Clob.class)) {
            return new ClobType((Clob)new ClobImpl(value));
        }
        if (expectedType.isAssignableFrom(SQLXML.class)) {
            return new XMLType((SQLXML)new SQLXMLImpl(value.getBytes()));
        }
        if (DataTypeManager.isTransformable(String.class, expectedType)) {
            try {
                return DataTypeManager.transformValue((Object)value, expectedType);
            }
            catch (TransformationException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23003, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23003, new Object[]{expectedType.getName()}));
    }

    public void close() {
        if (this.xlsFileStream != null) {
            try {
                this.xlsFileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cancel() throws TranslatorException {
    }

    public void setDataFormatter(DataFormatter dataFormatter) {
        this.dataFormatter = dataFormatter;
    }
}

