/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.FileConnection;
import org.teiid.translator.excel.ExcelExecutionFactory;
import org.teiid.translator.excel.ExcelUpdateExecution;
import org.teiid.translator.excel.TestExcelExecution;

public class TestExcelUpdateExecution {
    @Test
    public void testDeleteAll() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        int[] results = this.helpExecute(TestExcelExecution.commonDDL, connection, "delete from Sheet1", true, "scratch_file.xls");
        Assert.assertArrayEquals((int[])new int[]{6}, (int[])results);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestScratchFile((String)"scratch_file.xls"));
        ArrayList result = TestExcelExecution.helpExecute(TestExcelExecution.commonDDL, connection, "select * from sheet1");
        Assert.assertEquals(Collections.emptyList(), (Object)result);
    }

    @Test
    public void testDeleteSome() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        int[] results = this.helpExecute(TestExcelExecution.commonDDL, connection, "delete from Sheet1 WHERE ROW_ID < 16", true, "scratch_file.xls");
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])results);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestScratchFile((String)"scratch_file.xls"));
        ArrayList result = TestExcelExecution.helpExecute(TestExcelExecution.commonDDL, connection, "select * from sheet1");
        Assert.assertEquals((Object)"[[16, Matt, Liek, 13.0, null], [17, Sarah, Byne, 10.0, null], [18, Rocky, Dog, 3.0, null], [19, Total, null, 26.0, null]]", (Object)((Object)result).toString());
    }

    @Test
    public void testInsert() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        int[] results = this.helpExecute(TestExcelExecution.commonDDL, connection, "insert into sheet1 (FirstName, Age) values ('Prince', 55)", true, "scratch_file.xls");
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])results);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestScratchFile((String)"scratch_file.xls"));
        ArrayList result = TestExcelExecution.helpExecute(TestExcelExecution.commonDDL, connection, "select * from sheet1");
        Assert.assertEquals((long)7L, (long)result.size());
        Assert.assertEquals((Object)"[20, Prince, null, 55.0, null]", (Object)result.get(6).toString());
    }

    @Test
    public void testUpdate() throws Exception {
        FileConnection connection = (FileConnection)Mockito.mock(FileConnection.class);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestDataFile((String)"names.xls"));
        int[] results = this.helpExecute(TestExcelExecution.commonDDL, connection, "update sheet1 set age = 12 where row_id = 17", true, "scratch_file.xls");
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])results);
        Mockito.stub((Object)connection.getFile("names.xls")).toReturn((Object)UnitTestUtil.getTestScratchFile((String)"scratch_file.xls"));
        ArrayList result = TestExcelExecution.helpExecute(TestExcelExecution.commonDDL, connection, "select * from sheet1");
        Assert.assertEquals((Object)"[[14, John, Doe, 44.0, null], [15, Jane, Smith, 40.0, null], [16, Matt, Liek, 13.0, null], [17, Sarah, Byne, 12.0, null], [18, Rocky, Dog, 3.0, null], [19, Total, null, 112.0, null]]", (Object)((Object)result).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] helpExecute(String ddl, FileConnection connection, String query, boolean format, String resultFile) throws Exception {
        ExcelExecutionFactory translator = new ExcelExecutionFactory();
        translator.setFormatStrings(format);
        translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"vdb", (String)"excel");
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)metadata);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)context.getCommandContext()).toReturn((Object)new CommandContext());
        execution.setWriteTo(UnitTestUtil.getTestScratchFile((String)resultFile));
        try (ExcelUpdateExecution execution = translator.createUpdateExecution(cmd, context, utility.createRuntimeMetadata(), connection);){
            execution.execute();
            int[] nArray = execution.getUpdateCounts();
            return nArray;
        }
    }
}

