/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.teiid.GeneratedKeys;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.Delete;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.excel.BaseExcelExecution;

public class ExcelUpdateExecution
extends BaseExcelExecution
implements UpdateExecution {
    private LanguageObject command;
    private int result;
    private VirtualFile writeTo;
    private boolean modified;

    public ExcelUpdateExecution(LanguageObject command, ExecutionContext executionContext, RuntimeMetadata metadata, VirtualFileConnection connection) throws TranslatorException {
        super(executionContext, metadata, connection);
        this.visit(command);
        this.command = command;
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.result};
    }

    @Override
    public void execute() throws TranslatorException {
        super.execute();
        if (this.command instanceof Update) {
            this.handleUpdate();
        } else if (this.command instanceof Delete) {
            this.handleDelete();
        } else if (this.command instanceof Insert) {
            this.handleInsert();
        }
    }

    private void handleInsert() throws TranslatorException {
        Insert insert = (Insert)this.command;
        ExpressionValueSource evs = (ExpressionValueSource)insert.getValueSource();
        Row row = this.nextRow();
        Sheet sheet = null;
        sheet = row == null ? this.workbook.getSheet(this.visitor.getSheetName()) : row.getSheet();
        int last = sheet.getLastRowNum();
        Row newRow = sheet.createRow(last + 1);
        List<Integer> cols = this.visitor.getProjectedColumns();
        for (int i = 0; i < cols.size(); ++i) {
            int index = cols.get(i);
            this.setValue(newRow, index - 1, ((Literal)evs.getValues().get(i)).getValue());
        }
        if (this.executionContext.getCommandContext().isReturnAutoGeneratedKeys()) {
            GeneratedKeys keys = this.executionContext.getCommandContext().returnGeneratedKeys(new String[]{"ROW_ID"}, new Class[]{TypeFacility.RUNTIME_TYPES.INTEGER});
            keys.addKey(Arrays.asList(last + 1));
        }
        ++this.result;
        this.writeXLSFile();
    }

    private void handleUpdate() throws TranslatorException {
        Row row;
        Update update = (Update)this.command;
        List changes = update.getChanges();
        while ((row = this.nextRow()) != null) {
            for (int i = 0; i < this.visitor.getProjectedColumns().size(); ++i) {
                int index = this.visitor.getProjectedColumns().get(i);
                Object o = ((Literal)((SetClause)changes.get(i)).getValue()).getValue();
                this.setValue(row, index - 1, o);
            }
            this.modified = true;
            ++this.result;
        }
    }

    private void setValue(Row row, int index, Object o) {
        Cell cell = row.getCell(index);
        if (cell == null) {
            cell = row.createCell(index);
        }
        if (o == null) {
            cell.setCellValue((String)null);
            return;
        }
        if (o instanceof Number) {
            cell.setCellValue(((Number)o).doubleValue());
        } else if (o instanceof Date) {
            cell.setCellValue((Date)o);
        } else if (o instanceof Boolean) {
            cell.setCellValue(((Boolean)o).booleanValue());
        } else {
            cell.setCellValue(o.toString());
        }
    }

    private void handleDelete() throws TranslatorException {
        Row row;
        while ((row = this.nextRow()) != null) {
            this.rowIterator = null;
            int start = row.getRowNum();
            Sheet sheet = row.getSheet();
            int end = sheet.getLastRowNum();
            for (int i = start; i <= end; ++i) {
                row = sheet.getRow(i);
                if (row == null || row.getFirstCellNum() == -1 || !this.visitor.allows(row.getRowNum())) continue;
                sheet.removeRow(row);
                ++this.result;
                this.modified = true;
            }
        }
    }

    @Override
    protected VirtualFile getNextXLSFile() throws TranslatorException {
        if (this.modified) {
            this.writeXLSFile();
        }
        return super.getNextXLSFile();
    }

    private void writeXLSFile() throws TranslatorException {
        try (OutputStream fos = (this.writeTo == null ? this.getCurrentXLSFile() : this.writeTo).openOutputStream(true);){
            this.workbook.write(fos);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void setWriteTo(VirtualFile writeTo) {
        this.writeTo = writeTo;
    }
}

