/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.ExcelMetadataProcessor;
import org.teiid.translator.excel.ExcelPlugin;
import org.teiid.translator.excel.ExcelQueryVisitor;

public class BaseExcelExecution
implements Execution {
    protected ExecutionContext executionContext;
    protected RuntimeMetadata metadata;
    protected VirtualFileConnection connection;
    protected Iterator<Row> rowIterator;
    private Row currentRow;
    private VirtualFile[] xlsFiles;
    private AtomicInteger fileCount = new AtomicInteger();
    protected ExcelQueryVisitor visitor = new ExcelQueryVisitor();
    protected FormulaEvaluator evaluator;
    private DataFormatter dataFormatter;
    protected Workbook workbook;

    public BaseExcelExecution(ExecutionContext executionContext, RuntimeMetadata metadata, VirtualFileConnection connection) {
        this.executionContext = executionContext;
        this.metadata = metadata;
        this.connection = connection;
    }

    public void visit(LanguageObject command) throws TranslatorException {
        this.visitor.visitNode(command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
    }

    public void execute() throws TranslatorException {
        this.xlsFiles = VirtualFileConnection.Util.getFiles((String)this.visitor.getXlsPath(), (VirtualFileConnection)this.connection, (boolean)true);
        this.rowIterator = this.readXLSFile(this.xlsFiles[this.fileCount.getAndIncrement()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterator<Row> readXLSFile(VirtualFile xlsFile) throws TranslatorException {
        try (InputStream xlsFileStream = xlsFile.openInputStream(true);){
            String extension = ExcelMetadataProcessor.getFileExtension(xlsFile);
            if (extension.equalsIgnoreCase("xls")) {
                this.workbook = new HSSFWorkbook(xlsFileStream);
            } else {
                if (!extension.equalsIgnoreCase("xlsx")) throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23000, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23000, new Object[0]));
                this.workbook = new XSSFWorkbook(xlsFileStream);
            }
            Sheet sheet = this.workbook.getSheet(this.visitor.getSheetName());
            this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            Iterator rowIter = sheet.iterator();
            if (this.visitor.getFirstDataRowNumber() > 0 && rowIter != null) {
                while (rowIter.hasNext()) {
                    Row row = (Row)rowIter.next();
                    if (row.getRowNum() < this.visitor.getFirstDataRowNumber()) continue;
                    this.currentRow = row;
                    break;
                }
            }
            Iterator iterator = rowIter;
            return iterator;
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public Row nextRow() throws TranslatorException, DataNotAvailableException {
        Row row;
        do {
            if ((row = this.nextRowInternal()) != null) continue;
            return null;
        } while (row.getFirstCellNum() == -1 || !this.visitor.allows(row.getRowNum()));
        return row;
    }

    private Row nextRowInternal() throws TranslatorException {
        Row row = null;
        if (this.currentRow != null) {
            row = this.currentRow;
            this.currentRow = null;
            return row;
        }
        boolean hasNext = false;
        if (this.rowIterator != null) {
            hasNext = this.rowIterator.hasNext();
        }
        while (!hasNext) {
            this.rowIterator = null;
            VirtualFile nextXlsFile = this.getNextXLSFile();
            if (nextXlsFile == null) break;
            this.rowIterator = this.readXLSFile(nextXlsFile);
            hasNext = this.rowIterator.hasNext();
        }
        if (hasNext) {
            row = this.rowIterator.next();
        }
        return row;
    }

    protected VirtualFile getNextXLSFile() throws TranslatorException {
        if (this.xlsFiles.length > this.fileCount.get()) {
            return this.xlsFiles[this.fileCount.getAndIncrement()];
        }
        return null;
    }

    protected VirtualFile getCurrentXLSFile() {
        if (this.xlsFiles.length >= this.fileCount.get()) {
            return this.xlsFiles[this.fileCount.get() - 1];
        }
        return null;
    }

    Object convertFromExcelType(boolean value, Class<?> expectedType) throws TranslatorException {
        if (expectedType.isAssignableFrom(Boolean.class)) {
            return value;
        }
        try {
            return DataTypeManager.transformValue((Object)value, expectedType);
        }
        catch (TransformationException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    Object convertFromExcelType(Double value, Cell cell, Class<?> expectedType) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(Double.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(Timestamp.class)) {
            java.util.Date date = cell.getDateCellValue();
            return new Timestamp(date.getTime());
        }
        if (expectedType.isAssignableFrom(Date.class)) {
            java.util.Date date = cell.getDateCellValue();
            return TimestampWithTimezone.createDate((java.util.Date)date);
        }
        if (expectedType.isAssignableFrom(Time.class)) {
            java.util.Date date = cell.getDateCellValue();
            return TimestampWithTimezone.createTime((java.util.Date)date);
        }
        if (expectedType == String.class && this.dataFormatter != null) {
            return this.dataFormatter.formatCellValue(cell);
        }
        Comparable<Double> val = value;
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            java.util.Date date = cell.getDateCellValue();
            val = new Timestamp(date.getTime());
        }
        try {
            return DataTypeManager.transformValue((Object)val, expectedType);
        }
        catch (TransformationException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    static Object convertFromExcelType(final String value, Class<?> expectedType) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(String.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(Blob.class)) {
            return new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(value.getBytes());
                }
            }));
        }
        if (expectedType.isAssignableFrom(Clob.class)) {
            return new ClobType((Clob)new ClobImpl(value));
        }
        if (expectedType.isAssignableFrom(SQLXML.class)) {
            return new XMLType((SQLXML)new SQLXMLImpl(value.getBytes()));
        }
        if (DataTypeManager.isTransformable(String.class, expectedType)) {
            try {
                return DataTypeManager.transformValue((Object)value, expectedType);
            }
            catch (TransformationException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23003, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23003, new Object[]{expectedType.getName()}));
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void setDataFormatter(DataFormatter dataFormatter) {
        this.dataFormatter = dataFormatter;
    }
}

