/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.teiid.core.BundleUtil;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.excel.ExcelPlugin;

public class ExcelMetadataProcessor
implements MetadataProcessor<VirtualFileConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Excel File Name", description="Excel File name, use file name pattern if one than one file in the parent directory", required=true)
    public static final String FILE = "teiid_excel:FILE";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=Integer.class, display="Cell Number", description="Cell number, where the column information is defined. If column name is ROW_ID, define it as -1", required=true)
    public static final String CELL_NUMBER = "teiid_excel:CELL_NUMBER";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=Integer.class, display="First Data Number", description="First Row Number, where data rows start")
    public static final String FIRST_DATA_ROW_NUMBER = "teiid_excel:FIRST_DATA_ROW_NUMBER";
    public static final String ROW_ID = "ROW_ID";
    private String excelFileName;
    private boolean ignoreEmptyCells = false;
    private int headerRowNumber = 0;
    private boolean hasHeader = false;
    private int dataRowNumber = 0;
    private boolean hasDataRowNumber = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MetadataFactory mf, VirtualFileConnection conn) throws TranslatorException {
        if (this.excelFileName == null) {
            throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23004, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23004, new Object[]{"importer.ExcelFileName"}));
        }
        try {
            VirtualFile[] xlsFiles = conn.getFiles(this.excelFileName);
            if (xlsFiles == null || xlsFiles.length == 0) {
                throw new TranslatorException((BundleUtil.Event)ExcelPlugin.Event.TEIID23005, ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23005, new Object[]{this.excelFileName}));
            }
            VirtualFile xlsFile = xlsFiles[0];
            String extension = ExcelMetadataProcessor.getFileExtension(xlsFile);
            try (InputStream xlsFileStream = xlsFile.openInputStream(true);){
                HSSFWorkbook workbook = null;
                if (extension.equalsIgnoreCase("xls")) {
                    workbook = new HSSFWorkbook(xlsFileStream);
                } else if (extension.equalsIgnoreCase("xlsx")) {
                    workbook = new XSSFWorkbook(xlsFileStream);
                }
                int sheetCount = workbook.getNumberOfSheets();
                for (int i = 0; i < sheetCount; ++i) {
                    Sheet sheet = workbook.getSheetAt(i);
                    this.addTable(mf, sheet, xlsFile.getName(), this.excelFileName);
                }
            }
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void addTable(MetadataFactory mf, Sheet sheet, String xlsName, String originalName) {
        int firstRowNumber = sheet.getFirstRowNum();
        Row headerRow = null;
        int firstCellNumber = -1;
        if (this.hasHeader && (headerRow = sheet.getRow(this.headerRowNumber)) != null) {
            firstRowNumber = this.headerRowNumber;
            firstCellNumber = headerRow.getFirstCellNum();
            if (firstCellNumber == -1) {
                LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)ExcelPlugin.Util.gs((BundleUtil.Event)ExcelPlugin.Event.TEIID23006, new Object[]{xlsName}));
                return;
            }
        }
        if (headerRow == null) {
            while (firstCellNumber == -1) {
                if ((headerRow = sheet.getRow(firstRowNumber++)) == null && firstRowNumber > 10000) {
                    return;
                }
                if (headerRow == null) continue;
                firstCellNumber = headerRow.getFirstCellNum();
            }
        }
        AtomicInteger columnCount = new AtomicInteger();
        Table table = mf.addTable(sheet.getSheetName());
        table.setNameInSource(sheet.getSheetName());
        table.setProperty(FILE, originalName);
        Column column = mf.addColumn(ROW_ID, "integer", (ColumnSet)table);
        column.setSearchType(Column.SearchType.All_Except_Like);
        column.setProperty(CELL_NUMBER, ROW_ID);
        mf.addPrimaryKey("PK0", Arrays.asList(ROW_ID), table);
        column.setUpdatable(false);
        Row dataRow = null;
        int lastCellNumber = headerRow.getLastCellNum();
        if (this.hasHeader && !this.getIgnoreEmptyHeaderCells()) {
            Cell headerCell;
            int cellCounter = 0;
            for (int i = firstCellNumber; i < lastCellNumber && !this.isCellEmpty(headerCell = headerRow.getCell(i)); ++i) {
                ++cellCounter;
            }
            lastCellNumber = cellCounter + firstCellNumber;
        }
        if (this.hasDataRowNumber) {
            table.setProperty(FIRST_DATA_ROW_NUMBER, String.valueOf(this.dataRowNumber + 1));
            dataRow = sheet.getRow(this.dataRowNumber);
        } else if (this.hasHeader) {
            table.setProperty(FIRST_DATA_ROW_NUMBER, String.valueOf(firstRowNumber + 2));
            dataRow = sheet.getRow(firstRowNumber + 1);
        } else {
            table.setProperty(FIRST_DATA_ROW_NUMBER, String.valueOf(firstRowNumber));
            dataRow = sheet.getRow(firstRowNumber);
        }
        if (firstCellNumber != -1) {
            for (int j = firstCellNumber; j < lastCellNumber; ++j) {
                Cell headerCell = headerRow.getCell(j);
                if (this.hasHeader && this.getIgnoreEmptyHeaderCells() && this.isCellEmpty(headerCell)) continue;
                Cell dataCell = dataRow.getCell(j);
                if (dataCell == null) {
                    Row row;
                    for (int rowNo = firstRowNumber + 1; rowNo < firstRowNumber + 10000 && (dataCell = (row = sheet.getRow(rowNo)).getCell(j)) == null; ++rowNo) {
                    }
                }
                column = mf.addColumn(this.cellName(headerCell, columnCount), this.cellType(headerCell, dataCell), (ColumnSet)table);
                column.setSearchType(Column.SearchType.Unsearchable);
                column.setProperty(CELL_NUMBER, String.valueOf(j + 1));
            }
        }
    }

    private boolean isCellEmpty(Cell headerCell) {
        if (headerCell == null) {
            return true;
        }
        String name = headerCell.getStringCellValue();
        return name == null || name.isEmpty();
    }

    private String cellType(Cell headerCell, Cell dataCell) {
        if (this.hasHeader) {
            return this.getCellType(dataCell);
        }
        return this.getCellType(headerCell);
    }

    private String cellName(Cell headerCell, AtomicInteger count) {
        if (this.hasHeader) {
            return headerCell.getStringCellValue();
        }
        return "column" + count.incrementAndGet();
    }

    public void setExcelFileName(String fileName) {
        this.excelFileName = fileName;
    }

    static String getFileExtension(VirtualFile xlsFile) {
        int idx = xlsFile.getName().lastIndexOf(46);
        String extension = "xls";
        if (idx > 0) {
            extension = xlsFile.getName().substring(idx + 1);
        }
        return extension;
    }

    private String getCellType(Cell cell) {
        if (cell == null) {
            return "string";
        }
        switch (cell.getCellType()) {
            case 1: {
                return "string";
            }
            case 4: {
                return "boolean";
            }
        }
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            return "timestamp";
        }
        return "double";
    }

    @TranslatorProperty(display="Header Row Number", category=TranslatorProperty.PropertyType.IMPORT, description="Row number that contains the header information")
    public int getHeaderRowNumber() {
        return this.headerRowNumber;
    }

    public void setHeaderRowNumber(int headerRowNumber) {
        this.hasHeader = true;
        this.headerRowNumber = headerRowNumber - 1;
        if (this.headerRowNumber < 0) {
            this.headerRowNumber = 0;
        }
    }

    @TranslatorProperty(display="Ignore Empty Header Cells", category=TranslatorProperty.PropertyType.IMPORT, description="When true any cells with empty value for header row are ignored, otherwise an empty header row cell indicates end of columns.")
    public boolean getIgnoreEmptyHeaderCells() {
        return this.ignoreEmptyCells;
    }

    public void setIgnoreEmptyHeaderCells(boolean ignoreEmpty) {
        this.ignoreEmptyCells = ignoreEmpty;
    }

    @TranslatorProperty(display="Data Row Number", category=TranslatorProperty.PropertyType.IMPORT, description="Row number from which data rows start from")
    public int getDataRowNumber() {
        return this.dataRowNumber;
    }

    public void setDataRowNumber(int dataRowNumber) {
        this.hasDataRowNumber = true;
        this.dataRowNumber = dataRowNumber - 1;
        if (this.dataRowNumber < 0) {
            this.dataRowNumber = 0;
        }
    }

    @TranslatorProperty(display="Excel File", category=TranslatorProperty.PropertyType.IMPORT, description="Name of the Excel file to read metadata from", required=true)
    public String getExcelFileName() {
        return this.excelFileName;
    }
}

