/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.excel;

import java.util.Collection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.file.VirtualFileConnection;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.excel.ExcelExecutionFactory;
import org.teiid.translator.excel.TestExcelExecution;

public class TestExcelMetadataProcessor {
    static String getDDL(Properties props) throws TranslatorException {
        ExcelExecutionFactory translator = new ExcelExecutionFactory();
        translator.start();
        String xlsName = props.getProperty("importer.excelFileName");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "people", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        VirtualFileConnection connection = (VirtualFileConnection)Mockito.mock(VirtualFileConnection.class);
        Mockito.stub((Object)connection.getFiles(xlsName)).toReturn((Object)TestExcelExecution.getFile(xlsName));
        translator.getMetadata(mf, (Object)connection);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"vdb", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        return ddl;
    }

    @Test
    public void testSchemaNoHeaderXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xls");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '13');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaNoHeaderXLSX() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xlsx");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tcolumn4 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '1');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithHeaderXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xls");
        props.setProperty("importer.headerRowNumber", "13");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '14');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithEmptyHeaderRowsXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "emptycols.xls");
        props.setProperty("importer.headerRowNumber", "1");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'emptycols.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithIgnoreTrueHeaderRowsXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "empty-ignore.xls");
        props.setProperty("importer.headerRowNumber", "1");
        props.setProperty("importer.ignoreEmptyHeaderCells", "true");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'empty-ignore.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithIgnoreFalseHeaderRowsXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "empty-ignore.xls");
        props.setProperty("importer.headerRowNumber", "1");
        props.setProperty("importer.ignoreEmptyHeaderCells", "false");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'empty-ignore.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithHeaderXLSX() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xlsx");
        props.setProperty("importer.headerRowNumber", "1");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\t\"time\" timestamp OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaSetDataRowXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xls");
        props.setProperty("importer.dataRowNumber", "15");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '15');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaSetDataRowXLSX() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xlsx");
        props.setProperty("importer.dataRowNumber", "3");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tcolumn1 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tcolumn2 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tcolumn3 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tcolumn4 string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '3');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithHeaderAndDataXLS() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xls");
        props.setProperty("importer.headerRowNumber", "13");
        props.setProperty("importer.dataRowNumber", "15");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '7'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '8'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '9'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xls', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '15');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testSchemaWithHeaderAndDataXLSX() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xlsx");
        props.setProperty("importer.headerRowNumber", "1");
        props.setProperty("importer.dataRowNumber", "3");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\t\"time\" timestamp OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '3');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testEmptySheetXLSX() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "multi_sheet_empty_names.xlsx");
        props.setProperty("importer.headerRowNumber", "0");
        props.setProperty("importer.dataRowNumber", "2");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'multi_sheet_empty_names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }

    @Test
    public void testDataTypeFromNullCell() throws Exception {
        Properties props = new Properties();
        props.setProperty("importer.excelFileName", "names.xlsx");
        props.setProperty("importer.headerRowNumber", "1");
        props.setProperty("importer.dataRowNumber", "2");
        String ddl = TestExcelMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE Sheet1 (\n\tROW_ID integer OPTIONS (SEARCHABLE 'All_Except_Like', \"teiid_excel:CELL_NUMBER\" 'ROW_ID'),\n\tFirstName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '1'),\n\tLastName string OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '2'),\n\tAge double OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '3'),\n\t\"time\" timestamp OPTIONS (SEARCHABLE 'Unsearchable', \"teiid_excel:CELL_NUMBER\" '4'),\n\tCONSTRAINT PK0 PRIMARY KEY(ROW_ID)\n) OPTIONS (NAMEINSOURCE 'Sheet1', \"teiid_excel:FILE\" 'names.xlsx', \"teiid_excel:FIRST_DATA_ROW_NUMBER\" '2');";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }
}

