/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.file;

import java.io.File;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.file.JavaVirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.file.FileExecutionFactory;

public class TestFileExecutionFactory {
    @Test
    public void testGetTextFiles() throws Exception {
        List val;
        FileExecutionFactory fef = new FileExecutionFactory();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "text", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        fef.getMetadata(mf, null);
        Procedure p = mf.getSchema().getProcedure("getTextFiles");
        VirtualFileConnection fc = (VirtualFileConnection)Mockito.mock(VirtualFileConnection.class);
        Mockito.stub((Object)fc.getFiles("*.txt")).toReturn((Object)JavaVirtualFile.getFiles((String)"*.txt", (File)new File(UnitTestUtil.getTestDataPath(), "*.txt")));
        Call call = fef.getLanguageFactory().createCall("getTextFiles", Arrays.asList(new Argument(Argument.Direction.IN, (Expression)new Literal((Object)"*.txt", TypeFacility.RUNTIME_TYPES.STRING), TypeFacility.RUNTIME_TYPES.STRING, null)), p);
        ProcedureExecution pe = fef.createProcedureExecution(call, null, null, fc);
        pe.execute();
        int count = 0;
        while ((val = pe.next()) != null) {
            Assert.assertEquals((long)5L, (long)val.size());
            Assert.assertTrue((boolean)(val.get(3) instanceof Timestamp));
            Assert.assertEquals((Object)0L, val.get(4));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        call = fef.getLanguageFactory().createCall("getTextFiles", Arrays.asList(new Argument(Argument.Direction.IN, (Expression)new Literal((Object)"*1*", TypeFacility.RUNTIME_TYPES.STRING), TypeFacility.RUNTIME_TYPES.STRING, null)), p);
        pe = fef.createProcedureExecution(call, null, null, fc);
        Mockito.stub((Object)fc.getFiles("*1*")).toReturn((Object)JavaVirtualFile.getFiles((String)"*1*", (File)new File(UnitTestUtil.getTestDataPath(), "*1*")));
        pe.execute();
        count = 0;
        while (pe.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }
}

