/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.file;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.util.CharsetUtils;

@Translator(name="file", description="File Translator, reads contents of files or writes to them")
public class FileExecutionFactory
extends ExecutionFactory<ConnectionFactory, VirtualFileConnection> {
    public static BundleUtil UTIL = BundleUtil.getBundleUtil(FileExecutionFactory.class);
    public static final String GETTEXTFILES = "getTextFiles";
    public static final String GETFILES = "getFiles";
    public static final String SAVEFILE = "saveFile";
    public static final String DELETEFILE = "deleteFile";
    private Charset encoding = Charset.defaultCharset();
    private boolean exceptionIfFileNotFound = true;
    private boolean areFilesUsableAfterClose = true;

    public FileExecutionFactory() {
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.setSourceRequiredForMetadata(false);
    }

    @TranslatorProperty(display="File Encoding", advanced=true)
    public String getEncoding() {
        return this.encoding.name();
    }

    public void setEncoding(String encoding) {
        this.encoding = CharsetUtils.getCharset((String)encoding);
    }

    @TranslatorProperty(display="Exception if file not found", advanced=true)
    public boolean isExceptionIfFileNotFound() {
        return this.exceptionIfFileNotFound;
    }

    public void setExceptionIfFileNotFound(boolean exceptionIfFileNotFound) {
        this.exceptionIfFileNotFound = exceptionIfFileNotFound;
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, VirtualFileConnection conn) throws TranslatorException {
        return new VirtualFileProcedureExecution(command, conn);
    }

    public void getMetadata(MetadataFactory metadataFactory, VirtualFileConnection connection) throws TranslatorException {
        Procedure p = metadataFactory.addProcedure(GETTEXTFILES);
        p.setAnnotation("Returns text files that match the given path and pattern as CLOBs");
        ProcedureParameter param = metadataFactory.addProcedureParameter("pathAndPattern", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        metadataFactory.addProcedureResultSetColumn("file", "clob", p);
        metadataFactory.addProcedureResultSetColumn("filePath", "string", p);
        metadataFactory.addProcedureResultSetColumn("lastModified", "timestamp", p);
        metadataFactory.addProcedureResultSetColumn("created", "timestamp", p);
        metadataFactory.addProcedureResultSetColumn("size", "long", p);
        Procedure p1 = metadataFactory.addProcedure(GETFILES);
        p1.setAnnotation("Returns files that match the given path and pattern as BLOBs");
        param = metadataFactory.addProcedureParameter("pathAndPattern", "string", ProcedureParameter.Type.In, p1);
        param.setAnnotation("The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        metadataFactory.addProcedureResultSetColumn("file", "blob", p1);
        metadataFactory.addProcedureResultSetColumn("filePath", "string", p1);
        metadataFactory.addProcedureResultSetColumn("lastModified", "timestamp", p1);
        metadataFactory.addProcedureResultSetColumn("created", "timestamp", p1);
        metadataFactory.addProcedureResultSetColumn("size", "long", p1);
        Procedure p2 = metadataFactory.addProcedure(SAVEFILE);
        p2.setAnnotation("Saves the given value to the given path.  Any existing file will be overriden.");
        metadataFactory.addProcedureParameter("filePath", "string", ProcedureParameter.Type.In, p2);
        param = metadataFactory.addProcedureParameter("file", "object", ProcedureParameter.Type.In, p2);
        param.setAnnotation("The contents to save.  Can be one of CLOB, BLOB, or XML");
        Procedure p3 = metadataFactory.addProcedure(DELETEFILE);
        p3.setAnnotation("Delete the given file path. ");
        metadataFactory.addProcedureParameter("filePath", "string", ProcedureParameter.Type.In, p3);
    }

    public boolean isSourceRequiredForCapabilities() {
        return true;
    }

    public void initCapabilities(VirtualFileConnection connection) throws TranslatorException {
        super.initCapabilities((Object)connection);
        this.areFilesUsableAfterClose = connection.areFilesUsableAfterClose();
    }

    public boolean areLobsUsableAfterClose() {
        return this.areFilesUsableAfterClose;
    }

    private final class VirtualFileProcedureExecution
    implements ProcedureExecution {
        private final Call command;
        private final VirtualFileConnection conn;
        private VirtualFile[] files = null;
        boolean isText = false;
        private int index;

        private VirtualFileProcedureExecution(Call command, VirtualFileConnection conn) {
            this.command = command;
            this.conn = conn;
        }

        public void execute() throws TranslatorException {
            block19: {
                String filePath = (String)((Argument)this.command.getArguments().get(0)).getArgumentValue().getValue();
                if (this.command.getProcedureName().equalsIgnoreCase(FileExecutionFactory.SAVEFILE)) {
                    Object file = ((Argument)this.command.getArguments().get(1)).getArgumentValue().getValue();
                    if (file == null || filePath == null) {
                        throw new TranslatorException(UTIL.getString("non_null"));
                    }
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Saving", (Object)filePath);
                    InputStream is = null;
                    Long length = null;
                    VirtualFileConnection.FileMetadata metadata = new VirtualFileConnection.FileMetadata();
                    try {
                        if (file instanceof SQLXML) {
                            is = ((SQLXML)file).getBinaryStream();
                            length = SQLXMLImpl.quickLength((SQLXML)((SQLXML)file));
                        } else if (file instanceof Clob) {
                            is = new ReaderInputStream(((Clob)file).getCharacterStream(), FileExecutionFactory.this.encoding);
                        } else if (file instanceof Blob) {
                            is = ((Blob)file).getBinaryStream();
                            length = BlobImpl.quickLength((Blob)((Blob)file));
                        } else {
                            throw new TranslatorException(UTIL.getString("unknown_type"));
                        }
                        if (length != null && length != -1L) {
                            metadata.size(length);
                        }
                        this.conn.add(is, filePath, metadata);
                    }
                    catch (SQLException | TranslatorException e) {
                        throw new TranslatorException(e, UTIL.getString("error_writing"));
                    }
                }
                if (this.command.getProcedureName().equalsIgnoreCase(FileExecutionFactory.DELETEFILE)) {
                    if (filePath == null) {
                        throw new TranslatorException(UTIL.getString("non_null"));
                    }
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Deleting", (Object)filePath);
                    try {
                        if (!this.conn.remove(filePath)) {
                            throw new TranslatorException(UTIL.getString("error_deleting"));
                        }
                        break block19;
                    }
                    catch (TranslatorException e) {
                        throw new TranslatorException(UTIL.getString("error_deleting"));
                    }
                }
                this.files = VirtualFileConnection.Util.getFiles((String)filePath, (VirtualFileConnection)this.conn, (boolean)FileExecutionFactory.this.exceptionIfFileNotFound);
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Getting", (Object)(this.files != null ? this.files.length : 0), (Object)"file(s)");
                String name = this.command.getProcedureName();
                if (name.equalsIgnoreCase(FileExecutionFactory.GETTEXTFILES)) {
                    this.isText = true;
                } else if (!name.equalsIgnoreCase(FileExecutionFactory.GETFILES)) {
                    throw new TeiidRuntimeException("Unknown procedure name " + name);
                }
            }
        }

        public List<?> next() throws TranslatorException, DataNotAvailableException {
            if (this.files == null || this.index >= this.files.length) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>(2);
            VirtualFile file = this.files[this.index++];
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Getting", (Object)file.getName());
            InputStreamFactory isf = file.createInputStreamFactory();
            BlobImpl value = null;
            if (this.isText) {
                ClobImpl clob = new ClobImpl(isf, -1L);
                clob.setCharset(FileExecutionFactory.this.encoding);
                value = clob;
            } else {
                value = new BlobImpl(isf);
            }
            result.add(value);
            result.add(file.getName());
            if (this.command.getMetadataObject().getResultSet().getColumns().size() > 2) {
                result.add(new Timestamp(file.getLastModified()));
                result.add(new Timestamp(file.getCreationTime()));
                result.add(file.getSize());
            }
            return result;
        }

        public void close() {
        }

        public void cancel() throws TranslatorException {
        }

        public List<?> getOutputParameterValues() throws TranslatorException {
            return Collections.emptyList();
        }
    }
}

