/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.file;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.core.types.BlobType;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.file.JavaVirtualFile;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.file.FileExecutionFactory;

public class TestFileExecutionFactory {
    @Test
    public void testGetTextFiles() throws Exception {
        List val;
        FileExecutionFactory fef = new FileExecutionFactory();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "text", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        fef.getMetadata(mf, null);
        Procedure p = mf.getSchema().getProcedure("getTextFiles");
        VirtualFileConnection fc = (VirtualFileConnection)Mockito.mock(VirtualFileConnection.class);
        Mockito.stub((Object)fc.getFiles("*.txt")).toReturn((Object)new VirtualFile[]{new JavaVirtualFile(UnitTestUtil.getTestDataFile((String)"file.txt")), new JavaVirtualFile(UnitTestUtil.getTestDataFile((String)"file1.txt"))});
        Call call = fef.getLanguageFactory().createCall("getTextFiles", Arrays.asList(new Argument(Argument.Direction.IN, (Expression)new Literal((Object)"*.txt", TypeFacility.RUNTIME_TYPES.STRING), TypeFacility.RUNTIME_TYPES.STRING, null)), p);
        ProcedureExecution pe = fef.createProcedureExecution(call, null, null, fc);
        pe.execute();
        int count = 0;
        while ((val = pe.next()) != null) {
            Assert.assertEquals((long)5L, (long)val.size());
            Assert.assertTrue((boolean)(val.get(3) instanceof Timestamp));
            Assert.assertEquals((Object)0L, val.get(4));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testSaveFileLength() throws Exception {
        FileExecutionFactory fef = new FileExecutionFactory();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "text", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        fef.getMetadata(mf, null);
        Procedure p = mf.getSchema().getProcedure("saveFile");
        VirtualFileConnection fc = (VirtualFileConnection)Mockito.mock(VirtualFileConnection.class);
        int length = 100;
        BlobType blob = new BlobType(new byte[length]);
        Call call = fef.getLanguageFactory().createCall("saveFile", Arrays.asList(new Argument(Argument.Direction.IN, (Expression)new Literal((Object)"path", TypeFacility.RUNTIME_TYPES.STRING), TypeFacility.RUNTIME_TYPES.STRING, null), new Argument(Argument.Direction.IN, (Expression)new Literal((Object)blob, TypeFacility.RUNTIME_TYPES.BLOB), TypeFacility.RUNTIME_TYPES.BLOB, null)), p);
        ProcedureExecution pe = fef.createProcedureExecution(call, null, null, fc);
        pe.execute();
        ArgumentCaptor argument = ArgumentCaptor.forClass(VirtualFileConnection.FileMetadata.class);
        ((VirtualFileConnection)Mockito.verify((Object)fc)).add((InputStream)Mockito.any(InputStream.class), (String)Mockito.eq((Object)"path"), (VirtualFileConnection.FileMetadata)argument.capture());
        VirtualFileConnection.FileMetadata fm = (VirtualFileConnection.FileMetadata)argument.getValue();
        Assert.assertEquals((Object)length, (Object)fm.size());
        Assert.assertNull((Object)pe.next());
    }
}

