/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.visitor;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;

public class SpreadsheetCriteriaVisitor
extends SQLStringVisitor {
    protected String worksheetKey;
    protected String criteriaQuery;
    protected SpreadsheetInfo info;
    protected String worksheetTitle;

    public SpreadsheetCriteriaVisitor(SpreadsheetInfo info) {
        this.info = info;
    }

    public void visit(Literal obj) {
        if (!this.isUpdate()) {
            super.visit(obj);
            return;
        }
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
            return;
        }
        Class type = obj.getType();
        if (Number.class.isAssignableFrom(type)) {
            this.buffer.append(obj.toString());
            return;
        }
        if (obj.getType().equals(DataTypeManager.DefaultDataClasses.DATE) || obj.getType().equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            this.buffer.append(obj.getValue().toString());
            return;
        }
        if (obj.getType().equals(DataTypeManager.DefaultDataClasses.TIME) || obj.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            throw new SpreadsheetOperationException(SpreadsheetExecutionFactory.UTIL.gs("time_not_supported", new Object[0]));
        }
        this.buffer.append("\"");
        this.buffer.append(StringUtil.replace((String)obj.getValue().toString(), (String)"\"", (String)"\"\""));
        this.buffer.append("\"");
    }

    public void visit(Like obj) {
        if (this.isUpdate()) {
            throw new SpreadsheetOperationException("Like is not supported in DELETE and UPDATE queires");
        }
        super.visit(obj);
    }

    public void visit(Function obj) {
        if (this.isUpdate()) {
            throw new SpreadsheetOperationException("Function is not supported in DELETE and UPDATE queires");
        }
        super.visit(obj);
    }

    protected String replaceElementName(String group, String element) {
        return element.toLowerCase();
    }

    public String getWorksheetKey() {
        return this.worksheetKey;
    }

    public String getCriteriaQuery() {
        return this.criteriaQuery;
    }

    public void setCriteriaQuery(String criteriaQuery) {
        this.criteriaQuery = criteriaQuery;
    }

    public String getWorksheetTitle() {
        return this.worksheetTitle;
    }

    public void translateWhere(Condition condition) {
        if (condition != null) {
            StringBuilder temp = this.buffer;
            this.buffer = new StringBuilder();
            this.append((LanguageObject)condition);
            this.criteriaQuery = this.buffer.toString();
            this.buffer = temp;
        }
    }

    public void visit(Comparison obj) {
        boolean addNot = false;
        if (!(this.isUpdate() && obj.getLeftExpression().getType() == TypeFacility.RUNTIME_TYPES.STRING || obj.getOperator() != Comparison.Operator.NE && obj.getOperator() != Comparison.Operator.LT && obj.getOperator() != Comparison.Operator.LE && (obj.getOperator() != Comparison.Operator.EQ || obj.getRightExpression() instanceof Literal))) {
            addNot = true;
            this.buffer.append("(");
        }
        super.visit(obj);
        if (addNot) {
            this.buffer.append(" AND ");
            this.visitNode((LanguageObject)obj.getLeftExpression());
            if (!this.isUpdate()) {
                this.buffer.append(" IS NOT NULL)");
            } else {
                this.buffer.append(" <> \"\")");
            }
        }
    }

    protected boolean isUpdate() {
        return true;
    }
}

