/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.visitor;

import java.util.HashMap;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;

public class SpreadsheetInsertVisitor
extends SQLStringVisitor {
    private String worksheetKey;
    private Map<String, String> columnNameValuePair;
    SpreadsheetInfo info;
    private String worksheetTitle;

    public SpreadsheetInsertVisitor(SpreadsheetInfo info) {
        this.info = info;
        this.columnNameValuePair = new HashMap<String, String>();
    }

    public void visit(Insert obj) {
        this.worksheetTitle = obj.getTable().getName();
        if (obj.getTable().getMetadataObject().getNameInSource() != null) {
            this.worksheetTitle = obj.getTable().getMetadataObject().getNameInSource();
        }
        this.worksheetKey = this.info.getWorksheetByName(this.worksheetTitle).getId();
        ExpressionValueSource evs = (ExpressionValueSource)obj.getValueSource();
        for (int i = 0; i < evs.getValues().size(); ++i) {
            Expression e = (Expression)evs.getValues().get(i);
            if (!(e instanceof Literal)) {
                throw new SpreadsheetOperationException("Only literals are allowed in the values section");
            }
            Literal l = (Literal)e;
            if (l.getValue() == null) continue;
            Class type = l.getType();
            String value = null;
            value = Number.class.isAssignableFrom(type) ? l.getValue().toString() : (type.equals(DataTypeManager.DefaultDataClasses.STRING) ? "'" + l.getValue().toString() : l.getValue().toString());
            ColumnReference columnReference = (ColumnReference)obj.getColumns().get(i);
            this.columnNameValuePair.put(columnReference.getMetadataObject().getSourceName(), value);
        }
    }

    public String getWorksheetKey() {
        return this.worksheetKey;
    }

    public Map<String, String> getColumnNameValuePair() {
        return this.columnNameValuePair;
    }

    public String getWorksheetTitle() {
        return this.worksheetTitle;
    }
}

