/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Properties;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.cdk.CommandBuilder;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.language.Update;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.google.GoogleMetadataProcessor;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.SpreadsheetOperationException;
import org.teiid.translator.google.api.UpdateSet;
import org.teiid.translator.google.api.metadata.Column;
import org.teiid.translator.google.api.metadata.SpreadsheetColumnType;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.metadata.Util;
import org.teiid.translator.google.api.metadata.Worksheet;
import org.teiid.translator.google.visitor.SpreadsheetDeleteVisitor;
import org.teiid.translator.google.visitor.SpreadsheetInsertVisitor;
import org.teiid.translator.google.visitor.SpreadsheetSQLVisitor;
import org.teiid.translator.google.visitor.SpreadsheetUpdateVisitor;

public class TestSQLtoSpreadsheetQuery {
    static SpreadsheetInfo people;

    @BeforeClass
    public static void createSpreadSheetInfo() {
        people = new SpreadsheetInfo("People");
        Worksheet worksheet = people.createWorksheet("PeopleList");
        for (int i = 1; i <= 4; ++i) {
            Column newCol = new Column();
            newCol.setAlphaName(Util.convertColumnIDtoString((int)i));
            worksheet.addColumn(newCol.getAlphaName(), newCol);
        }
        ((Column)worksheet.getColumns().get("C")).setDataType(SpreadsheetColumnType.NUMBER);
        ((Column)worksheet.getColumns().get("D")).setDataType(SpreadsheetColumnType.BOOLEAN);
    }

    private QueryMetadataInterface dummySpreadsheetMetadata() throws Exception {
        GoogleSpreadsheetConnection conn = (GoogleSpreadsheetConnection)Mockito.mock(GoogleSpreadsheetConnection.class);
        Mockito.stub((Object)conn.getSpreadsheetInfo()).toReturn((Object)people);
        MetadataFactory factory = new MetadataFactory("", (Object)1, "", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), "");
        GoogleMetadataProcessor processor = new GoogleMetadataProcessor();
        processor.process(factory, conn);
        return new TransformationMetadata(null, new CompositeMetadataStore(factory.asMetadataStore()), null, RealMetadataFactory.SFM.getSystemFunctions(), null);
    }

    public Command getCommand(String sql) throws Exception {
        CommandBuilder builder = new CommandBuilder(this.dummySpreadsheetMetadata());
        return builder.getCommand(sql);
    }

    private void testConversion(String sql, String expectedSpreadsheetQuery) throws Exception {
        Select select = (Select)this.getCommand(sql);
        SpreadsheetSQLVisitor spreadsheetVisitor = new SpreadsheetSQLVisitor(people);
        spreadsheetVisitor.translateSQL((LanguageObject)select);
        Assert.assertEquals((Object)expectedSpreadsheetQuery, (Object)spreadsheetVisitor.getTranslatedSQL());
    }

    private void testUpdateConversion(String sql, String expectedCriteria) throws Exception {
        Update update = (Update)this.getCommand(sql);
        SpreadsheetUpdateVisitor spreadsheetVisitor = new SpreadsheetUpdateVisitor(people);
        spreadsheetVisitor.visit(update);
        Assert.assertEquals((Object)expectedCriteria, (Object)spreadsheetVisitor.getCriteriaQuery());
    }

    private void testDeleteConversion(String sql, String expectedCriteria) throws Exception {
        Delete delete = (Delete)this.getCommand(sql);
        SpreadsheetDeleteVisitor spreadsheetVisitor = new SpreadsheetDeleteVisitor(people);
        spreadsheetVisitor.visit(delete);
        Assert.assertEquals((Object)expectedCriteria, (Object)spreadsheetVisitor.getCriteriaQuery());
    }

    private SpreadsheetSQLVisitor getVisitorAndTranslateSQL(String sql) throws Exception {
        Select select = (Select)this.getCommand(sql);
        SpreadsheetSQLVisitor spreadsheetVisitor = new SpreadsheetSQLVisitor(people);
        spreadsheetVisitor.translateSQL((LanguageObject)select);
        return spreadsheetVisitor;
    }

    private void testVisitorValues(SpreadsheetSQLVisitor visitor, String worksheetTitle, Integer limitValue, Integer offsetvalue) {
        Assert.assertEquals((Object)worksheetTitle, (Object)visitor.getWorksheetTitle());
        Assert.assertEquals((Object)limitValue, (Object)visitor.getLimitValue());
        Assert.assertEquals((Object)offsetvalue, (Object)visitor.getOffsetValue());
    }

    @Test
    public void testSelectFrom1() throws Exception {
        this.testConversion("select A,B from PeopleList", "SELECT A, B");
        this.testConversion("select C from PeopleList", "SELECT C");
        this.testConversion("select * from PeopleList", "SELECT A, B, C, D");
        this.testConversion("select A,B from PeopleList where A like '%car%' AND A NOT like '_car_'", "SELECT A, B WHERE A LIKE '%car%' AND (A NOT LIKE '_car_' AND A IS NOT NULL)");
        this.testConversion("select A,B from PeopleList where A='car'", "SELECT A, B WHERE A = 'car'");
        this.testConversion("select A,B from PeopleList where A >1  and B='bike'", "SELECT A, B WHERE A > '1' AND B = 'bike'");
        this.testConversion("select A,B from PeopleList where A<1 or B <> 'bike'", "SELECT A, B WHERE (A < '1' AND A IS NOT NULL) OR (B <> 'bike' AND B IS NOT NULL)");
        this.testConversion("select A,B from PeopleList limit 2", "SELECT A, B");
        this.testConversion("select A,B from PeopleList offset 2 row", "SELECT A, B");
        this.testConversion("select A,B from PeopleList limit 2,2", "SELECT A, B");
        this.testConversion("select max(A),B from PeopleList group by B", "SELECT MAX(A), B GROUP BY B");
        this.testConversion("select A,B from PeopleList where B like 'Filip%' order by B desc", "SELECT A, B WHERE B LIKE 'Filip%' ORDER BY B DESC");
        this.testConversion("select A,B from PeopleList where B like 'Filip%' order by B asc", "SELECT A, B WHERE B LIKE 'Filip%' ORDER BY B");
        this.testConversion("select A,B from PeopleList where B like 'Filip%' order by B asc", "SELECT A, B WHERE B LIKE 'Filip%' ORDER BY B");
        this.testConversion("select ucase(A),lower(B) from PeopleList", "SELECT upper(A), lower(B)");
    }

    @Test
    public void testUpdateCriteria() throws Exception {
        this.testUpdateConversion("update PeopleList set A=1 where C>1", "c > 1.0");
        this.testUpdateConversion("update PeopleList set A=1 where C=10.5", "c = 10.5");
        this.testUpdateConversion("update PeopleList set A=1 where C <= 1000 and C !=5", "(c <= 1000.0 AND c <> \"\") AND (c <> 5.0 AND c <> \"\")");
        this.testUpdateConversion("update PeopleList set A=1 where C >= 50 or C <=60.1", "c >= 50.0 OR (c <= 60.1 AND c <> \"\")");
        this.testUpdateConversion("update PeopleList set A=1 where A = 'car'", "a = \"car\"");
    }

    @Test
    public void testDeleteCriteria() throws Exception {
        this.testDeleteConversion("delete from PeopleList where C > 1", "c > 1.0");
        this.testDeleteConversion("delete from PeopleList where C=10.5", "c = 10.5");
        this.testDeleteConversion("delete from PeopleList where C <= 1000 and C !=5", "(c <= 1000.0 AND c <> \"\") AND (c <> 5.0 AND c <> \"\")");
        this.testDeleteConversion("delete from PeopleList where C >= 50 or C <=60.1", "c >= 50.0 OR (c <= 60.1 AND c <> \"\")");
        this.testDeleteConversion("delete from PeopleList where A = 'car'", "a = \"car\"");
        this.testDeleteConversion("delete from PeopleList where D = true", "d = true");
    }

    @Test
    public void testLiterals() throws Exception {
        this.helpTestExpression("1", "1");
        this.helpTestExpression("true", "TRUE");
        this.helpTestExpression("null", "NULL");
        this.helpTestExpression("{d '2001-02-02'}", "date \"2001-02-02\"");
        this.helpTestExpression("{t '02:23:34'}", "timeofday \"02:23:34\"");
        this.helpTestExpression("{ts '2012-03-04 02:23:34.10001'}", "datetime \"2012-03-04 02:23:34.100\"");
    }

    private void helpTestExpression(String expression, String expected) throws QueryParserException {
        LanguageBridgeFactory lbf = new LanguageBridgeFactory((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Expression ex = lbf.translate(QueryParser.getQueryParser().parseExpression(expression));
        SpreadsheetSQLVisitor spreadsheetVisitor = new SpreadsheetSQLVisitor(people);
        spreadsheetVisitor.translateSQL((LanguageObject)ex);
        Assert.assertEquals((Object)expected, (Object)spreadsheetVisitor.getTranslatedSQL());
    }

    @Test
    public void testSelectVisitorValues() throws Exception {
        SpreadsheetSQLVisitor visitor = this.getVisitorAndTranslateSQL("select * from PeopleList where A = 'car' limit 2");
        this.testVisitorValues(visitor, "PeopleList", 2, null);
        visitor = this.getVisitorAndTranslateSQL("select * from PeopleList where A = 'car' offset 5 row");
        this.testVisitorValues(visitor, "PeopleList", Integer.MAX_VALUE, 5);
        visitor = this.getVisitorAndTranslateSQL("select A,B from PeopleList where B like 'Filip%' order by B desc");
        this.testVisitorValues(visitor, "PeopleList", null, null);
        visitor = this.getVisitorAndTranslateSQL("select A,B from PeopleList limit 2,3");
        this.testVisitorValues(visitor, "PeopleList", 3, 2);
    }

    @Test
    public void testInsertVisitor() throws Exception {
        String sql = "insert into PeopleList(A,B,C) values ('String,String', 'String@String', 15.5)";
        SpreadsheetInsertVisitor visitor = new SpreadsheetInsertVisitor(people);
        visitor.visit((Insert)this.getCommand(sql));
        Assert.assertEquals((long)3L, (long)visitor.getColumnNameValuePair().size());
        Assert.assertEquals((Object)"'String,String", visitor.getColumnNameValuePair().get("A"));
        Assert.assertEquals((Object)"'String@String", visitor.getColumnNameValuePair().get("B"));
        Assert.assertEquals((Object)"15.5", visitor.getColumnNameValuePair().get("C"));
    }

    @Test
    public void testInsertVisitorNull() throws Exception {
        String sql = "insert into PeopleList(A,B,C) values ('String,String', null, 15.5)";
        SpreadsheetInsertVisitor visitor = new SpreadsheetInsertVisitor(people);
        visitor.visit((Insert)this.getCommand(sql));
        Assert.assertEquals((long)2L, (long)visitor.getColumnNameValuePair().size());
        Assert.assertEquals((Object)"'String,String", visitor.getColumnNameValuePair().get("A"));
        Assert.assertEquals((Object)"15.5", visitor.getColumnNameValuePair().get("C"));
    }

    @Test
    public void testUpdateVisitor() throws Exception {
        String sql = "UPDATE PeopleList set A = 'String,String', C = 1.5";
        SpreadsheetUpdateVisitor visitor = new SpreadsheetUpdateVisitor(people);
        visitor.visit((Update)this.getCommand(sql));
        Assert.assertEquals((long)2L, (long)visitor.getChanges().size());
        Assert.assertEquals((Object)"A", (Object)((UpdateSet)visitor.getChanges().get(0)).getColumnID());
        Assert.assertEquals((Object)"'String,String", (Object)((UpdateSet)visitor.getChanges().get(0)).getValue());
        Assert.assertEquals((Object)"C", (Object)((UpdateSet)visitor.getChanges().get(1)).getColumnID());
        Assert.assertEquals((Object)"1.5", (Object)((UpdateSet)visitor.getChanges().get(1)).getValue());
        Assert.assertNull((Object)visitor.getCriteriaQuery());
    }

    @Test
    public void testUpdateVisitorNull() throws Exception {
        String sql = "UPDATE PeopleList set A = 'String,String', C = null where A='Str,Str'";
        SpreadsheetUpdateVisitor visitor = new SpreadsheetUpdateVisitor(people);
        visitor.visit((Update)this.getCommand(sql));
        Assert.assertEquals((long)2L, (long)visitor.getChanges().size());
        Assert.assertEquals((Object)"A", (Object)((UpdateSet)visitor.getChanges().get(0)).getColumnID());
        Assert.assertEquals((Object)"'String,String", (Object)((UpdateSet)visitor.getChanges().get(0)).getValue());
        Assert.assertEquals((Object)"C", (Object)((UpdateSet)visitor.getChanges().get(1)).getColumnID());
        Assert.assertEquals((Object)"", (Object)((UpdateSet)visitor.getChanges().get(1)).getValue());
        Assert.assertEquals((Object)"a = \"Str,Str\"", (Object)visitor.getCriteriaQuery());
    }

    @Test(expected=SpreadsheetOperationException.class)
    public void testUpdateVisitorNullString() throws Exception {
        String sql = "UPDATE PeopleList set A = null where A='Str,Str'";
        SpreadsheetUpdateVisitor visitor = new SpreadsheetUpdateVisitor(people);
        visitor.visit((Update)this.getCommand(sql));
    }
}

