/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.Update;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.AbstractSpreadsheetExecution;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.api.GoogleSpreadsheetConnection;
import org.teiid.translator.google.api.metadata.SpreadsheetInfo;
import org.teiid.translator.google.api.result.UpdateResult;
import org.teiid.translator.google.visitor.SpreadsheetDeleteVisitor;
import org.teiid.translator.google.visitor.SpreadsheetInsertVisitor;
import org.teiid.translator.google.visitor.SpreadsheetUpdateVisitor;

public class SpreadsheetUpdateExecution
extends AbstractSpreadsheetExecution {
    public SpreadsheetUpdateExecution(Command command, GoogleSpreadsheetConnection connection, ExecutionContext context, RuntimeMetadata metadata) {
        super(command, connection, context, metadata);
        this.command = command;
        this.connection = connection;
    }

    @Override
    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)SpreadsheetExecutionFactory.UTIL.getString("cancel_query"));
    }

    public void execute() throws TranslatorException {
        if (this.command instanceof Delete) {
            this.result = this.executeDelete();
        } else if (this.command instanceof Insert) {
            this.result = this.executeInsert();
        } else if (this.command instanceof Update) {
            this.result = this.executeUpdate();
        }
    }

    private UpdateResult executeUpdate() throws TranslatorException {
        SpreadsheetInfo info = this.connection.getSpreadsheetInfo();
        SpreadsheetUpdateVisitor updateVisitor = new SpreadsheetUpdateVisitor(info);
        updateVisitor.visit((Update)this.command);
        this.checkHeaders(updateVisitor.getWorksheetTitle());
        this.result = this.connection.executeListFeedUpdate(updateVisitor.getWorksheetTitle(), updateVisitor.getCriteriaQuery(), updateVisitor.getChanges());
        return this.result;
    }

    private UpdateResult executeInsert() throws TranslatorException {
        SpreadsheetInfo info = this.connection.getSpreadsheetInfo();
        SpreadsheetInsertVisitor visitor = new SpreadsheetInsertVisitor(info);
        visitor.visit((Insert)this.command);
        this.checkHeaders(visitor.getWorksheetTitle());
        this.result = this.connection.executeRowInsert(visitor.getWorksheetKey(), visitor.getColumnNameValuePair());
        return this.result;
    }

    private UpdateResult executeDelete() throws TranslatorException {
        SpreadsheetInfo info = this.connection.getSpreadsheetInfo();
        SpreadsheetDeleteVisitor visitor = new SpreadsheetDeleteVisitor(info);
        visitor.visit((Delete)this.command);
        this.checkHeaders(visitor.getWorksheetTitle());
        this.result = this.connection.deleteRows(visitor.getWorksheetTitle(), visitor.getCriteriaQuery());
        return this.result;
    }
}

